/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.config;

import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.MethodInvoker;
import com.taobao.weex.bridge.ModuleFactory;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.utils.WXLogUtils;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.common.UniModuleAnno;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ConfigModuleFactory<T extends WXModule>
implements ModuleFactory<T> {
    public static final String TAG = "WeexScanConfigRegister";
    private String mName;
    private String mClassName;
    private String[] methods;
    private Class<T> mClazz;
    private Map<String, Invoker> mMethodMap;
    private ClassLoader mClassLoader;

    public ConfigModuleFactory(String mName, String mClassName, String[] methods) {
        this.mName = mName;
        this.mClassName = mClassName;
        this.methods = methods;
    }

    @Override
    public String[] getMethods() {
        if (this.methods == null) {
            return new String[0];
        }
        return this.methods;
    }

    @Override
    public Invoker getMethodInvoker(String name) {
        if (this.mMethodMap == null) {
            this.generateMethodMap();
        }
        return this.mMethodMap.get(name);
    }

    @Override
    public T buildInstance() throws IllegalAccessException, InstantiationException {
        if (this.mClazz == null) {
            this.mClazz = WXSDKManager.getInstance().getClassLoaderAdapter().getModuleClass(this.mName, this.mClassName, WXEnvironment.getApplication().getApplicationContext());
        }
        return (T)((WXModule)this.mClazz.newInstance());
    }

    public T buildInstance(WXSDKInstance instance) throws IllegalAccessException, InstantiationException {
        if (instance == null) {
            return this.buildInstance();
        }
        if (this.mClazz == null || this.mClassLoader != instance.getContext().getClassLoader()) {
            this.mClazz = WXSDKManager.getInstance().getClassLoaderAdapter().getModuleClass(this.mName, this.mClassName, instance.getContext());
            this.mClassLoader = instance.getContext().getClassLoader();
        }
        return (T)((WXModule)this.mClazz.newInstance());
    }

    private void generateMethodMap() {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "extractMethodNames:" + this.mClazz.getSimpleName());
        }
        HashMap<String, Invoker> methodMap = new HashMap<String, Invoker>();
        try {
            block2: for (Method method : this.mClazz.getMethods()) {
                for (Annotation anno : method.getDeclaredAnnotations()) {
                    String name;
                    Annotation methodAnnotation;
                    if (anno == null) continue;
                    if (anno instanceof JSMethod) {
                        methodAnnotation = (JSMethod)anno;
                        name = "_".equals(methodAnnotation.alias()) ? method.getName() : methodAnnotation.alias();
                        methodMap.put(name, new MethodInvoker(method, methodAnnotation.uiThread()));
                        continue block2;
                    }
                    if (anno instanceof WXModuleAnno) {
                        methodAnnotation = (WXModuleAnno)anno;
                        methodMap.put(method.getName(), new MethodInvoker(method, methodAnnotation.runOnUIThread()));
                        continue block2;
                    }
                    if (anno instanceof UniJSMethod) {
                        methodAnnotation = (UniJSMethod)anno;
                        name = "_".equals(methodAnnotation.alias()) ? method.getName() : methodAnnotation.alias();
                        methodMap.put(name, new MethodInvoker(method, methodAnnotation.uiThread()));
                        continue block2;
                    }
                    if (!(anno instanceof UniModuleAnno)) continue;
                    methodAnnotation = (UniModuleAnno)anno;
                    methodMap.put(method.getName(), new MethodInvoker(method, methodAnnotation.runOnUIThread()));
                    continue block2;
                }
            }
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXModuleManager] extractMethodNames:", e);
        }
        this.mMethodMap = methodMap;
    }

    public static ConfigModuleFactory fromConfig(JSONObject config) {
        try {
            if (config == null) {
                return null;
            }
            String name = config.getString("name");
            String className = config.getString("className");
            JSONArray methods = config.getJSONArray("methods");
            if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)className)) {
                return null;
            }
            Object[] arrays = new String[methods.size()];
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, " resolve module " + name + " className " + className + " methods " + methods);
            }
            return new ConfigModuleFactory(name, className, (String[])methods.toArray(arrays));
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, e);
            return null;
        }
    }

    public String getName() {
        return this.mName;
    }
}

