/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex;

import android.content.Context;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.taobao.weex.WXSDKInstance;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public final class WXAnalyzerDelegate {
    private Object mWXAnalyzer;
    private static boolean ENABLE = false;

    public WXAnalyzerDelegate(@Nullable Context context) {
        if (!ENABLE) {
            return;
        }
        if (context == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.taobao.weex.analyzer.WeexDevOptions");
            Constructor<?> constructor = clazz.getDeclaredConstructor(Context.class);
            this.mWXAnalyzer = constructor.newInstance(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCreate() {
        if (this.mWXAnalyzer == null) {
            return;
        }
        try {
            Method method = this.mWXAnalyzer.getClass().getDeclaredMethod("onCreate", new Class[0]);
            method.invoke(this.mWXAnalyzer, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onStart() {
        if (this.mWXAnalyzer == null) {
            return;
        }
        try {
            Method method = this.mWXAnalyzer.getClass().getDeclaredMethod("onStart", new Class[0]);
            method.invoke(this.mWXAnalyzer, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onResume() {
        if (this.mWXAnalyzer == null) {
            return;
        }
        try {
            Method method = this.mWXAnalyzer.getClass().getDeclaredMethod("onResume", new Class[0]);
            method.invoke(this.mWXAnalyzer, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPause() {
        if (this.mWXAnalyzer == null) {
            return;
        }
        try {
            Method method = this.mWXAnalyzer.getClass().getDeclaredMethod("onPause", new Class[0]);
            method.invoke(this.mWXAnalyzer, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onStop() {
        if (this.mWXAnalyzer == null) {
            return;
        }
        try {
            Method method = this.mWXAnalyzer.getClass().getDeclaredMethod("onStop", new Class[0]);
            method.invoke(this.mWXAnalyzer, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDestroy() {
        if (this.mWXAnalyzer == null) {
            return;
        }
        try {
            Method method = this.mWXAnalyzer.getClass().getDeclaredMethod("onDestroy", new Class[0]);
            method.invoke(this.mWXAnalyzer, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onWeexRenderSuccess(@Nullable WXSDKInstance instance) {
        if (this.mWXAnalyzer == null || instance == null) {
            return;
        }
        try {
            Method method = this.mWXAnalyzer.getClass().getDeclaredMethod("onWeexRenderSuccess", WXSDKInstance.class);
            method.invoke(this.mWXAnalyzer, instance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mWXAnalyzer == null) {
            return false;
        }
        try {
            Method method = this.mWXAnalyzer.getClass().getDeclaredMethod("onKeyUp", Integer.TYPE, KeyEvent.class);
            return (Boolean)method.invoke(this.mWXAnalyzer, keyCode, event);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void onException(WXSDKInstance instance, String errCode, String msg) {
        if (this.mWXAnalyzer == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)errCode) && TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        try {
            Method method = this.mWXAnalyzer.getClass().getDeclaredMethod("onException", WXSDKInstance.class, String.class, String.class);
            method.invoke(this.mWXAnalyzer, instance, errCode, msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public View onWeexViewCreated(WXSDKInstance instance, View view) {
        if (this.mWXAnalyzer == null || instance == null || view == null) {
            return null;
        }
        try {
            Method method = this.mWXAnalyzer.getClass().getDeclaredMethod("onWeexViewCreated", WXSDKInstance.class, View.class);
            View retView = (View)method.invoke(this.mWXAnalyzer, instance, view);
            return retView;
        }
        catch (Exception e) {
            e.printStackTrace();
            return view;
        }
    }
}

