/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.ViewGroup;
import com.alibaba.android.bindingx.plugin.weex.BindingX;
import com.alibaba.fastjson.JSON;
import com.facebook.common.internal.Supplier;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.taobao.weex.IWXStatisticsListener;
import com.taobao.weex.InitConfig;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.ui.SimpleComponentHolder;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IConfusionMgr;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.INativeAppInfo;
import io.dcloud.common.DHInterface.IUniInstanceMgr;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.io.UnicodeInputStream;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.IOUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.language.LanguageUtil;
import io.dcloud.feature.internal.sdk.SDK;
import io.dcloud.feature.uniapp.UniMoudlesLoader;
import io.dcloud.feature.uniapp.UniSDKInstance;
import io.dcloud.feature.weex.WXBaseWrapper;
import io.dcloud.feature.weex.WXServiceWrapper;
import io.dcloud.feature.weex.WXViewWrapper;
import io.dcloud.feature.weex.adapter.DCDefaultConfigAdapter;
import io.dcloud.feature.weex.adapter.DCWXHttpAdapter;
import io.dcloud.feature.weex.adapter.DefaultWebSocketAdapterFactory;
import io.dcloud.feature.weex.adapter.Fresco.DCGenericDraweeView;
import io.dcloud.feature.weex.adapter.FrescoDrawableLoader;
import io.dcloud.feature.weex.adapter.FrescoImageAdapter;
import io.dcloud.feature.weex.adapter.FrescoImageComponent;
import io.dcloud.feature.weex.adapter.FrescoImageComponentU;
import io.dcloud.feature.weex.adapter.JSExceptionAdapter;
import io.dcloud.feature.weex.adapter.PlusUriAdapter;
import io.dcloud.feature.weex.adapter.ScalableViewComponent;
import io.dcloud.feature.weex.adapter.webview.WXDCWeb;
import io.dcloud.feature.weex.extend.DCCoverImageComponent;
import io.dcloud.feature.weex.extend.DCCoverViewComponent;
import io.dcloud.feature.weex.extend.DCTabBarModule;
import io.dcloud.feature.weex.extend.DCUniMPModule;
import io.dcloud.feature.weex.extend.DCWXSlider;
import io.dcloud.feature.weex.extend.DCWXView;
import io.dcloud.feature.weex.extend.PlusModule;
import io.dcloud.feature.weex.extend.PlusStorageModule;
import io.dcloud.feature.weex.extend.RandomBytesModule;
import io.dcloud.feature.weex.extend.WXEventModule;
import io.dcloud.feature.weex_websocket.UniWebSocketModule;
import io.dcloud.weex.MoudlesLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class WeexInstanceMgr
implements IWXStatisticsListener,
IUniInstanceMgr {
    String TAG = "WeexInstanceMgr";
    private LinkedHashMap<String, WXViewWrapper> instanceHashMap = new LinkedHashMap(16);
    private HashMap<String, WXServiceWrapper> serviceWrapperMapsCache = new HashMap(3);
    private ArrayList<IWXStatisticsCallBack> callBacks = new ArrayList();
    private AbsMgr featureMgr;
    static final String SERVICE_NAME = "weexPlus";
    private static WeexInstanceMgr instance = null;
    private Handler mHandler;
    private String mUniNViewModules = null;
    private ArrayList<ICallBack> mReladyCallBacks = new ArrayList();
    private String complier = "weex";
    private String render = "auto";
    private String jsSACName = "uni-app-config";
    private String control = "uni-v3";
    private int mVueVersion = 2;
    private boolean isWeexInitEnd = false;
    private boolean isJsFrameworkReady = false;
    private Application mApplication = null;
    private boolean isAssetsRes = false;
    private IConfusionMgr mConfusionMgr;
    private boolean isJSFKFileNotFound = false;
    private StringBuffer sb;
    private ICallBack mRestartReadyCall;
    private boolean isUniServiceCreated = false;
    private String mPreUniAppid = null;
    private String mPreInstanceId = null;
    private Map<String, ICallBack> mPreUniMPCallBackMap = new HashMap<String, ICallBack>();

    public static synchronized WeexInstanceMgr self() {
        if (instance == null) {
            instance = new WeexInstanceMgr();
        }
        return instance;
    }

    public void setUniNViewModules(String modules) {
        this.mUniNViewModules = modules;
        if (this.mReladyCallBacks.size() > 0) {
            for (ICallBack callBack : this.mReladyCallBacks) {
                callBack.onCallBack(0, (Object)modules);
            }
            this.mReladyCallBacks.clear();
        }
    }

    public String getUniNViewModules() {
        return this.mUniNViewModules;
    }

    public void setUniNViewModuleReladyCallBack(ICallBack callBack) {
        if (!this.mReladyCallBacks.contains(callBack)) {
            this.mReladyCallBacks.add(callBack);
        }
    }

    void init(AbsMgr featureMgr) {
        this.featureMgr = featureMgr;
    }

    public String getUniMPFeature() {
        return "UniMP".toLowerCase(Locale.ENGLISH);
    }

    public void initWeexEnv(INativeAppInfo info) {
        if (info != null) {
            this.mConfusionMgr = info.getCofusionMgr();
            this.initWeexEnv(info.getApplication());
        }
    }

    public void initWeexEnv(Application application) {
        if (!SDK.isUniMPSDK()) {
            PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex.WeexDevtoolImpl", (String)"registerReloadReceiver", null, (Class[])new Class[]{Application.class}, (Object[])new Object[]{application});
        }
        WeexInstanceMgr.self().setApplication(application);
        if (!WXSDKEngine.isInitialized()) {
            InitConfig.Builder weexHuilder = new InitConfig.Builder();
            WeexInstanceMgr.self().initAppForPath((Context)application, null);
            WeexInstanceMgr.self().initJSFramework((Context)application, null);
            if (!SDK.isUniMPSDK()) {
                PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex.WeexDevtoolImpl", (String)"initDebugEnvironment", null, (Class[])new Class[]{Application.class}, (Object[])new Object[]{application});
            }
            weexHuilder.setHttpAdapter(new DCWXHttpAdapter());
            Fresco.initialize((Context)application);
            DCGenericDraweeView.initialize((Supplier<? extends AbstractDraweeControllerBuilder>)Fresco.getDraweeControllerBuilderSupplier());
            weexHuilder.setImgAdapter(new FrescoImageAdapter());
            weexHuilder.setDrawableLoader(new FrescoDrawableLoader((Context)application));
            weexHuilder.setURIAdapter(new PlusUriAdapter());
            weexHuilder.setWebSocketAdapterFactory(new DefaultWebSocketAdapterFactory());
            weexHuilder.setJSExceptionAdapter(new JSExceptionAdapter());
            InitConfig config = weexHuilder.build();
            WXSDKManager.getInstance().setWxConfigAdapter(new DCDefaultConfigAdapter());
            WXSDKEngine.initialize(application, config);
            WeexInstanceMgr.self().initStatisticsListener();
            try {
                String serviceScript = new String(PlatformUtil.getFileContent((String)"io/dcloud/weexUniJs.js", (int)1));
                this.sb = new StringBuffer();
                String param = WeexInstanceMgr.self().getConfigParam();
                this.sb.append("var plusContext = {};plusContext.getLocationHerf = function(plus){\n    return plus.weex.config.bundleUrl;\n};var param = " + param + ";");
                this.sb.append(serviceScript);
                WXSDKEngine.registerComponent("image", FrescoImageComponent.class);
                WXSDKEngine.registerComponent("cover-view", DCCoverViewComponent.class);
                WXSDKEngine.registerComponent("u-image", FrescoImageComponentU.class);
                WXSDKEngine.registerComponent("cover-image", DCCoverImageComponent.class);
                WXSDKEngine.registerComponent(new SimpleComponentHolder(ScalableViewComponent.class, new ScalableViewComponent.Ceator()), false, "u-scalable");
                WXSDKEngine.registerComponent(new SimpleComponentHolder(DCWXSlider.class, new DCWXSlider.Creator()), true, "slider");
                WXSDKEngine.registerComponent(new SimpleComponentHolder(DCWXView.class, new DCWXView.Ceator()), false, "view");
                WXSDKEngine.registerComponent("u-web-view", WXDCWeb.class);
                WXSDKEngine.registerModule("plus", PlusModule.class);
                WXSDKEngine.registerModule("DCloud-Crypto", RandomBytesModule.class);
                WXSDKEngine.registerModule("plusstorage", PlusStorageModule.class);
                WXSDKEngine.registerModule("uni-tabview", DCTabBarModule.class);
                this.addComponentByName("div", ScalableViewComponent.class);
                if (PdrUtil.isUniMPHostForUniApp() && !SDK.isUniMPSDK()) {
                    WXSDKEngine.registerModule("uniMP", DCUniMPModule.class);
                }
                WXSDKEngine.registerModule("event", WXEventModule.class);
                if (this.sb != null) {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    WXSDKEngine.registerService(SERVICE_NAME, this.sb.toString(), options);
                }
                if (!SDK.isUniMPSDK()) {
                    WeexInstanceMgr.self().registerUniappService((Context)application, "");
                }
                Typeface typeface = Typeface.createFromAsset((AssetManager)application.getAssets(), (String)"fonts/unincomponents.ttf");
                WXEnvironment.setGlobalFontFamily("unincomponents", typeface);
                WXSDKEngine.registerModule("uni-webSocket", UniWebSocketModule.class);
                BindingX.register();
                this.registerReflexWeexPlugin((Context)application);
                this.setWeexInitEnd(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setApplication(Application mApplication) {
        this.mApplication = mApplication;
    }

    public void restartWeex(final Application application, final ICallBack callBack, final String appid) {
        if (this.getControl().equals("uni-v3") && this.isWeexInitEnd() && !BaseInfo.isFirstRun || SDK.isUniMPSDK() && this.isWeexInitEnd()) {
            if (this.mPreInstanceId != null) {
                return;
            }
            Logger.e((String)this.TAG, (String)"restartWeex-------");
            if (this.instanceHashMap.size() > 0) {
                this.onActivityDestroy(false);
            }
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    WeexInstanceMgr.this.unRegisterUniappService();
                    WeexInstanceMgr.this.mRestartReadyCall = callBack;
                    WeexInstanceMgr.this.mApplication = application;
                    WeexInstanceMgr.this.initAppForPath((Context)WeexInstanceMgr.this.mApplication, appid);
                    WeexInstanceMgr.this.setJsFrameworkReady(false);
                    WeexInstanceMgr.this.initJSFramework((Context)application, appid);
                    WeexInstanceMgr.this.registerUniappService((Context)application, appid);
                    WXSDKEngine.restartWeex();
                }
            });
        }
    }

    public void loadWeexToAppid(Context context, String appid, boolean isErrorOpen) {
        int existVueVersion = this.getVueVersion();
        this.initAppForPath(context, appid);
        this.initJSFramework(context, appid);
        int currentVueVersion = this.getVueVersion();
        if (currentVueVersion != existVueVersion) {
            isErrorOpen = true;
        }
        if (!WXBridgeManager.getInstance().isJSFrameworkInit() || isErrorOpen) {
            this.setJsFrameworkReady(false);
            WXSDKEngine.restartWeex();
        }
    }

    public void onSubProcess(Application application) {
        MoudlesLoader.getInstance().onSubProcess(application);
    }

    public void initStatisticsListener() {
        WXSDKManager.getInstance().registerStatisticsListener(this);
    }

    private void initJSFramework(Context application, String appid) {
        InputStream inputStream = this.getAppFileStream(application, appid, BaseInfo.sConfigXML);
        if (inputStream != null) {
            try {
                String configStr = this.handleEncryptionInputStream(inputStream, application, true);
                com.alibaba.fastjson.JSONObject configJson = JSON.parseObject((String)configStr);
                if (configJson != null && configJson.containsKey((Object)"plus")) {
                    com.alibaba.fastjson.JSONObject statisticsJson;
                    com.alibaba.fastjson.JSONObject plusJson = configJson.getJSONObject("plus");
                    if (plusJson != null && plusJson.containsKey((Object)"uni-app")) {
                        com.alibaba.fastjson.JSONObject uniappconfig = plusJson.getJSONObject("uni-app");
                        WeexInstanceMgr.self().control = "uni-v3";
                        if (uniappconfig.containsKey((Object)"renderer")) {
                            WeexInstanceMgr.self().render = uniappconfig.getString("renderer");
                        }
                        if (uniappconfig.containsKey((Object)"nvueCompiler")) {
                            WeexInstanceMgr.self().complier = uniappconfig.getString("nvueCompiler");
                        }
                        WeexInstanceMgr.self().mVueVersion = uniappconfig.containsKey((Object)"vueVersion") ? uniappconfig.getIntValue("vueVersion") : 2;
                        if (uniappconfig.containsKey((Object)"useJSProcess")) {
                            String processStr = uniappconfig.getString("useJSProcess");
                            if ("false".equals(processStr)) {
                                WXBridgeManager.getInstance().setUseSingleProcess(true);
                            } else {
                                WXBridgeManager.getInstance().setUseSingleProcess(false);
                            }
                        }
                    }
                    if (plusJson != null && plusJson.containsKey((Object)"uniStatistics") && (statisticsJson = plusJson.getJSONObject("uniStatistics")) != null) {
                        com.alibaba.fastjson.JSONObject us = new com.alibaba.fastjson.JSONObject();
                        try {
                            if (statisticsJson.containsKey((Object)"enable")) {
                                us.put("enable", statisticsJson.get((Object)"enable"));
                            }
                            if (statisticsJson.containsKey((Object)"version")) {
                                us.put("version", statisticsJson.get((Object)"version"));
                            }
                            if (statisticsJson.containsKey((Object)"uniCloud")) {
                                com.alibaba.fastjson.JSONObject uniCloud = statisticsJson.getJSONObject("uniCloud");
                                us.put("uniCloud", (Object)uniCloud);
                            }
                            AppRuntime.setUniStatistics((String)us.toJSONString());
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private InputStream getAppFileStream(Context context, String appid, String fileName) {
        InputStream inputStream;
        block12: {
            inputStream = null;
            try {
                AndroidResources.initAndroidResources((Context)context);
                if (TextUtils.isEmpty((CharSequence)appid)) {
                    BaseInfo.parseControl();
                } else {
                    BaseInfo.sDefaultBootApp = appid;
                }
                boolean useSdcardPath = BaseInfo.ISDEBUG || DHFile.hasFile();
                String filePath = "apps/" + BaseInfo.sDefaultBootApp + "/www/" + fileName;
                if (this.isAssetsRes && !BaseInfo.SyncDebug && !SDK.isUniMPSDK()) {
                    try {
                        inputStream = context.getResources().getAssets().open(filePath);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (inputStream != null) break block12;
                String rootPath = "";
                rootPath = useSdcardPath ? Environment.getExternalStorageDirectory().getPath() + "/Android/data/" + context.getPackageName() : context.getFilesDir().getPath();
                File pathFile = new File(rootPath + "/" + filePath);
                InputStream fcIStream = null;
                if (pathFile.exists()) {
                    fcIStream = new FileInputStream(pathFile);
                } else {
                    try {
                        fcIStream = context.getResources().getAssets().open(filePath);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (fcIStream != null) {
                    inputStream = fcIStream;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return inputStream;
    }

    public void initAppForPath(Context context, String appid) {
        this.isAssetsRes = AppRuntime.isAppResourcesInAssetsPath((Context)context, (String)appid);
    }

    private String handleEncryptionInputStream(InputStream inputStream, Context context, boolean isCode) {
        long time = System.currentTimeMillis();
        if (isCode) {
            inputStream = new UnicodeInputStream(inputStream, Charset.defaultCharset().name());
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = IOUtil.getBytes((InputStream)inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String configStr = null;
        if (this.mConfusionMgr != null) {
            configStr = this.mConfusionMgr.handleEncryption(context.getApplicationContext(), bytes);
        }
        if (TextUtils.isEmpty(configStr)) {
            configStr = new String(bytes);
        }
        return configStr;
    }

    public void registerUniappService(Context context, String appid) {
        if (WeexInstanceMgr.self().control.equals("uni-v3")) {
            InputStream inputStream = WeexInstanceMgr.self().getAppFileStream(context, appid, "app-config-service.js");
            if (inputStream != null) {
                try {
                    String configStr = this.handleEncryptionInputStream(inputStream, context, false);
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    WXSDKEngine.registerService(this.jsSACName, configStr, options);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return;
        }
    }

    public boolean isUniAppAssetsRes() {
        return this.isAssetsRes;
    }

    private void unRegisterUniappService() {
        WXSDKEngine.unRegisterService(this.jsSACName);
    }

    private void registerReflexWeexPlugin(Context context) {
        PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex_amap.AMapPluginImpl", (String)"initPlugin", null, (Class[])new Class[]{Context.class}, (Object[])new Object[]{context});
        PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex.map.google.GoogleMapPluginImpl", (String)"initPlugin", null, (Class[])new Class[]{Context.class}, (Object[])new Object[]{context});
        PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex_scroller.DCScrollerPluginImpl", (String)"initPlugin", null, (Class[])new Class[]{Context.class}, (Object[])new Object[]{context});
        PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex_barcode.BarcodePlugin", (String)"initPlugin", null, (Class[])new Class[]{Context.class}, (Object[])new Object[]{context});
        PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex_livepusher.LivePusherPlugin", (String)"initPlugin", null, (Class[])new Class[]{Context.class}, (Object[])new Object[]{context});
        PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex_media.VideoPlayerPlugin", (String)"initPlugin", null, (Class[])new Class[]{Context.class}, (Object[])new Object[]{context});
        PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex_text.DCWXTextPlugin", (String)"initPlugin", null, (Class[])new Class[]{Context.class}, (Object[])new Object[]{context});
        PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex_input.DCWXInputRegister", (String)"initPlugin", null, (Class[])new Class[]{Context.class}, (Object[])new Object[]{context});
        PlatformUtil.invokeMethod((String)"io.dcloud.feature.gcanvas.GCanvasRegister", (String)"initPlugin", null, (Class[])new Class[]{Context.class}, (Object[])new Object[]{context});
        PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex_switch.DCWXSwitchPlugin", (String)"initPlugin", null, (Class[])new Class[]{Context.class}, (Object[])new Object[]{context});
        PlatformUtil.invokeMethod((String)"io.dcloud.feature.weex_ad.DCWXAdPlugin", (String)"initPlugin", null, (Class[])new Class[]{Context.class}, (Object[])new Object[]{context});
        Object sMaps = PlatformUtil.invokeFieldValue((String)"com.taobao.weex.devtools.inspector.elements.android.WXComponentDescriptor", (String)"sClassName", null);
        if (sMaps != null && sMaps instanceof HashMap) {
            HashMap map = (HashMap)sMaps;
            map.put(FrescoImageComponent.class, "image");
            map.put(FrescoImageComponentU.class, "image");
            map.put(WXDCWeb.class, "web-view");
            map.put(DCWXView.class, "view");
            map.put(DCCoverViewComponent.class, "cover-view");
            map.put(DCWXSlider.class, "slider");
        }
    }

    public void addComponentByName(String name, Class component) {
        try {
            Object sMaps = PlatformUtil.invokeFieldValue((String)"com.taobao.weex.devtools.inspector.elements.android.WXComponentDescriptor", (String)"sClassName", null);
            if (sMaps != null && sMaps instanceof HashMap) {
                ((HashMap)sMaps).put(component, name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getConfigParam() {
        com.alibaba.fastjson.JSONObject param = new com.alibaba.fastjson.JSONObject();
        param.put("__HtMl_Id__", (Object)"__uniapp_webview");
        param.put("platform", (Object)1);
        param.put("debug", (Object)true);
        com.alibaba.fastjson.JSONObject osParam = new com.alibaba.fastjson.JSONObject();
        osParam.put("language", (Object)LanguageUtil.getDeviceDefLocalLanguage());
        osParam.put("version", (Object)Build.VERSION.RELEASE);
        osParam.put("name", (Object)"Android");
        osParam.put("vendor", (Object)"Google");
        param.put("os", (Object)osParam);
        com.alibaba.fastjson.JSONObject networkinfoParam = new com.alibaba.fastjson.JSONObject();
        networkinfoParam.put("CONNECTION_TYPE", (Object)0);
        param.put("networkinfo", (Object)networkinfoParam);
        return param.toJSONString();
    }

    public WXViewWrapper createWeexView(IWebview webview, ViewGroup parentView, JSONObject itme, String weexId, int zIndex) {
        WXViewWrapper wrapper = this.makeWXViewWrapper(webview, parentView, itme, weexId, zIndex);
        wrapper.loadTemplate(itme);
        return wrapper;
    }

    private WXViewWrapper makeWXViewWrapper(IWebview webview, ViewGroup parentView, JSONObject itme, String weexId, int zIndex) {
        WXSDKInstance instance;
        boolean isPre = false;
        if (weexId.equals("__uniapp__service") && this.mPreUniAppid != null && (instance = WXSDKManager.getInstance().getSDKInstance(this.mPreInstanceId)) != null) {
            isPre = true;
        }
        WXViewWrapper listener = new WXViewWrapper(webview, parentView, itme, weexId, zIndex, isPre);
        if (this.instanceHashMap.containsKey(weexId)) {
            ((WXViewWrapper)this.instanceHashMap.remove((Object)weexId)).mWXSDKInstance.destroy();
        }
        this.instanceHashMap.put(weexId, listener);
        return listener;
    }

    public WXServiceWrapper createWeexService(IApp app, ViewGroup parentView, String weexId, JSONObject data) {
        WXServiceWrapper serviceWrapper = new WXServiceWrapper(app, parentView, weexId, data);
        this.serviceWrapperMapsCache.put(weexId, serviceWrapper);
        return serviceWrapper;
    }

    WXViewWrapper findWXViewWrapper(String weexId) {
        if (this.instanceHashMap.containsKey(weexId)) {
            return this.instanceHashMap.get(weexId);
        }
        return null;
    }

    public WXServiceWrapper findWXServiceWrapper(WXSDKInstance instance) {
        if (this.serviceWrapperMapsCache.size() > 0) {
            Set<String> keys = this.serviceWrapperMapsCache.keySet();
            for (String key : keys) {
                WXServiceWrapper serviceWrapper = this.serviceWrapperMapsCache.get(key);
                if (serviceWrapper == null || serviceWrapper.mWXSDKInstance != instance) continue;
                return serviceWrapper;
            }
        }
        return null;
    }

    public void reloadWXServiceWrapper() {
        if (this.serviceWrapperMapsCache.size() > 0) {
            Set<String> keys = this.serviceWrapperMapsCache.keySet();
            for (String key : keys) {
                WXServiceWrapper serviceWrapper = this.serviceWrapperMapsCache.get(key);
                if (serviceWrapper == null) continue;
                serviceWrapper.reload();
            }
        }
    }

    public WXSDKInstance findWXSDKInstance(String weexId) {
        if (this.serviceWrapperMapsCache.containsKey(weexId)) {
            return this.serviceWrapperMapsCache.get((Object)weexId).mWXSDKInstance;
        }
        if (this.instanceHashMap.containsKey(weexId)) {
            return this.instanceHashMap.get((Object)weexId).mWXSDKInstance;
        }
        return null;
    }

    WXBaseWrapper findWXBaseWrapper(String weexId) {
        if (this.serviceWrapperMapsCache.containsKey(weexId)) {
            return this.serviceWrapperMapsCache.get(weexId);
        }
        if (this.instanceHashMap.containsKey(weexId)) {
            return this.instanceHashMap.get(weexId);
        }
        return null;
    }

    public IWebview findWebview(IWebview webview, IApp app, String appid, String webviewid) {
        Object obj = this.featureMgr.processEvent(IMgr.MgrType.FeatureMgr, 10, (Object)new Object[]{webview != null ? webview : app, "ui", "findWebview", new String[]{appid, webviewid}});
        if (obj instanceof IWebview) {
            return (IWebview)obj;
        }
        return null;
    }

    public Object doForFeature(IMgr.MgrType type, int event, Object[] args) {
        if (this.featureMgr != null) {
            return this.featureMgr.processEvent(type, event, (Object)args);
        }
        return null;
    }

    public WXBaseWrapper findWXBaseWrapper(WXSDKInstance instance) {
        WXBaseWrapper wrapper = null;
        Set<String> webviewSet = this.instanceHashMap.keySet();
        for (String webid : webviewSet) {
            WXBaseWrapper item = this.instanceHashMap.get(webid);
            if (item == null || item.mWXSDKInstance != instance) continue;
            wrapper = item;
        }
        return wrapper;
    }

    public IWebview findWebview(WXSDKInstance instance) {
        Set<String> webviewSet = this.instanceHashMap.keySet();
        for (String webid : webviewSet) {
            WXViewWrapper wrapper = this.instanceHashMap.get(webid);
            if (wrapper == null || wrapper.mWXSDKInstance != instance) continue;
            return wrapper.mWebview;
        }
        return null;
    }

    public IWebview findWebviewByInstanceId(String instanceId) {
        Set<String> webviewSet = this.instanceHashMap.keySet();
        for (String webid : webviewSet) {
            WXViewWrapper wrapper = this.instanceHashMap.get(webid);
            if (wrapper == null || !wrapper.mWXSDKInstance.getInstanceId().equals(instanceId)) continue;
            return wrapper.mWebview;
        }
        return null;
    }

    public WXViewWrapper findPathByWrapper(String byPath) {
        WXViewWrapper wrapper = null;
        if (!TextUtils.isEmpty((CharSequence)byPath)) {
            Set<String> webviewSet = this.instanceHashMap.keySet();
            for (String webid : webviewSet) {
                WXViewWrapper wxv = this.instanceHashMap.get(webid);
                String srcPath = wxv.initSrcPath(byPath);
                String path = wxv.getSrcPath();
                if (wxv == null || TextUtils.isEmpty((CharSequence)path) || !path.equals(srcPath)) continue;
                return wxv;
            }
        }
        return wrapper;
    }

    public void removeWeexView(String weexId) {
        if (this.instanceHashMap.containsKey(weexId)) {
            WXViewWrapper wrapper = (WXViewWrapper)this.instanceHashMap.remove(weexId);
            wrapper.onDestroy();
            Object var2_2 = null;
        }
    }

    void onActivityResume() {
        this.forEach(new EachListener<WXBaseWrapper>(){

            @Override
            public void onEach(WXBaseWrapper wrapper) {
                wrapper.onActivityResume();
            }
        });
    }

    void onActivityPause() {
        this.forEach(new EachListener<WXBaseWrapper>(){

            @Override
            public void onEach(WXBaseWrapper wrapper) {
                wrapper.onActivityPause();
            }
        });
    }

    void onActivityResult(final int requestCode, final int resultCode, final Intent data) {
        this.forEach(new EachListener<WXBaseWrapper>(){

            @Override
            public void onEach(WXBaseWrapper wrapper) {
                wrapper.onActivityResult(requestCode, resultCode, data);
            }
        });
    }

    void onActivityDestroy() {
        this.onActivityDestroy(true);
    }

    void onActivityDestroy(boolean isDelay) {
        this.mPreUniAppid = null;
        this.mPreInstanceId = null;
        if (this.instanceHashMap.size() > 0 || this.serviceWrapperMapsCache.size() > 0) {
            if (isDelay) {
                this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        WeexInstanceMgr.this.wrapperDestroy();
                    }
                }, 200L);
            } else {
                this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        WeexInstanceMgr.this.wrapperDestroy();
                    }
                });
            }
        }
        this.mPreUniMPCallBackMap.clear();
        this.mApplication = null;
    }

    private void wrapperDestroy() {
        this.forEach(new EachListener<WXBaseWrapper>(){

            @Override
            public void onEach(WXBaseWrapper wrapper) {
                if (wrapper != null) {
                    wrapper.onDestroy();
                }
            }
        });
        this.instanceHashMap.clear();
        this.serviceWrapperMapsCache.clear();
        if (SDK.isUniMPSDK()) {
            this.reloadWeexEngine();
        }
    }

    private void reloadWeexEngine() {
        this.unRegisterUniappService();
        WXSDKEngine.reload();
    }

    private void forEach(EachListener listener) {
        try {
            Collection<WXServiceWrapper> serviceWrappers;
            Collection<WXViewWrapper> instances = this.instanceHashMap.values();
            if (instances != null) {
                for (WXViewWrapper wrapper : instances) {
                    if (wrapper == null) continue;
                    listener.onEach(wrapper);
                }
            }
            if ((serviceWrappers = this.serviceWrapperMapsCache.values()) != null) {
                for (WXServiceWrapper serviceWrapper : serviceWrappers) {
                    if (serviceWrapper == null) continue;
                    listener.onEach(serviceWrapper);
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)("forEach---" + e.getMessage()));
        }
    }

    public void weexDebugReload() {
        block0: {
            Set<String> webviewSet;
            Iterator<String> iterator;
            if (this.instanceHashMap == null || this.instanceHashMap.size() <= 0 || !(iterator = (webviewSet = this.instanceHashMap.keySet()).iterator()).hasNext()) break block0;
            String id2 = iterator.next();
            WXViewWrapper wrapper = this.instanceHashMap.get(id2);
            wrapper.mWebview.obtainFrameView().obtainWindowMgr().processEvent(IMgr.MgrType.AppMgr, 3, (Object)"snc:CID");
        }
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        this.forEach(new EachListener<WXBaseWrapper>(){

            @Override
            public void onEach(WXBaseWrapper wrapper) {
                if (wrapper != null) {
                    wrapper.onRequestPermissionsResult(requestCode, permissions, grantResults);
                }
            }
        });
    }

    public String getComplier() {
        return this.complier;
    }

    public String getControl() {
        return this.control;
    }

    public int getVueVersion() {
        return this.mVueVersion;
    }

    public boolean isWeexInitEnd() {
        return this.isWeexInitEnd;
    }

    public void setWeexInitEnd(boolean isEnd) {
        this.isWeexInitEnd = isEnd;
    }

    public void setJsFrameworkReady(boolean isReady) {
        this.isJsFrameworkReady = isReady;
    }

    public boolean isJsFrameworkReady() {
        return this.isJsFrameworkReady;
    }

    @Override
    public void onSDKEngineInitialize() {
    }

    @Override
    public void onJsFrameworkStart() {
    }

    @Override
    public void onJsFrameworkReady() {
        this.isJsFrameworkReady = true;
        if (this.mRestartReadyCall != null) {
            MessageHandler.sendMessage((MessageHandler.IMessages)new MessageHandler.IMessages(){

                public void execute(Object pArgs) {
                    WeexInstanceMgr.this.mRestartReadyCall.onCallBack(1, null);
                    WeexInstanceMgr.this.mRestartReadyCall = null;
                }
            }, null);
        }
        if (this.callBacks != null) {
            for (IWXStatisticsCallBack callBack : this.callBacks) {
                callBack.onJsFrameworkReady();
            }
        }
    }

    @Override
    public void onFirstView() {
    }

    @Override
    public void onFirstScreen() {
    }

    @Override
    public void onHttpStart() {
    }

    @Override
    public void onHeadersReceived() {
    }

    @Override
    public void onHttpFinish() {
    }

    @Override
    public void onException(String instanceid, String errCode, String msg) {
    }

    public void setWXStatisticsCallBack(IWXStatisticsCallBack callBack) {
        if (!this.callBacks.contains(callBack)) {
            this.callBacks.add(callBack);
        }
    }

    public void unWXStatisticsCallBack(IWXStatisticsCallBack callBack) {
        if (this.callBacks.contains(callBack)) {
            this.callBacks.remove(callBack);
        }
    }

    public boolean isUniServiceCreated(IApp app) {
        String nvueLaunchMode = app.obtainConfigProperty("nvueLaunchMode");
        if (!TextUtils.isEmpty((CharSequence)nvueLaunchMode) && !nvueLaunchMode.equals("fast") && this.getControl().equals("uni-v3")) {
            return this.isUniServiceCreated;
        }
        if (!this.getControl().equals("v8")) {
            return true;
        }
        return this.isUniServiceCreated;
    }

    public String getPreInstanceId() {
        return this.mPreInstanceId;
    }

    public String getPreUniAppid() {
        return this.mPreUniAppid;
    }

    public void setUniServiceCreated(boolean is, IApp app) {
        String mode;
        this.isUniServiceCreated = is;
        String nvueLaunchMode = "fast";
        if (app != null && !TextUtils.isEmpty((CharSequence)(mode = app.obtainConfigProperty("nvueLaunchMode")))) {
            nvueLaunchMode = mode;
        }
        if ((this.getControl().equals("v8") || !nvueLaunchMode.equals("fast") && this.getControl().equals("uni-v3")) && this.isUniServiceCreated) {
            Set<String> webviewSet = this.instanceHashMap.keySet();
            for (String webid : webviewSet) {
                WXViewWrapper wrapper = this.instanceHashMap.get(webid);
                if (wrapper == null || wrapper.isService) continue;
                wrapper.runDelayedRenderCaches(wrapper.getWaitServiceRenderList());
            }
        }
    }

    private void preUniControlService(Application context, String appid) {
        this.isUniServiceCreated = true;
        this.mPreUniAppid = appid;
        UniSDKInstance wxsdkInstance = new UniSDKInstance((Context)context);
        this.mPreInstanceId = wxsdkInstance.getInstanceId();
        String template = this.getUniFileStr((Context)context, appid, "app-service.js");
        String configJs = this.getUniFileStr((Context)context, appid, "app-config.js");
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("plus_appid", appid);
        options.put("preload", true);
        options.put("bundleUrl", "app-service.js");
        JSONObject jsonObject = new JSONObject();
        String replaceTemplate = configJs + template + " plus.weexBridge.preloadReady('" + appid + "');";
        replaceTemplate = replaceTemplate.replaceFirst(Pattern.quote("\"use weex:vue\""), Matcher.quoteReplacement(""));
        wxsdkInstance.render("__uniapp__service", replaceTemplate, options, jsonObject.toString(), WXRenderStrategy.APPEND_ASYNC);
        Logger.e((String)this.TAG, (String)("preUniControlService------" + appid));
    }

    private String getUniFileStr(Context context, String appid, String fileName) {
        InputStream inputStream = this.getAppFileStream(context, appid, fileName);
        String fileStr = null;
        try {
            fileStr = IOUtil.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileStr;
    }

    public ICallBack getPreUniMPCallBack(String appid) {
        if (this.mPreUniMPCallBackMap.containsKey(appid)) {
            return this.mPreUniMPCallBackMap.remove(appid);
        }
        return null;
    }

    public void preUniMP(final Application context, final String appid, ICallBack iCallBack) {
        if (!TextUtils.isEmpty((CharSequence)this.mPreUniAppid) && iCallBack != null) {
            iCallBack.onCallBack(-101, (Object)"");
            return;
        }
        if (iCallBack != null) {
            this.mPreUniMPCallBackMap.put(appid, iCallBack);
        }
        if (this.isWeexInitEnd()) {
            this.restartWeex(context, new ICallBack(){

                public Object onCallBack(int pType, Object pArgs) {
                    if (pType == 1) {
                        WeexInstanceMgr.this.preUniControlService(context, appid);
                    }
                    return null;
                }
            }, appid);
        } else {
            this.initWeexEnv(context);
            this.preUniControlService(context, appid);
        }
    }

    private Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    private void clearHandler() {
        if (this.mHandler != null) {
            this.mHandler = null;
        }
    }

    public void initUniappPlugin(Application application) {
        UniMoudlesLoader.getInstance().onCreate(application);
    }

    public boolean isJSFKFileNotFound() {
        return this.isJSFKFileNotFound;
    }

    public void setJSFKFileNotFound(boolean JSFKFileNotFound) {
        this.isJSFKFileNotFound = JSFKFileNotFound;
    }

    public static interface IWXStatisticsCallBack {
        public void onJsFrameworkReady();
    }

    static interface EachListener<T> {
        public void onEach(T var1);
    }
}

