/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.weex;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.utils.WXFileUtils;
import io.dcloud.feature.uniapp.UniAppHookProxy;
import io.dcloud.weex.AppHookProxy;
import java.lang.reflect.Method;

public class MoudlesLoader {
    private static MoudlesLoader sLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoudlesLoader getInstance() {
        if (sLoader != null) return sLoader;
        Class<MoudlesLoader> clazz = MoudlesLoader.class;
        synchronized (MoudlesLoader.class) {
            if (sLoader != null) return sLoader;
            sLoader = new MoudlesLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sLoader;
        }
    }

    public void onCreate(Application application) {
        JSONArray array;
        JSONObject pluginsJson = this.getPluginsValue(application);
        if (pluginsJson != null && (array = pluginsJson.getJSONArray("nativePlugins")) != null && array.size() > 0) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject moudleJson = array.getJSONObject(i);
                this.initMoudle(moudleJson, application);
            }
        }
    }

    private void initMoudle(JSONObject moudleJson, Application application) {
        JSONArray moudlesJA;
        if (moudleJson == null) {
            return;
        }
        String appProxy = moudleJson.getString("hooksClass");
        if (!TextUtils.isEmpty((CharSequence)appProxy)) {
            this.createAppMoudle(appProxy, application, true);
        }
        if ((moudlesJA = moudleJson.getJSONArray("plugins")) != null && moudlesJA != null && moudlesJA.size() > 0) {
            for (int i = 0; i < moudlesJA.size(); ++i) {
                JSONObject item = moudlesJA.getJSONObject(i);
                if (item == null) continue;
                this.registerMoudle(item.getString("name"), item.getString("class"), item.getString("type"));
            }
        }
    }

    private void createAppMoudle(String appProxy, Application application, boolean isMainProcess) {
        try {
            Class<?> c = Class.forName(appProxy);
            Object proxy = c.newInstance();
            if (proxy instanceof AppHookProxy) {
                if (isMainProcess) {
                    ((AppHookProxy)proxy).onCreate(application);
                } else if (proxy instanceof UniAppHookProxy) {
                    ((UniAppHookProxy)proxy).onSubProcessCreate(application);
                }
            } else {
                Method m = c.getMethod("onCreate", Application.class);
                if (m != null) {
                    m.setAccessible(true);
                    m.invoke(proxy, application);
                }
            }
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void registerMoudle(String moduleName, String moduleClasss, String moduleType) {
        try {
            Class<?> c = Class.forName(moduleClasss);
            if (TextUtils.isEmpty((CharSequence)moduleType) || moduleType.equalsIgnoreCase("module")) {
                WXSDKEngine.registerModule(moduleName, c);
            } else if (moduleType.equalsIgnoreCase("component")) {
                WXSDKEngine.registerComponent(moduleName, c);
            }
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private JSONObject getPluginsValue(Application application) {
        JSONObject pluginsJson = null;
        String plugins = WXFileUtils.loadAsset("dcloud_uniplugins.json", (Context)application);
        if (!TextUtils.isEmpty((CharSequence)plugins)) {
            pluginsJson = JSONObject.parseObject((String)plugins);
        }
        return pluginsJson;
    }

    public void onSubProcess(Application application) {
        JSONArray array;
        JSONObject pluginsJson = this.getPluginsValue(application);
        if (pluginsJson != null && (array = pluginsJson.getJSONArray("nativePlugins")) != null && array.size() > 0) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject moudleJson = array.getJSONObject(i);
                String appProxy = moudleJson.getString("hooksClass");
                this.createAppMoudle(appProxy, application, false);
            }
        }
    }
}

