/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FileDownloadProperties {
    private static final String KEY_HTTP_LENIENT = "http.lenient";
    private static final String KEY_PROCESS_NON_SEPARATE = "process.non-separate";
    private static final String KEY_DOWNLOAD_MIN_PROGRESS_STEP = "download.min-progress-step";
    private static final String KEY_DOWNLOAD_MIN_PROGRESS_TIME = "download.min-progress-time";
    private static final String KEY_DOWNLOAD_MAX_NETWORK_THREAD_COUNT = "download.max-network-thread-count";
    private static final String KEY_FILE_NON_PRE_ALLOCATION = "file.non-pre-allocation";
    private static final String KEY_BROADCAST_COMPLETED = "broadcast.completed";
    private static final String KEY_TRIAL_CONNECTION_HEAD_METHOD = "download.trial-connection-head-method";
    public final int downloadMinProgressStep;
    public final long downloadMinProgressTime;
    public final boolean httpLenient;
    public final boolean processNonSeparate;
    public final int downloadMaxNetworkThreadCount;
    public final boolean fileNonPreAllocation;
    public final boolean broadcastCompleted;
    public final boolean trialConnectionHeadMethod;
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";

    public static FileDownloadProperties getImpl() {
        return HolderClass.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDownloadProperties() {
        if (FileDownloadHelper.getAppContext() == null) {
            throw new IllegalStateException("Please invoke the 'FileDownloader#setup' before using FileDownloader. If you want to register some components on FileDownloader please invoke the 'FileDownloader#setupOnApplicationOnCreate' on the 'Application#onCreate' first.");
        }
        long start = System.currentTimeMillis();
        String httpLenient = null;
        String processNonSeparate = null;
        String downloadMinProgressStep = null;
        String downloadMinProgressTime = null;
        String downloadMaxNetworkThreadCount = null;
        String fileNonPreAllocation = null;
        String broadcastCompleted = null;
        String downloadTrialConnectionHeadMethod = null;
        Properties p = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = FileDownloadHelper.getAppContext().getAssets().open("filedownloader.properties");
            if (inputStream != null) {
                p.load(inputStream);
                httpLenient = p.getProperty(KEY_HTTP_LENIENT);
                processNonSeparate = p.getProperty(KEY_PROCESS_NON_SEPARATE);
                downloadMinProgressStep = p.getProperty(KEY_DOWNLOAD_MIN_PROGRESS_STEP);
                downloadMinProgressTime = p.getProperty(KEY_DOWNLOAD_MIN_PROGRESS_TIME);
                downloadMaxNetworkThreadCount = p.getProperty(KEY_DOWNLOAD_MAX_NETWORK_THREAD_COUNT);
                fileNonPreAllocation = p.getProperty(KEY_FILE_NON_PRE_ALLOCATION);
                broadcastCompleted = p.getProperty(KEY_BROADCAST_COMPLETED);
                downloadTrialConnectionHeadMethod = p.getProperty(KEY_TRIAL_CONNECTION_HEAD_METHOD);
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(FileDownloadProperties.class, "not found filedownloader.properties", new Object[0]);
                }
            } else {
                e.printStackTrace();
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (httpLenient != null) {
            if (!httpLenient.equals(TRUE_STRING) && !httpLenient.equals(FALSE_STRING)) {
                throw new IllegalStateException(FileDownloadUtils.formatString("the value of '%s' must be '%s' or '%s'", KEY_HTTP_LENIENT, TRUE_STRING, FALSE_STRING));
            }
            this.httpLenient = httpLenient.equals(TRUE_STRING);
        } else {
            this.httpLenient = false;
        }
        if (processNonSeparate != null) {
            if (!processNonSeparate.equals(TRUE_STRING) && !processNonSeparate.equals(FALSE_STRING)) {
                throw new IllegalStateException(FileDownloadUtils.formatString("the value of '%s' must be '%s' or '%s'", KEY_PROCESS_NON_SEPARATE, TRUE_STRING, FALSE_STRING));
            }
            this.processNonSeparate = processNonSeparate.equals(TRUE_STRING);
        } else {
            this.processNonSeparate = false;
        }
        if (downloadMinProgressStep != null) {
            int processDownloadMinProgressStep = Integer.valueOf(downloadMinProgressStep);
            this.downloadMinProgressStep = processDownloadMinProgressStep = Math.max(0, processDownloadMinProgressStep);
        } else {
            this.downloadMinProgressStep = 65536;
        }
        if (downloadMinProgressTime != null) {
            long processDownloadMinProgressTime = Long.valueOf(downloadMinProgressTime);
            this.downloadMinProgressTime = processDownloadMinProgressTime = Math.max(0L, processDownloadMinProgressTime);
        } else {
            this.downloadMinProgressTime = 2000L;
        }
        this.downloadMaxNetworkThreadCount = downloadMaxNetworkThreadCount != null ? FileDownloadProperties.getValidNetworkThreadCount(Integer.valueOf(downloadMaxNetworkThreadCount)) : 3;
        if (fileNonPreAllocation != null) {
            if (!fileNonPreAllocation.equals(TRUE_STRING) && !fileNonPreAllocation.equals(FALSE_STRING)) {
                throw new IllegalStateException(FileDownloadUtils.formatString("the value of '%s' must be '%s' or '%s'", KEY_FILE_NON_PRE_ALLOCATION, TRUE_STRING, FALSE_STRING));
            }
            this.fileNonPreAllocation = fileNonPreAllocation.equals(TRUE_STRING);
        } else {
            this.fileNonPreAllocation = false;
        }
        if (broadcastCompleted != null) {
            if (!broadcastCompleted.equals(TRUE_STRING) && !broadcastCompleted.equals(FALSE_STRING)) {
                throw new IllegalStateException(FileDownloadUtils.formatString("the value of '%s' must be '%s' or '%s'", KEY_BROADCAST_COMPLETED, TRUE_STRING, FALSE_STRING));
            }
            this.broadcastCompleted = broadcastCompleted.equals(TRUE_STRING);
        } else {
            this.broadcastCompleted = false;
        }
        if (downloadTrialConnectionHeadMethod != null) {
            if (!downloadTrialConnectionHeadMethod.equals(TRUE_STRING) && !downloadTrialConnectionHeadMethod.equals(FALSE_STRING)) {
                throw new IllegalStateException(FileDownloadUtils.formatString("the value of '%s' must be '%s' or '%s'", KEY_TRIAL_CONNECTION_HEAD_METHOD, TRUE_STRING, FALSE_STRING));
            }
            this.trialConnectionHeadMethod = downloadTrialConnectionHeadMethod.equals(TRUE_STRING);
        } else {
            this.trialConnectionHeadMethod = false;
        }
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.i(FileDownloadProperties.class, "init properties %d\n load properties: %s=%B; %s=%B; %s=%d; %s=%d; %s=%d; %s=%B; %s=%B; %s=%B", System.currentTimeMillis() - start, KEY_HTTP_LENIENT, this.httpLenient, KEY_PROCESS_NON_SEPARATE, this.processNonSeparate, KEY_DOWNLOAD_MIN_PROGRESS_STEP, this.downloadMinProgressStep, KEY_DOWNLOAD_MIN_PROGRESS_TIME, this.downloadMinProgressTime, KEY_DOWNLOAD_MAX_NETWORK_THREAD_COUNT, this.downloadMaxNetworkThreadCount, KEY_FILE_NON_PRE_ALLOCATION, this.fileNonPreAllocation, KEY_BROADCAST_COMPLETED, this.broadcastCompleted, KEY_TRIAL_CONNECTION_HEAD_METHOD, this.trialConnectionHeadMethod);
        }
    }

    public static int getValidNetworkThreadCount(int requireCount) {
        int maxValidNetworkThreadCount = 12;
        int minValidNetworkThreadCount = 1;
        if (requireCount > maxValidNetworkThreadCount) {
            FileDownloadLog.w(FileDownloadProperties.class, "require the count of network thread  is %d, what is more than the max valid count(%d), so adjust to %d auto", requireCount, maxValidNetworkThreadCount, maxValidNetworkThreadCount);
            return maxValidNetworkThreadCount;
        }
        if (requireCount < minValidNetworkThreadCount) {
            FileDownloadLog.w(FileDownloadProperties.class, "require the count of network thread  is %d, what is less than the min valid count(%d), so adjust to %d auto", requireCount, minValidNetworkThreadCount, minValidNetworkThreadCount);
            return minValidNetworkThreadCount;
        }
        return requireCount;
    }

    public static class HolderClass {
        private static final FileDownloadProperties INSTANCE = new FileDownloadProperties();
    }
}

