/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.VariantEmoji;
import com.vanniktech.emoji.emoji.Emoji;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class VariantEmojiManager
implements VariantEmoji {
    private static final String PREFERENCE_NAME = "variant-emoji-manager";
    private static final String EMOJI_DELIMITER = "~";
    private static final String VARIANT_EMOJIS = "variant-emojis";
    static final int EMOJI_GUESS_SIZE = 5;
    @NonNull
    private final Context context;
    @NonNull
    private List<Emoji> variantsList = new ArrayList<Emoji>(0);

    public VariantEmojiManager(@NonNull Context context) {
        this.context = context.getApplicationContext();
    }

    @Override
    @NonNull
    public Emoji getVariant(Emoji desiredEmoji) {
        if (this.variantsList.isEmpty()) {
            this.initFromSharedPreferences();
        }
        Emoji baseEmoji = desiredEmoji.getBase();
        for (int i = 0; i < this.variantsList.size(); ++i) {
            Emoji emoji = this.variantsList.get(i);
            if (!baseEmoji.equals(emoji.getBase())) continue;
            return emoji;
        }
        return desiredEmoji;
    }

    @Override
    public void addVariant(@NonNull Emoji newVariant) {
        Emoji newVariantBase = newVariant.getBase();
        for (int i = 0; i < this.variantsList.size(); ++i) {
            Emoji variant = this.variantsList.get(i);
            if (!variant.getBase().equals(newVariantBase)) continue;
            if (variant.equals(newVariant)) {
                return;
            }
            this.variantsList.remove(i);
            this.variantsList.add(newVariant);
            return;
        }
        this.variantsList.add(newVariant);
    }

    @Override
    public void persist() {
        if (this.variantsList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder(this.variantsList.size() * 5);
            for (int i = 0; i < this.variantsList.size(); ++i) {
                stringBuilder.append(this.variantsList.get(i).getUnicode()).append(EMOJI_DELIMITER);
            }
            stringBuilder.setLength(stringBuilder.length() - EMOJI_DELIMITER.length());
            this.getPreferences().edit().putString(VARIANT_EMOJIS, stringBuilder.toString()).apply();
        } else {
            this.getPreferences().edit().remove(VARIANT_EMOJIS).apply();
        }
    }

    private void initFromSharedPreferences() {
        String savedRecentVariants = this.getPreferences().getString(VARIANT_EMOJIS, "");
        if (savedRecentVariants.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(savedRecentVariants, EMOJI_DELIMITER);
            this.variantsList = new ArrayList<Emoji>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken();
                Emoji emoji = EmojiManager.getInstance().findEmoji(token);
                if (emoji == null || emoji.getLength() != token.length()) continue;
                this.variantsList.add(emoji);
            }
        }
    }

    private SharedPreferences getPreferences() {
        return this.context.getSharedPreferences(PREFERENCE_NAME, 0);
    }
}

