/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.musictools;

import com.jinmingyunle.midiplaylib.midifile.MidiFileException;
import com.jinmingyunle.midiplaylib.musictools.NoteDuration;
import java.io.Serializable;

public class TimeSignature
implements Serializable {
    private int numerator;
    private int denominator;
    private int quarternote;
    private int measure;
    private int tempo;

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getQuarter() {
        return this.quarternote;
    }

    public int getMeasure() {
        return this.measure;
    }

    public int getTempo() {
        return this.tempo;
    }

    public TimeSignature(int numerator, int denominator, int quarternote, int tempo) {
        if (numerator <= 0 || denominator <= 0 || quarternote <= 0) {
            throw new MidiFileException("Invalid time signature", 0);
        }
        if (numerator == 5) {
            numerator = 4;
        }
        this.numerator = numerator;
        this.denominator = denominator;
        this.quarternote = quarternote;
        this.tempo = tempo;
        int beat = denominator < 4 ? quarternote * 2 : quarternote / (denominator / 4);
        this.measure = numerator * beat;
    }

    public int GetMeasure(int time) {
        return time / this.measure;
    }

    public NoteDuration GetNoteDuration(int duration) {
        int whole = this.quarternote * 4;
        if (duration >= 28 * whole / 32) {
            return NoteDuration.Whole;
        }
        if (duration >= 20 * whole / 32) {
            return NoteDuration.DottedHalf;
        }
        if (duration >= 14 * whole / 32) {
            return NoteDuration.Half;
        }
        if (duration >= 10 * whole / 32) {
            return NoteDuration.DottedQuarter;
        }
        if (duration >= 7 * whole / 32) {
            return NoteDuration.Quarter;
        }
        if (duration >= 5 * whole / 32) {
            return NoteDuration.DottedEighth;
        }
        if (duration >= 6 * whole / 64) {
            return NoteDuration.Eighth;
        }
        if (duration >= 5 * whole / 64) {
            return NoteDuration.Triplet;
        }
        if (duration >= 3 * whole / 64) {
            return NoteDuration.Sixteenth;
        }
        return NoteDuration.ThirtySecond;
    }

    public static NoteDuration GetStemDuration(NoteDuration dur) {
        if (dur == NoteDuration.DottedHalf) {
            return NoteDuration.Half;
        }
        if (dur == NoteDuration.DottedQuarter) {
            return NoteDuration.Quarter;
        }
        if (dur == NoteDuration.DottedEighth) {
            return NoteDuration.Eighth;
        }
        return dur;
    }

    public int DurationToTime(NoteDuration dur) {
        int eighth = this.quarternote / 2;
        int sixteenth = eighth / 2;
        switch (dur) {
            case Whole: {
                return this.quarternote * 4;
            }
            case DottedHalf: {
                return this.quarternote * 3;
            }
            case Half: {
                return this.quarternote * 2;
            }
            case DottedQuarter: {
                return 3 * eighth;
            }
            case Quarter: {
                return this.quarternote;
            }
            case DottedEighth: {
                return 3 * sixteenth;
            }
            case Eighth: {
                return eighth;
            }
            case Triplet: {
                return this.quarternote / 3;
            }
            case Sixteenth: {
                return sixteenth;
            }
            case ThirtySecond: {
                return sixteenth / 2;
            }
        }
        return 0;
    }

    public String toString() {
        return String.format("TimeSignature=%1$s/%2$s quarter=%3$s tempo=%4$s", this.numerator, this.denominator, this.quarternote, this.tempo);
    }
}

