/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.sheetmusic;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import com.jinmingyunle.midiplaylib.midifile.MidiOptions;
import com.jinmingyunle.midiplaylib.sheetmusic.KeySignature;
import com.jinmingyunle.midiplaylib.sheetmusic.SheetMusic;
import com.jinmingyunle.midiplaylib.symbol.AccidSymbol;
import com.jinmingyunle.midiplaylib.symbol.BarSymbol;
import com.jinmingyunle.midiplaylib.symbol.ChordSymbol;
import com.jinmingyunle.midiplaylib.symbol.Clef;
import com.jinmingyunle.midiplaylib.symbol.ClefSymbol;
import com.jinmingyunle.midiplaylib.symbol.LyricSymbol;
import com.jinmingyunle.midiplaylib.symbol.MusicSymbol;
import java.util.ArrayList;

public class Staff {
    private ArrayList<MusicSymbol> symbols;
    private ArrayList<LyricSymbol> lyrics;
    private int ytop;
    private ClefSymbol clefsym;
    private AccidSymbol[] keys;
    private boolean showMeasures;
    private int keysigWidth;
    private int width;
    private int height;
    private int tracknum;
    private int totaltracks;
    private int starttime;
    private int endtime;
    private int measureLength;

    public Staff(ArrayList<MusicSymbol> symbols, KeySignature key, MidiOptions options, int tracknum, int totaltracks) {
        this.keysigWidth = SheetMusic.KeySignatureWidth(key);
        this.tracknum = tracknum;
        this.totaltracks = totaltracks;
        this.showMeasures = options.showMeasures && tracknum == 0;
        this.measureLength = options.time != null ? options.time.getMeasure() : options.defaultTime.getMeasure();
        Clef clef = this.FindClef(symbols);
        this.clefsym = new ClefSymbol(clef, 0, false);
        this.keys = key.GetSymbols(clef);
        this.symbols = symbols;
        this.CalculateWidth(options.scrollVert);
        this.CalculateHeight();
        this.CalculateStartEndTime();
        this.FullJustify();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTrack() {
        return this.tracknum;
    }

    public int getStartTime() {
        return this.starttime;
    }

    public int getEndTime() {
        return this.endtime;
    }

    public void setEndTime(int value) {
        this.endtime = value;
    }

    private Clef FindClef(ArrayList<MusicSymbol> list) {
        for (MusicSymbol m : list) {
            if (!(m instanceof ChordSymbol)) continue;
            ChordSymbol c = (ChordSymbol)m;
            return c.getClef();
        }
        return Clef.Treble;
    }

    public void CalculateHeight() {
        int above = 0;
        int below = 0;
        for (MusicSymbol s : this.symbols) {
            above = Math.max(above, s.getAboveStaff());
            below = Math.max(below, s.getBelowStaff());
        }
        above = Math.max(above, this.clefsym.getAboveStaff());
        below = Math.max(below, this.clefsym.getBelowStaff());
        if (this.showMeasures) {
            above = Math.max(above, 27);
        }
        this.ytop = above + 9;
        this.height = 45 + this.ytop + below;
        if (this.lyrics != null) {
            this.height += 13;
        }
        if (this.tracknum == this.totaltracks - 1) {
            this.height += 27;
        }
    }

    private void CalculateWidth(boolean scrollVert) {
        if (scrollVert) {
            this.width = 800;
            return;
        }
        this.width = this.keysigWidth;
        for (MusicSymbol s : this.symbols) {
            this.width += s.getWidth();
        }
    }

    private void CalculateStartEndTime() {
        this.endtime = 0;
        this.starttime = 0;
        if (this.symbols.size() == 0) {
            return;
        }
        this.starttime = this.symbols.get(0).getStartTime();
        for (MusicSymbol m : this.symbols) {
            ChordSymbol c;
            if (this.endtime < m.getStartTime()) {
                this.endtime = m.getStartTime();
            }
            if (!(m instanceof ChordSymbol) || this.endtime >= (c = (ChordSymbol)m).getEndTime()) continue;
            this.endtime = c.getEndTime();
        }
    }

    private void FullJustify() {
        if (this.width != 800) {
            return;
        }
        int totalwidth = this.keysigWidth;
        int totalsymbols = 0;
        int i = 0;
        while (i < this.symbols.size()) {
            int start = this.symbols.get(i).getStartTime();
            ++totalsymbols;
            totalwidth += this.symbols.get(i).getWidth();
            ++i;
            while (i < this.symbols.size() && this.symbols.get(i).getStartTime() == start) {
                totalwidth += this.symbols.get(i).getWidth();
                ++i;
            }
        }
        int extrawidth = (800 - totalwidth - 1) / totalsymbols;
        if (extrawidth > 18) {
            extrawidth = 18;
        }
        i = 0;
        while (i < this.symbols.size()) {
            int start = this.symbols.get(i).getStartTime();
            int newwidth = this.symbols.get(i).getWidth() + extrawidth;
            this.symbols.get(i).setWidth(newwidth);
            ++i;
            while (i < this.symbols.size() && this.symbols.get(i).getStartTime() == start) {
                ++i;
            }
        }
    }

    public void AddLyrics(ArrayList<LyricSymbol> tracklyrics) {
        if (tracklyrics == null || tracklyrics.size() == 0) {
            return;
        }
        this.lyrics = new ArrayList();
        int xpos = 0;
        int symbolindex = 0;
        for (LyricSymbol lyric : tracklyrics) {
            if (lyric.getStartTime() < this.starttime) continue;
            if (lyric.getStartTime() > this.endtime) break;
            while (symbolindex < this.symbols.size() && this.symbols.get(symbolindex).getStartTime() < lyric.getStartTime()) {
                xpos += this.symbols.get(symbolindex).getWidth();
                ++symbolindex;
            }
            lyric.setX(xpos);
            if (symbolindex < this.symbols.size() && this.symbols.get(symbolindex) instanceof BarSymbol) {
                lyric.setX(lyric.getX() + 10);
            }
            this.lyrics.add(lyric);
        }
        if (this.lyrics.size() == 0) {
            this.lyrics = null;
        }
    }

    private void DrawLyrics(Canvas canvas, Paint paint) {
        int xpos = this.keysigWidth;
        int ypos = this.height - 13;
        for (LyricSymbol lyric : this.lyrics) {
            canvas.drawText(lyric.getText(), (float)(xpos + lyric.getX()), (float)ypos, paint);
        }
    }

    private void DrawMeasureNumbers(Canvas canvas, Paint paint) {
        int xpos = this.keysigWidth;
        int ypos = this.ytop - 27;
        for (MusicSymbol s : this.symbols) {
            if (s instanceof BarSymbol) {
                int measure = 1 + s.getStartTime() / this.measureLength;
                canvas.drawText("" + measure, (float)(xpos + 5), (float)ypos, paint);
            }
            xpos += s.getWidth();
        }
    }

    private void DrawHorizLines(Canvas canvas, Paint paint) {
        int line = 1;
        int y = this.ytop - 2;
        paint.setStrokeWidth(1.0f);
        for (line = 1; line <= 5; ++line) {
            canvas.drawLine(6.0f, (float)y, (float)(this.width - 1), (float)y, paint);
            y += 9;
        }
    }

    private void DrawEndLines(Canvas canvas, Paint paint) {
        paint.setStrokeWidth(1.0f);
        int ystart = this.tracknum == 0 ? this.ytop - 2 : 0;
        int yend = this.tracknum == this.totaltracks - 1 ? this.ytop + 36 : this.height;
        canvas.drawLine(6.0f, (float)ystart, 6.0f, (float)yend, paint);
        canvas.drawLine((float)(this.width - 1), (float)ystart, (float)(this.width - 1), (float)yend, paint);
    }

    public void Draw(Canvas canvas, Rect clip, Paint paint) {
        paint.setColor(-16777216);
        int xpos = 11;
        canvas.translate((float)xpos, 0.0f);
        this.clefsym.Draw(canvas, paint, this.ytop);
        canvas.translate((float)(-xpos), 0.0f);
        xpos += this.clefsym.getWidth();
        for (AccidSymbol a : this.keys) {
            canvas.translate((float)xpos, 0.0f);
            a.Draw(canvas, paint, this.ytop);
            canvas.translate((float)(-xpos), 0.0f);
            xpos += a.getWidth();
        }
        for (MusicSymbol s : this.symbols) {
            if (xpos <= clip.left + clip.width() + 50 && xpos + s.getWidth() + 50 >= clip.left) {
                canvas.translate((float)xpos, 0.0f);
                s.Draw(canvas, paint, this.ytop);
                canvas.translate((float)(-xpos), 0.0f);
            }
            xpos += s.getWidth();
        }
        paint.setColor(-16777216);
        this.DrawHorizLines(canvas, paint);
        this.DrawEndLines(canvas, paint);
        if (this.showMeasures) {
            this.DrawMeasureNumbers(canvas, paint);
        }
        if (this.lyrics != null) {
            this.DrawLyrics(canvas, paint);
        }
    }

    public int ShadeNotes(Canvas canvas, Paint paint, int shade, int currentPulseTime, int prevPulseTime, int x_shade) {
        if (!(this.starttime <= prevPulseTime && this.endtime >= prevPulseTime || this.starttime <= currentPulseTime && this.endtime >= currentPulseTime)) {
            return x_shade;
        }
        int xpos = this.keysigWidth;
        MusicSymbol curr = null;
        ChordSymbol prevChord = null;
        int prev_xpos = 0;
        for (int i = 0; i < this.symbols.size(); ++i) {
            ChordSymbol chord;
            curr = this.symbols.get(i);
            if (curr instanceof BarSymbol) {
                xpos += curr.getWidth();
                continue;
            }
            int start = curr.getStartTime();
            int end = 0;
            end = i + 2 < this.symbols.size() && this.symbols.get(i + 1) instanceof BarSymbol ? this.symbols.get(i + 2).getStartTime() : (i + 1 < this.symbols.size() ? this.symbols.get(i + 1).getStartTime() : this.endtime);
            if (start > prevPulseTime && start > currentPulseTime) {
                if (x_shade == 0) {
                    x_shade = xpos;
                }
                return x_shade;
            }
            if (start <= currentPulseTime && currentPulseTime < end && start <= prevPulseTime && prevPulseTime < end) {
                x_shade = xpos;
                return x_shade;
            }
            boolean redrawLines = false;
            if (start <= prevPulseTime && prevPulseTime < end) {
                canvas.translate((float)(xpos - 2), -2.0f);
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(-1);
                canvas.drawRect(0.0f, 0.0f, (float)(curr.getWidth() + 4), (float)(this.getHeight() + 4), paint);
                paint.setStyle(Paint.Style.STROKE);
                paint.setColor(-16777216);
                canvas.translate((float)(-(xpos - 2)), 2.0f);
                canvas.translate((float)xpos, 0.0f);
                curr.Draw(canvas, paint, this.ytop);
                canvas.translate((float)(-xpos), 0.0f);
                redrawLines = true;
            }
            if (start <= currentPulseTime && currentPulseTime < end) {
                x_shade = xpos;
                canvas.translate((float)xpos, 0.0f);
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(shade);
                canvas.drawRect(0.0f, 0.0f, (float)curr.getWidth(), (float)this.getHeight(), paint);
                paint.setStyle(Paint.Style.STROKE);
                paint.setColor(-16777216);
                curr.Draw(canvas, paint, this.ytop);
                canvas.translate((float)(-xpos), 0.0f);
                redrawLines = true;
            }
            if (redrawLines) {
                int line = 1;
                int y = this.ytop - 2;
                paint.setStyle(Paint.Style.STROKE);
                paint.setColor(-16777216);
                paint.setStrokeWidth(1.0f);
                canvas.translate((float)(xpos - 2), 0.0f);
                for (line = 1; line <= 5; ++line) {
                    canvas.drawLine(0.0f, (float)y, (float)(curr.getWidth() + 4), (float)y, paint);
                    y += 9;
                }
                canvas.translate((float)(-(xpos - 2)), 0.0f);
                if (prevChord != null) {
                    canvas.translate((float)prev_xpos, 0.0f);
                    prevChord.Draw(canvas, paint, this.ytop);
                    canvas.translate((float)(-prev_xpos), 0.0f);
                }
                if (this.showMeasures) {
                    this.DrawMeasureNumbers(canvas, paint);
                }
                if (this.lyrics != null) {
                    this.DrawLyrics(canvas, paint);
                }
            }
            if (curr instanceof ChordSymbol && (chord = (ChordSymbol)curr).getStem() != null && !chord.getStem().getReceiver()) {
                prevChord = (ChordSymbol)curr;
                prev_xpos = xpos;
            }
            xpos += curr.getWidth();
        }
        return x_shade;
    }

    public int PulseTimeForPoint(Point point) {
        int xpos = this.keysigWidth;
        int pulseTime = this.starttime;
        for (MusicSymbol sym : this.symbols) {
            pulseTime = sym.getStartTime();
            if (point.x <= xpos + sym.getWidth()) {
                return pulseTime;
            }
            xpos += sym.getWidth();
        }
        return pulseTime;
    }

    public String toString() {
        String result = "Staff clef=" + this.clefsym.toString() + "\n";
        result = result + "  Keys:\n";
        for (AccidSymbol a : this.keys) {
            result = result + "    " + a.toString() + "\n";
        }
        result = result + "  Symbols:\n";
        for (AccidSymbol s : this.keys) {
            result = result + "    " + ((Object)s).toString() + "\n";
        }
        for (MusicSymbol m : this.symbols) {
            result = result + "    " + m.toString() + "\n";
        }
        result = result + "End Staff\n";
        return result;
    }
}

