/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.symbol;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.jinmingyunle.midiplaylib.R;
import com.jinmingyunle.midiplaylib.symbol.Clef;
import com.jinmingyunle.midiplaylib.symbol.MusicSymbol;

public class ClefSymbol
implements MusicSymbol {
    public static Bitmap treble;
    private static Bitmap bass;
    private int starttime;
    private boolean smallsize;
    private Clef clef;
    private int width;

    public ClefSymbol(Clef clef, int starttime, boolean small) {
        this.clef = clef;
        this.starttime = starttime;
        this.smallsize = small;
        this.width = this.getMinWidth();
    }

    public static void LoadImages(Context context) {
        if (treble == null || bass == null) {
            Resources res = context.getResources();
            treble = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.treble);
            bass = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.bass);
        }
    }

    @Override
    public int getStartTime() {
        return this.starttime;
    }

    @Override
    public int getMinWidth() {
        if (this.smallsize) {
            return 20;
        }
        return 30;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int value) {
        this.width = value;
    }

    @Override
    public int getAboveStaff() {
        if (this.clef == Clef.Treble && !this.smallsize) {
            return 18;
        }
        return 0;
    }

    @Override
    public int getBelowStaff() {
        if (this.clef == Clef.Treble && !this.smallsize) {
            return 18;
        }
        if (this.clef == Clef.Treble && this.smallsize) {
            return 9;
        }
        return 0;
    }

    @Override
    public void Draw(Canvas canvas, Paint paint, int ytop) {
        int height;
        Bitmap image;
        canvas.translate((float)(this.getWidth() - this.getMinWidth()), 0.0f);
        int y = ytop;
        if (this.clef == Clef.Treble) {
            image = treble;
            if (this.smallsize) {
                height = 47;
            } else {
                height = 61;
                y = ytop - 9;
            }
        } else {
            image = bass;
            height = this.smallsize ? 25 : 29;
        }
        int imgwidth = image.getWidth() * height / image.getHeight();
        Rect src = new Rect(0, 0, image.getWidth(), image.getHeight());
        Rect dest = new Rect(0, y, 0 + imgwidth, y + height);
        canvas.drawBitmap(image, src, dest, paint);
        canvas.translate((float)(-(this.getWidth() - this.getMinWidth())), 0.0f);
    }

    public String toString() {
        return String.format("ClefSymbol clef=%1$s small=%2$s width=%3$s", new Object[]{this.clef, this.smallsize, this.width});
    }
}

