/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.handler;

import com.ksyun.ks3.exception.Ks3Error;
import com.ksyun.ks3.model.Ks3ObjectSummary;
import com.ksyun.ks3.model.ObjectListing;
import com.ksyun.ks3.model.Owner;
import com.ksyun.ks3.services.handler.Ks3HttpResponceHandler;
import com.ksyun.ks3.util.DateUtil;
import com.ksyun.ks3.util.StringUtils;
import cz.msebera.android.httpclient.Header;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class ListObjectsResponseHandler
extends Ks3HttpResponceHandler {
    private boolean isCommonPrefixes = false;

    public abstract void onFailure(int var1, Ks3Error var2, Header[] var3, String var4, Throwable var5);

    public abstract void onSuccess(int var1, Header[] var2, ObjectListing var3);

    @Override
    public final void onSuccess(int statesCode, Header[] responceHeaders, byte[] response) {
        this.onSuccess(statesCode, responceHeaders, this.parseXml(responceHeaders, response));
    }

    @Override
    public final void onFailure(int statesCode, Header[] responceHeaders, byte[] response, Throwable throwable) {
        Ks3Error error = new Ks3Error(statesCode, response, throwable);
        this.onFailure(statesCode, error, responceHeaders, response == null ? "" : new String(response), throwable);
    }

    @Override
    public final void onProgress(long bytesWritten, long totalSize) {
    }

    @Override
    public final void onStart() {
    }

    @Override
    public final void onFinish() {
    }

    @Override
    public final void onCancel() {
    }

    private ObjectListing parseXml(Header[] responceHeaders, byte[] response) {
        ObjectListing objectListing = null;
        ArrayList<Ks3ObjectSummary> objectSummarys = null;
        Ks3ObjectSummary objectSummary = null;
        Owner owner = null;
        ArrayList<String> commonPrefixes = null;
        XmlPullParserFactory factory = null;
        try {
            factory = XmlPullParserFactory.newInstance();
            XmlPullParser parse = factory.newPullParser();
            parse.setInput((InputStream)new ByteArrayInputStream(response), "UTF-8");
            int eventType = parse.getEventType();
            while (1 != eventType) {
                String nodeName = parse.getName();
                switch (eventType) {
                    case 0: {
                        objectListing = new ObjectListing();
                        objectSummarys = new ArrayList<Ks3ObjectSummary>();
                        commonPrefixes = new ArrayList<String>();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        String dateStr;
                        if ("ListBucketResult".equalsIgnoreCase(nodeName)) {
                            // empty if block
                        }
                        if ("Name".equalsIgnoreCase(nodeName)) {
                            objectListing.setBucketName(parse.nextText());
                        }
                        if ("Prefix".equalsIgnoreCase(nodeName)) {
                            if (this.isCommonPrefixes) {
                                commonPrefixes.add(parse.nextText());
                            } else {
                                objectListing.setPrefix(parse.nextText());
                            }
                        }
                        if ("Marker".equalsIgnoreCase(nodeName)) {
                            objectListing.setMarker(parse.nextText());
                        }
                        if ("MaxKeys".equalsIgnoreCase(nodeName)) {
                            objectListing.setMaxKeys(Integer.valueOf(parse.nextText()));
                        }
                        if ("NextMarker".equalsIgnoreCase(nodeName)) {
                            objectListing.setNextMarker(parse.nextText());
                        }
                        if ("Delimiter".equalsIgnoreCase(nodeName)) {
                            objectListing.setDelimiter(parse.nextText());
                        }
                        if ("IsTruncated".equalsIgnoreCase(nodeName)) {
                            objectListing.setTruncated(Boolean.valueOf(parse.nextText()));
                        }
                        if ("Contents".equalsIgnoreCase(nodeName)) {
                            objectSummary = new Ks3ObjectSummary();
                        }
                        if ("Key".equalsIgnoreCase(nodeName)) {
                            String keyString = parse.nextText();
                            objectSummary.setKey(keyString);
                        }
                        if ("ETag".equalsIgnoreCase(nodeName)) {
                            String etag = parse.nextText();
                            objectSummary.setETag(etag);
                        }
                        if ("Size".equalsIgnoreCase(nodeName)) {
                            objectSummary.setSize(Long.valueOf(parse.nextText()));
                        }
                        if ("Owner".equalsIgnoreCase(nodeName)) {
                            owner = new Owner();
                        }
                        if ("ID".equalsIgnoreCase(nodeName)) {
                            owner.setId(parse.nextText());
                        }
                        if ("DisplayName".equalsIgnoreCase(nodeName)) {
                            owner.setDisplayName(parse.nextText());
                        }
                        if ("StorageClass".equalsIgnoreCase(nodeName)) {
                            objectSummary.setStorageClass(parse.nextText());
                        }
                        if ("LastModified".equalsIgnoreCase(nodeName) && !StringUtils.isBlank(dateStr = parse.nextText())) {
                            objectSummary.setLastModified(DateUtil.ConverToDate(dateStr));
                        }
                        if (!"CommonPrefixes".equalsIgnoreCase(nodeName)) break;
                        this.isCommonPrefixes = true;
                        break;
                    }
                    case 3: {
                        if ("Contents".equalsIgnoreCase(nodeName)) {
                            objectSummarys.add(objectSummary);
                        }
                        if ("Owner".equalsIgnoreCase(nodeName)) {
                            objectSummary.setOwner(owner);
                        }
                        if ("CommonPrefixes".equalsIgnoreCase(nodeName)) {
                            objectListing.setCommonPrefixes(commonPrefixes);
                        }
                        if (!"ListBucketResult".equalsIgnoreCase(nodeName)) break;
                        objectListing.setObjectSummaries(objectSummarys);
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                eventType = parse.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectListing;
    }
}

