/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.module;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import com.alibaba.fastjson.JSONObject;
import com.dcloud.android.widget.toast.ToastCompat;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.utils.WXLogUtils;
import java.util.HashMap;

public class WXModalUIModule
extends WXSDKEngine.DestroyableModule {
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final String RESULT = "result";
    public static final String DATA = "data";
    public static final String MESSAGE = "message";
    public static final String DURATION = "duration";
    public static final String GRAVITY = "gravity";
    public static final String OK_TITLE = "okTitle";
    public static final String CANCEL_TITLE = "cancelTitle";
    public static final String DEFAULT = "default";
    private Toast toast;
    private Dialog activeDialog;

    @JSMethod(uiThread=true)
    public void toast(JSONObject jsObj) {
        if (this.mWXSDKInstance.getContext() == null) {
            return;
        }
        String message = "";
        int duration = 0;
        int gravity = 17;
        if (jsObj != null) {
            try {
                String str;
                message = jsObj.getString(MESSAGE);
                if (jsObj.containsKey((Object)DURATION)) {
                    duration = jsObj.getInteger(DURATION);
                }
                if (jsObj.containsKey((Object)GRAVITY) && (str = jsObj.getString(GRAVITY)) instanceof String && str.equals("bottom")) {
                    gravity = 80;
                }
            }
            catch (Exception e) {
                WXLogUtils.e("[WXModalUIModule] alert param parse error ", e);
            }
        }
        if (TextUtils.isEmpty((CharSequence)message)) {
            WXLogUtils.e("[WXModalUIModule] toast param parse is null ");
            return;
        }
        duration = duration > 3 ? 1 : 0;
        if (this.toast == null) {
            this.toast = ToastCompat.makeText((Context)this.mWXSDKInstance.getContext(), (CharSequence)message, (int)duration);
        } else {
            this.toast.setDuration(duration);
            this.toast.setText((CharSequence)message);
        }
        if (17 == gravity) {
            this.toast.setGravity(gravity, 0, 0);
        }
        this.toast.show();
    }

    @JSMethod(uiThread=true)
    public void alert(JSONObject jsObj, final JSCallback callback) {
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            String message = "";
            String okTitle = OK;
            if (jsObj != null) {
                try {
                    message = jsObj.getString(MESSAGE);
                    okTitle = jsObj.getString(OK_TITLE);
                }
                catch (Exception e) {
                    WXLogUtils.e("[WXModalUIModule] alert param parse error ", e);
                }
            }
            if (TextUtils.isEmpty((CharSequence)message)) {
                message = "";
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mWXSDKInstance.getContext());
            builder.setMessage((CharSequence)message);
            final String okTitle_f = TextUtils.isEmpty((CharSequence)okTitle) ? OK : okTitle;
            builder.setPositiveButton((CharSequence)okTitle_f, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        callback.invoke(okTitle_f);
                    }
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.show();
            this.tracking((Dialog)alertDialog);
        } else {
            WXLogUtils.e("[WXModalUIModule] when call alert mWXSDKInstance.getContext() must instanceof Activity");
        }
    }

    @JSMethod(uiThread=true)
    public void confirm(JSONObject jsObj, final JSCallback callback) {
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            String message = "";
            String okTitle = OK;
            String cancelTitle = CANCEL;
            if (jsObj != null) {
                try {
                    message = jsObj.getString(MESSAGE);
                    okTitle = jsObj.getString(OK_TITLE);
                    cancelTitle = jsObj.getString(CANCEL_TITLE);
                }
                catch (Exception e) {
                    WXLogUtils.e("[WXModalUIModule] confirm param parse error ", e);
                }
            }
            if (TextUtils.isEmpty((CharSequence)message)) {
                message = "";
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mWXSDKInstance.getContext());
            builder.setMessage((CharSequence)message);
            final String okTitleFinal = TextUtils.isEmpty((CharSequence)okTitle) ? OK : okTitle;
            final String cancelTitleFinal = TextUtils.isEmpty((CharSequence)cancelTitle) ? CANCEL : cancelTitle;
            builder.setPositiveButton((CharSequence)okTitleFinal, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        callback.invoke(okTitleFinal);
                    }
                }
            });
            builder.setNegativeButton((CharSequence)cancelTitleFinal, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        callback.invoke(cancelTitleFinal);
                    }
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.show();
            this.tracking((Dialog)alertDialog);
        } else {
            WXLogUtils.e("[WXModalUIModule] when call confirm mWXSDKInstance.getContext() must instanceof Activity");
        }
    }

    @JSMethod(uiThread=true)
    public void prompt(JSONObject jsObj, final JSCallback callback) {
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            String message = "";
            String defaultValue = "";
            String okTitle = OK;
            String cancelTitle = CANCEL;
            if (jsObj != null) {
                try {
                    message = jsObj.getString(MESSAGE);
                    okTitle = jsObj.getString(OK_TITLE);
                    cancelTitle = jsObj.getString(CANCEL_TITLE);
                    defaultValue = jsObj.getString(DEFAULT);
                }
                catch (Exception e) {
                    WXLogUtils.e("[WXModalUIModule] confirm param parse error ", e);
                }
            }
            if (TextUtils.isEmpty((CharSequence)message)) {
                message = "";
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mWXSDKInstance.getContext());
            builder.setMessage((CharSequence)message);
            final EditText editText = new EditText(this.mWXSDKInstance.getContext());
            editText.setText((CharSequence)defaultValue);
            builder.setView((View)editText);
            final String okTitleFinal = TextUtils.isEmpty((CharSequence)okTitle) ? OK : okTitle;
            final String cancelTitleFinal = TextUtils.isEmpty((CharSequence)cancelTitle) ? CANCEL : cancelTitle;
            builder.setPositiveButton((CharSequence)okTitleFinal, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        HashMap<String, String> result = new HashMap<String, String>();
                        result.put(WXModalUIModule.RESULT, okTitleFinal);
                        result.put(WXModalUIModule.DATA, editText.getText().toString());
                        callback.invoke(result);
                    }
                }
            }).setNegativeButton((CharSequence)cancelTitleFinal, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        HashMap<String, String> result = new HashMap<String, String>();
                        result.put(WXModalUIModule.RESULT, cancelTitleFinal);
                        result.put(WXModalUIModule.DATA, editText.getText().toString());
                        callback.invoke(result);
                    }
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.show();
            this.tracking((Dialog)alertDialog);
        } else {
            WXLogUtils.e("when call prompt mWXSDKInstance.getContext() must instanceof Activity");
        }
    }

    private void tracking(Dialog dialog) {
        this.activeDialog = dialog;
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                WXModalUIModule.this.activeDialog = null;
            }
        });
    }

    @Override
    public void destroy() {
        if (this.activeDialog != null && this.activeDialog.isShowing()) {
            this.activeDialog.dismiss();
        }
    }
}

