/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioFormat;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecord;
import android.media.projection.MediaProjection;
import android.os.Process;
import androidx.annotation.RequiresApi;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.center.stream.RCScreenShareAudioConfigImpl;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.utils.PCMFileWriter;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.RLog;
import java.nio.ByteBuffer;

@RequiresApi(api=29)
public class ScreenShareAudioRecord {
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int DEFAULT_AUDIO_FORMAT = 2;
    private static final String TAG = "InternalAudioRecord";
    private final RCScreenShareAudioConfigImpl audioConfig;
    private final Context context;
    private final MediaProjection mediaProjection;
    private final RCRTCConfigImpl rtcConfig;
    private AudioRecord audioRecord;
    private ByteBuffer byteBuffer;
    private InternalAudioRecordThread audioRecordThread;
    private OnAudioBufferAvailableListener listener;

    public ScreenShareAudioRecord(Context context, RCScreenShareAudioConfigImpl config, RCRTCConfigImpl rcrtcConfig, MediaProjection mediaProjection, OnAudioBufferAvailableListener listener) {
        assert (context != null && config != null && mediaProjection != null);
        RLog.d((String)TAG, (String)("config = " + config.toString()));
        this.audioConfig = config;
        this.context = context;
        this.mediaProjection = mediaProjection;
        this.listener = listener;
        this.rtcConfig = rcrtcConfig;
        this.init();
    }

    public void startRecord() {
        try {
            this.audioRecord.startRecording();
            this.audioRecordThread = new InternalAudioRecordThread(this.audioRecord, this.byteBuffer, this.listener, this.rtcConfig);
            this.audioRecordThread.start();
        }
        catch (IllegalStateException e) {
            ReportUtil.libError(ReportUtil.TAG.START_AUDIO_CAPTURE, "desc|reason", "start record error", e.getMessage());
            e.printStackTrace();
            this.audioRecord.stop();
        }
    }

    public void stopRecord() {
        this.listener = null;
        if (this.audioRecordThread != null) {
            this.audioRecordThread.stopThread();
        }
        this.audioRecordThread = null;
    }

    private void init() {
        RLog.d((String)TAG, (String)"init");
        AudioPlaybackCaptureConfiguration audioPlaybackCaptureConfiguration = this.initAudioPlaybackCaptureConfiguration();
        AudioFormat audioFormat = this.initAudioFormat();
        this.initAudioRecord(audioPlaybackCaptureConfiguration, audioFormat);
    }

    private void initAudioRecord(AudioPlaybackCaptureConfiguration audioPlaybackCaptureConfiguration, AudioFormat audioFormat) {
        RLog.d((String)TAG, (String)"initAudioRecord");
        this.audioRecord = new AudioRecord.Builder().setAudioFormat(audioFormat).setAudioPlaybackCaptureConfig(audioPlaybackCaptureConfiguration).build();
        int bytesPerFrame = (this.rtcConfig.isStereo() ? 2 : 1) * ScreenShareAudioRecord.getBytesPerSample(audioFormat.getEncoding());
        int framesPerBuffer = this.audioRecord.getSampleRate() / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
    }

    @SuppressLint(value={"WrongConstant"})
    private AudioFormat initAudioFormat() {
        RLog.d((String)TAG, (String)"initAudioFormat");
        return new AudioFormat.Builder().setEncoding(2).setSampleRate(this.rtcConfig.getAudioSampleRate()).setChannelMask(this.rtcConfig.isStereo() ? 12 : 16).build();
    }

    @SuppressLint(value={"WrongConstant"})
    private AudioPlaybackCaptureConfiguration initAudioPlaybackCaptureConfiguration() {
        AudioPlaybackCaptureConfiguration.Builder builder = new AudioPlaybackCaptureConfiguration.Builder(this.mediaProjection);
        if (!this.audioConfig.getAudioUsageSet().isEmpty()) {
            for (RCRTCParamsType.RCRTCScreenShareAudioUsage audioUsage : this.audioConfig.getAudioUsageSet()) {
                builder.addMatchingUsage(audioUsage.getValue());
            }
        }
        if (!this.audioConfig.getAudioUidSet().isEmpty()) {
            for (Integer uid : this.audioConfig.getAudioUidSet()) {
                builder.addMatchingUid(uid.intValue());
            }
        }
        return builder.build();
    }

    private static int getBytesPerSample(int audioFormat) {
        switch (audioFormat) {
            case 3: {
                return 1;
            }
            case 1: 
            case 2: 
            case 13: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Bad audio format " + audioFormat);
    }

    private static class InternalAudioRecordThread
    extends Thread {
        private static final String TAG = "InternalAudioRecordThread";
        private final AudioRecord audioRecord;
        private final ByteBuffer byteBuffer;
        private OnAudioBufferAvailableListener listener;
        private final RCRTCConfigImpl rtcConfig;
        private volatile boolean keepAlive = true;
        private static final boolean isDump = false;
        private PCMFileWriter fileWriter;

        public InternalAudioRecordThread(AudioRecord audioRecord, ByteBuffer byteBuffer, OnAudioBufferAvailableListener listener, RCRTCConfigImpl rtcConfig) {
            super(ScreenShareAudioRecord.TAG);
            this.audioRecord = audioRecord;
            this.byteBuffer = byteBuffer;
            this.listener = listener;
            this.rtcConfig = rtcConfig;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            while (this.keepAlive) {
                OnAudioBufferAvailableListener listener;
                int read = this.audioRecord.read(this.byteBuffer, this.byteBuffer.capacity());
                if (read != this.byteBuffer.capacity() || (listener = this.listener) == null) continue;
                listener.onAudioBuffer(this.byteBuffer, read, this.rtcConfig.getAudioSampleRate(), this.rtcConfig.isStereo() ? 2 : 1, 2);
            }
            try {
                this.audioRecord.stop();
                this.audioRecord.release();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }

        public void stopThread() {
            this.listener = null;
            this.keepAlive = false;
        }
    }
}

