/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import android.content.Context;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import cn.rongcloud.rtc.api.IAudioEffectManager;
import cn.rongcloud.rtc.core.audio.AudioResample;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.custom.MediaAudioDecoder;
import cn.rongcloud.rtc.custom.OnPcmAvailableListener;
import cn.rongcloud.rtc.utils.AudioUtil;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;

public class AudioEffectManager
implements IAudioEffectManager,
OnAudioBufferAvailableListener {
    private Context context;
    private int sampleRate;
    private int channelCount;
    private int audioFormat;
    private Handler handler;
    private final List<IAudioEffectManager.IStateObserver> stateObservers = new ArrayList<IAudioEffectManager.IStateObserver>();
    private final Map<Integer, AudioEffect> allEffects = new ConcurrentHashMap<Integer, AudioEffect>();
    private final List<AudioEffect> playingEffects = new ArrayList<AudioEffect>();
    private final List<AudioEffect> pendingPlayingEffects = new ArrayList<AudioEffect>();
    private byte[] buffer;
    private float effectsVolume = 1.0f;

    public AudioEffectManager(Context context, int sampleRate, int channelCount, int audioFormat) {
        this.context = context;
        this.sampleRate = sampleRate;
        this.channelCount = channelCount;
        this.audioFormat = audioFormat;
        HandlerThread handlerThread = new HandlerThread("AudioEffectLoader");
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper());
    }

    public void release() {
        this.handler.getLooper().quit();
        this.unloadAllEffects();
    }

    @Override
    public void onAudioBuffer(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
        if (this.playingEffects.size() == 0 && this.pendingPlayingEffects.size() == 0) {
            return;
        }
        while (this.pendingPlayingEffects.size() > 0) {
            AudioEffect pendingEffect = this.pendingPlayingEffects.remove(this.pendingPlayingEffects.size() - 1);
            if (this.playingEffects.contains(pendingEffect)) continue;
            this.playingEffects.add(pendingEffect);
        }
        if (this.buffer == null || this.buffer.length != byteBuffer.capacity()) {
            this.buffer = new byte[byteBuffer.capacity()];
        }
        ByteBuffer mix = null;
        Iterator<AudioEffect> iterator = this.playingEffects.iterator();
        while (iterator.hasNext()) {
            AudioEffect audioEffect = iterator.next();
            if (audioEffect.getPlayingState() == 2) continue;
            audioEffect.playAndGetData(this.buffer);
            if (audioEffect.getPlayingState() == 1 || audioEffect.getLoadingState() == 1) {
                iterator.remove();
                this.handleEffectFinished(audioEffect.getEffectId());
            }
            if (mix == null) {
                mix = ByteBuffer.allocate(this.buffer.length);
                mix.put(this.buffer);
                continue;
            }
            AudioUtil.mixAsShort(this.buffer, mix);
        }
        if (mix != null) {
            AudioUtil.mixAsShort(mix.array(), byteBuffer);
        }
    }

    private void handleEffectFinished(final int effectId) {
        ReportUtil.libTask(ReportUtil.TAG.EFFECTFINISHED, "effectId", effectId);
        this.handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = AudioEffectManager.this.stateObservers;
                synchronized (list) {
                    for (IAudioEffectManager.IStateObserver observer : AudioEffectManager.this.stateObservers) {
                        observer.onEffectFinished(effectId);
                    }
                }
                ReportUtil.libRes(ReportUtil.TAG.EFFECTFINISHED, "effectId|code", effectId, 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerStateObserver(IAudioEffectManager.IStateObserver observer) {
        List<IAudioEffectManager.IStateObserver> list = this.stateObservers;
        synchronized (list) {
            if (!this.stateObservers.contains(observer)) {
                this.stateObservers.add(observer);
                return 0;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unregisterStateObserver(IAudioEffectManager.IStateObserver observer) {
        List<IAudioEffectManager.IStateObserver> list = this.stateObservers;
        synchronized (list) {
            if (this.stateObservers.remove(observer)) {
                return 0;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int preloadEffect(final String path, final int effectId, final IAudioEffectManager.ILoadingStateCallback callback) {
        AudioEffect effect;
        ReportUtil.appTask(ReportUtil.TAG.PRELOADEFFECT, "path|effectId", path, effectId);
        Map<Integer, AudioEffect> map = this.allEffects;
        synchronized (map) {
            if (this.allEffects.containsKey(effectId)) {
                ReportUtil.appError(ReportUtil.TAG.PRELOADEFFECT, "effectId|code|msg", -1, effectId, "effect id " + effectId + " is already in use");
                return -1;
            }
            effect = new AudioEffect(effectId, this.sampleRate, this.channelCount, this.audioFormat);
            effect.load1();
            this.allEffects.put(effectId, effect);
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                int error = effect.load2(AudioEffectManager.this.context, path);
                callback.complete(error);
                if (error == 0) {
                    ReportUtil.appRes(ReportUtil.TAG.PRELOADEFFECT, "effectId|code", effectId, 0);
                } else {
                    ReportUtil.appError(ReportUtil.TAG.PRELOADEFFECT, "effectId|code|msg", effectId, error, "preloadEffect: " + effectId + " Failed");
                }
            }
        });
        return 0;
    }

    @Override
    public int unloadEffect(int effectId) {
        ReportUtil.appTask(ReportUtil.TAG.UNLOADEFFECT, "effectId", effectId);
        AudioEffect effect = this.allEffects.remove(effectId);
        if (effect == null) {
            ReportUtil.appError(ReportUtil.TAG.UNLOADEFFECT, "code|msg", -1, "effect:" + effectId + " not exist");
            return -1;
        }
        effect.unload();
        ReportUtil.appRes(ReportUtil.TAG.UNLOADEFFECT, "effectId|code", effectId, 0);
        return 0;
    }

    @Override
    public int unloadAllEffects() {
        ReportUtil.appTask(ReportUtil.TAG.UNLOADALLEFFECTS, "effectSize", this.allEffects.size());
        for (AudioEffect effect : this.allEffects.values()) {
            effect.unload();
        }
        ReportUtil.appRes(ReportUtil.TAG.UNLOADALLEFFECTS, "code", 0);
        return 0;
    }

    @Override
    public int playEffect(int effectId, int loopCount, int volume) {
        ReportUtil.appTask(ReportUtil.TAG.PLAYEFFECT, "effectId|loopCount|volume", effectId, loopCount, volume);
        AudioEffect effect = this.allEffects.get(effectId);
        if (effect == null) {
            ReportUtil.appError(ReportUtil.TAG.PLAYEFFECT, "code|msg", -1, "effect:" + effectId + " have not call preload");
            return -1;
        }
        int loadingState = effect.getLoadingState();
        if (loadingState == 4) {
            ReportUtil.appError(ReportUtil.TAG.PLAYEFFECT, "code|msg", -1, "current effect:" + effectId + " LoadingState is " + loadingState);
            return -1;
        }
        loadingState = effect.getLoadingState();
        if (loadingState == 2) {
            ReportUtil.appError(ReportUtil.TAG.PLAYEFFECT, "code|msg", -1, "current effect:" + effectId + " LoadingState is " + loadingState);
            return -1;
        }
        int playingState = effect.getPlayingState();
        if (playingState != 1) {
            ReportUtil.appError(ReportUtil.TAG.PLAYEFFECT, "code|msg", -1, "current effect:" + effectId + " PlayingState is " + playingState);
            return -1;
        }
        effect.setLoopCount(loopCount);
        effect.play();
        effect.updateVolume(this.toFloatVolume(volume));
        this.pendingPlayingEffects.add(effect);
        ReportUtil.appRes(ReportUtil.TAG.PLAYEFFECT, "effectId|code", effectId, 0);
        return 0;
    }

    @Override
    public int pauseEffect(int effectId) {
        ReportUtil.appTask(ReportUtil.TAG.PAUSEEFFECT, "effectId", effectId);
        AudioEffect effect = this.allEffects.get(effectId);
        if (effect == null) {
            ReportUtil.appError(ReportUtil.TAG.PAUSEEFFECT, "code|msg", -1, "effect:" + effectId + " not exist");
            return -1;
        }
        effect.pause();
        ReportUtil.appRes(ReportUtil.TAG.PAUSEEFFECT, "effectId|code", effectId, 0);
        return 0;
    }

    @Override
    public int pauseAllEffects() {
        ReportUtil.appTask(ReportUtil.TAG.PAUSEALLEFFECTS, "effectSize", this.allEffects.size());
        for (AudioEffect effect : this.allEffects.values()) {
            effect.pause();
        }
        ReportUtil.appRes(ReportUtil.TAG.PAUSEALLEFFECTS, "code", 0);
        return 0;
    }

    @Override
    public int resumeEffect(int effectId) {
        ReportUtil.appTask(ReportUtil.TAG.RESUMEEFFECT, "effectId", effectId);
        AudioEffect effect = this.allEffects.get(effectId);
        if (effect == null) {
            ReportUtil.appError(ReportUtil.TAG.RESUMEEFFECT, "code|msg", -1, "effect:" + effectId + " not exist");
            return -1;
        }
        int resume = effect.resume();
        if (resume == 0) {
            ReportUtil.appRes(ReportUtil.TAG.RESUMEEFFECT, "effectId|code", effectId, 0);
        } else {
            ReportUtil.appError(ReportUtil.TAG.RESUMEEFFECT, "code|msg", resume, "current effect:" + effectId + " PlayingState is " + effect.playingState);
        }
        return resume;
    }

    @Override
    public int resumeAllEffects() {
        ReportUtil.appTask(ReportUtil.TAG.RESUMEALLEFFECTS, "effectSize", this.allEffects.size());
        for (AudioEffect effect : this.allEffects.values()) {
            effect.resume();
        }
        ReportUtil.appRes(ReportUtil.TAG.RESUMEALLEFFECTS, "code", 0);
        return 0;
    }

    @Override
    public int stopEffect(int effectId) {
        ReportUtil.appTask(ReportUtil.TAG.STOPEFFECT, "effectId", effectId);
        AudioEffect effect = this.allEffects.get(effectId);
        if (effect == null) {
            ReportUtil.appError(ReportUtil.TAG.STOPEFFECT, "code|msg", -1, "effect:" + effectId + " not exist");
            return -1;
        }
        effect.stop();
        ReportUtil.appRes(ReportUtil.TAG.STOPEFFECT, "effectId|code", effectId, 0);
        return 0;
    }

    @Override
    public int stopAllEffects() {
        ReportUtil.appTask(ReportUtil.TAG.STOPALLEFFECTS, "effectSize", this.allEffects.size());
        for (AudioEffect effect : this.allEffects.values()) {
            effect.stop();
        }
        ReportUtil.appRes(ReportUtil.TAG.STOPALLEFFECTS, "code", 0);
        return 0;
    }

    @Override
    public int setEffectsVolume(int volume) {
        ReportUtil.appOperate(ReportUtil.TAG.SETEFFECTSVOLUME, "volume", volume);
        this.effectsVolume = this.toFloatVolume(volume);
        for (AudioEffect effect : this.allEffects.values()) {
            effect.updateVolume(effect.getVolume());
        }
        return 0;
    }

    @Override
    public int getEffectsVolume() {
        return this.toIntVolume(this.effectsVolume);
    }

    @Override
    public int setEffectVolume(int effectId, int volume) {
        ReportUtil.appTask(ReportUtil.TAG.SETEFFECTVOLUMEBYID, "effectId|volume", effectId, volume);
        AudioEffect effect = this.allEffects.get(effectId);
        if (effect == null) {
            ReportUtil.appError(ReportUtil.TAG.SETEFFECTVOLUMEBYID, "code|msg", -1, "effect:" + effectId + " not exist");
            return -1;
        }
        effect.updateVolume(this.toFloatVolume(volume));
        ReportUtil.appRes(ReportUtil.TAG.SETEFFECTVOLUMEBYID, "effectId|code", effectId, 0);
        return 0;
    }

    @Override
    public int getEffectVolume(int effectId) {
        AudioEffect effect = this.allEffects.get(effectId);
        if (effect == null) {
            return -1;
        }
        return this.toIntVolume(effect.getVolume());
    }

    private float toFloatVolume(int volume) {
        volume = Math.max(0, Math.min(100, volume));
        return (float)volume / 100.0f;
    }

    private int toIntVolume(float volume) {
        volume = Math.max(0.0f, Math.min(1.0f, volume));
        return (int)(volume * 100.0f);
    }

    private class AudioEffect {
        static final int PLAYING_STATE_STOPPED = 1;
        static final int PLAYING_STATE_PAUSED = 2;
        static final int PLAYING_STATE_PLAYING = 3;
        static final int LOAD_STATE_UNLOAD = 1;
        static final int LOAD_STATE_LOADING = 2;
        static final int LOAD_STATE_LOADED = 3;
        static final int LOAD_STATE_FAILED = 4;
        private ByteBuffer effectBuffer;
        private int realBufferSize;
        private AudioTrack audioTrack;
        private int effectId;
        private int loopCount = 1;
        private float volume = 1.0f;
        private int playingState = 1;
        private int sampleRate;
        private int channelCount;
        private int audioFormat;
        private int loadingState = 1;

        AudioEffect(int effectId, int sampleRate, int channelCount, int audioFormat) {
            this.effectId = effectId;
            this.sampleRate = sampleRate;
            this.channelCount = channelCount;
            this.audioFormat = audioFormat;
        }

        void load1() {
            this.loadingState = 2;
        }

        int load2(Context context, String path) {
            MediaAudioDecoder decoder = new MediaAudioDecoder();
            if (!decoder.init(path, context)) {
                this.loadingState = 4;
                return -1;
            }
            int durationSecs = (int)(decoder.getDurationUs() / 1000000L);
            int inSampleRate = decoder.getSampleRate();
            int inChannelCount = decoder.getChannelCount();
            int inAudioFormat = decoder.getAudioFormat();
            final AudioResample resample = new AudioResample(inSampleRate, inChannelCount, inAudioFormat, this.sampleRate, this.channelCount, this.audioFormat);
            int bufferSize = this.calculateBufferSize(durationSecs + 1, this.sampleRate, this.channelCount, this.audioFormat);
            this.effectBuffer = ByteBuffer.allocateDirect(bufferSize);
            final Thread currentThread = Thread.currentThread();
            decoder.setPcmAvailableListener(new OnPcmAvailableListener(){

                @Override
                public void onPcm(byte[] data, long presentationTimeUs) {
                    if (AudioEffect.this.loadingState == 2) {
                        if ((data = resample.resample(data)) == null || data.length == 0) {
                            return;
                        }
                        AudioEffect.this.effectBuffer.put(data);
                    } else {
                        LockSupport.unpark(currentThread);
                    }
                }

                @Override
                public void onPcmEnd() {
                    AudioEffect.this.effectBuffer.flip();
                    AudioEffect.this.realBufferSize = AudioEffect.this.effectBuffer.limit();
                    AudioEffect.this.loadingState = 3;
                    LockSupport.unpark(currentThread);
                }

                @Override
                public void onOneLoopEnd() {
                }
            });
            decoder.start();
            LockSupport.park();
            decoder.stop();
            resample.destroy();
            return 0;
        }

        int unload() {
            this.stop();
            this.loadingState = 1;
            return 0;
        }

        int play() {
            if (this.playingState == 1) {
                this.audioTrack = AudioUtil.createAudioTrack(this.sampleRate, this.channelCount, this.audioFormat, 3);
                this.updateVolume(this.volume);
                this.playingState = 3;
                return 0;
            }
            return -1;
        }

        int stop() {
            if (this.playingState != 1) {
                if (this.audioTrack != null) {
                    this.audioTrack.pause();
                    this.audioTrack.stop();
                    this.audioTrack.flush();
                    this.audioTrack.release();
                    this.audioTrack = null;
                }
                this.resetEffectBuffer();
                this.playingState = 1;
                return 0;
            }
            return -1;
        }

        int pause() {
            if (this.playingState == 3) {
                this.playingState = 2;
                return 0;
            }
            return -1;
        }

        int resume() {
            if (this.playingState == 2) {
                this.playingState = 3;
                return 0;
            }
            return -1;
        }

        int getPlayingState() {
            return this.playingState;
        }

        float getVolume() {
            return this.volume;
        }

        int getEffectId() {
            return this.effectId;
        }

        int getLoadingState() {
            return this.loadingState;
        }

        void updateVolume(float vol) {
            float globalVol = AudioEffectManager.this.toFloatVolume(AudioEffectManager.this.getEffectsVolume());
            float targetVol = globalVol * vol;
            float minVol = AudioTrack.getMinVolume();
            float maxVol = AudioTrack.getMaxVolume();
            float realVol = minVol + (maxVol - minVol) * targetVol;
            AudioTrack track = this.audioTrack;
            if (track != null) {
                track.setStereoVolume(realVol, realVol);
            }
            this.volume = vol;
        }

        private int calculateBufferSize(int durationSecs, int sampleRate, int channelCount, int audioFormat) {
            int bytesPerSample = AudioUtil.bytesPerSample(audioFormat);
            return channelCount * sampleRate * bytesPerSample * durationSecs;
        }

        int playAndGetData(byte[] data) {
            int readLength;
            if (this.playingState != 3) {
                return 0;
            }
            int remaining = this.effectBuffer.remaining();
            if (remaining < data.length) {
                this.effectBuffer.get(data, 0, remaining);
                this.resetEffectBuffer();
                --this.loopCount;
                if (this.loopCount > 0) {
                    this.effectBuffer.get(data, remaining, data.length - remaining);
                    readLength = data.length;
                } else {
                    readLength = remaining;
                    this.playingState = 1;
                }
            } else {
                this.effectBuffer.get(data);
                readLength = data.length;
            }
            this.appendToAudioTrack(data);
            return readLength;
        }

        private void appendToAudioTrack(byte[] data) {
            AudioTrack track = this.audioTrack;
            if (track == null) {
                return;
            }
            try {
                if (Build.VERSION.SDK_INT >= 21) {
                    track.write(ByteBuffer.wrap(data), data.length, 1);
                } else {
                    track.write(data, 0, data.length);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        void setLoopCount(int count) {
            this.loopCount = count;
        }

        private void resetEffectBuffer() {
            this.effectBuffer.position(0);
            this.effectBuffer.limit(this.realBufferSize);
        }
    }
}

