/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.os.Handler;
import android.os.Message;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.engine.AbstractBaseState;
import cn.rongcloud.rtc.stateMachine.IUnhandledMessageListener;
import cn.rongcloud.rtc.stateMachine.StateMachine;
import cn.rongcloud.rtc.utils.ReportUtil;

public abstract class AbstractRTCEngineImpl
extends RCRTCEngine
implements IUnhandledMessageListener {
    private static final String TAG = "AbstractRTCEngineImpl";
    private StateMachine mStateMachine = new StateMachine("RCRTCEngine");

    protected AbstractRTCEngineImpl() {
        this.mStateMachine.setUnhandledMessageListener(this);
    }

    protected void transitionTo(AbstractBaseState destState) {
        ReportUtil.libStatus(ReportUtil.TAG.TRANSITIONTOSTATE, "currentState|destState", this.getCurrentState().getName(), destState.getName());
        this.mStateMachine.transitionTo(destState);
    }

    protected AbstractBaseState getCurrentState() {
        return (AbstractBaseState)this.mStateMachine.getCurrentState();
    }

    protected final void setInitialState(AbstractBaseState initialState) {
        this.mStateMachine.setInitialState(initialState);
    }

    protected final void addState(AbstractBaseState state) {
        this.mStateMachine.addState(state);
    }

    protected final void addState(AbstractBaseState state, AbstractBaseState parent) {
        this.mStateMachine.addState(state, parent);
    }

    public final void sendMessage(Message msg) {
        ReportUtil.libStatus(ReportUtil.TAG.SENDEVENTMESSAGE, "event|currentState", msg.what, this.getCurrentState().getName());
        this.mStateMachine.sendMessage(msg);
    }

    public final void sendMessage(int what, Object obj) {
        ReportUtil.libStatus(ReportUtil.TAG.SENDEVENTMESSAGE, "event|currentState", what, this.getCurrentState().getName());
        this.mStateMachine.sendMessage(what, obj);
    }

    public final void sendMessage(int what, Object ... obj) {
        ReportUtil.libStatus(ReportUtil.TAG.SENDEVENTMESSAGE, "event|currentState", what, this.getCurrentState().getName());
        this.mStateMachine.sendMessage(what, obj);
    }

    public final void sendMessageForMap(int what, String keys, Object ... values) {
        ReportUtil.libStatus(ReportUtil.TAG.SENDEVENTMESSAGE, "event|currentState", what, this.getCurrentState().getName());
        this.mStateMachine.sendMessage(what, keys, values);
    }

    protected final void deferMessage(Message msg) {
        this.mStateMachine.deferMessage(msg);
    }

    protected final Message obtainMessage() {
        return this.mStateMachine.obtainMessage();
    }

    public final Handler getHandler() {
        return this.mStateMachine.getHandler();
    }

    protected final void start() {
        this.mStateMachine.start();
    }

    @Override
    public void unhandledMessage(Message msg) {
        ReportUtil.report("L-", ReportUtil.TAG.UNHANDLEDMESSAGE, "-E", 2, "code|event|currentState", RTCErrorCode.ILLEGALSTATE.getValue(), msg.what, this.getCurrentState().getName());
    }

    public void clearDeferredMessage() {
        this.mStateMachine.clearDeferredMessage();
    }
}

