/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.action;

import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.action.PubSubActionResultCallback;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class PubSubAction<T> {
    public static final int TYPE_PUBLISH = 1;
    public static final int TYPE_UNPUBLISHED = 2;
    public static final int TYPE_SUBSCRIBE = 3;
    public static final int TYPE_RESUBSCRIBE = 4;
    public static final int TYPE_UNSUBSCRIBE = 5;
    public static final int TYPE_SWITCH_STREAM_TYPE = 6;
    public static final int TYPE_EXCHANGE_VIDEO_SIZE = 7;
    public static final int TYPE_JOIN_OTHER_ROOM_SUCCESS_EXCHANGE_SDP = 8;
    public static final int TYPE_EVENT_UNSUBSCRIBE_STREAMS_EXCHANGE_REMOTE_SDP = 9;
    public static final int TYPE_EVENT_RE_EXCHANGE_REMOTE_SDP = 10;
    public static final int TYPE_EVENT_RECONNECT = 11;
    protected final int mActionType;
    protected List<RCRTCStream> mStreams = new ArrayList<RCRTCStream>();
    protected PubSubActionResultCallback mCallbacks;
    protected IRCRTCResultDataCallback<T> mInteriorCallback;
    protected ICompleteListener mCompleteListener;
    protected Object mExtra;

    public PubSubAction(int actionType, boolean switchCallbackThread, List<RCRTCStream> streams, IRCRTCFailedCallback callback) {
        this(actionType, switchCallbackThread, streams, null, callback);
    }

    public PubSubAction(int actionType, List<RCRTCStream> streams, IRCRTCFailedCallback callback) {
        this(actionType, true, streams, null, callback);
    }

    public PubSubAction(int actionType, List<RCRTCStream> streams, Object extra, IRCRTCFailedCallback callback) {
        this(actionType, true, streams, extra, callback);
    }

    public PubSubAction(int actionType, boolean switchCallbackThread, List<RCRTCStream> streams, Object extra, IRCRTCFailedCallback callback) {
        this.mActionType = actionType;
        if (!RongRTCUtils.isEmpty(streams)) {
            this.mStreams.addAll(streams);
        }
        if (callback != null) {
            this.mCallbacks = new PubSubActionResultCallback(callback, switchCallbackThread);
        }
        this.mInteriorCallback = new IRCRTCResultDataCallback<T>(){

            @Override
            public void onSuccess(T data) {
                RTCEngineImpl.getInstance().checkIsOnEngineThread();
                if (PubSubAction.this.mCallbacks != null) {
                    PubSubAction.this.mCallbacks.onSuccess(data);
                }
                PubSubAction.this.mCompleteListener.onComplete();
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                RTCEngineImpl.getInstance().checkIsOnEngineThread();
                if (PubSubAction.this.mCallbacks != null) {
                    PubSubAction.this.mCallbacks.onFailed(errorCode);
                }
                PubSubAction.this.mCompleteListener.onComplete();
            }
        };
        this.mExtra = extra;
    }

    void setCompleteListener(ICompleteListener completeListener) {
        this.mCompleteListener = completeListener;
    }

    public IRCRTCResultDataCallback<T> getCallback() {
        return this.mInteriorCallback;
    }

    protected void cancel() {
        if (this.mCallbacks != null) {
            this.mCallbacks.onFailed(RTCErrorCode.CANCEL_OPERATOR);
        }
    }

    public int getActionType() {
        return this.mActionType;
    }

    public List<RCRTCStream> getStreams() {
        return this.mStreams;
    }

    protected abstract void execute();

    public <V> V getExtra() {
        return (V)this.mExtra;
    }

    public static interface ICompleteListener {
        public void onComplete();
    }
}

