/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.weex;

import android.content.Context;
import android.view.ViewConfiguration;

public class FlingHelper {
    private static float DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
    private static float mFlingFriction = ViewConfiguration.getScrollFriction();
    private static float mPhysicalCoeff;

    public FlingHelper(Context context) {
        mPhysicalCoeff = context.getResources().getDisplayMetrics().density * 160.0f * 386.0878f * 0.84f;
    }

    private double getSplineDeceleration(int i) {
        return Math.log(0.35f * (float)Math.abs(i) / (mFlingFriction * mPhysicalCoeff));
    }

    private double getSplineDecelerationByDistance(double d) {
        return ((double)DECELERATION_RATE - 1.0) * Math.log(d / (double)(mFlingFriction * mPhysicalCoeff)) / (double)DECELERATION_RATE;
    }

    public double getSplineFlingDistance(int i) {
        return Math.exp(this.getSplineDeceleration(i) * ((double)DECELERATION_RATE / ((double)DECELERATION_RATE - 1.0))) * (double)(mFlingFriction * mPhysicalCoeff);
    }

    public int getVelocityByDistance(double d) {
        return Math.abs((int)(Math.exp(this.getSplineDecelerationByDistance(d)) * (double)mFlingFriction * (double)mPhysicalCoeff / (double)0.35f));
    }
}

