/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import cn.rongcloud.rtc.api.RCRTCAudioMixer;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.core.audio.FFmpegAudioMixer;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.plugin.VoiceBeautifierPlugin;
import cn.rongcloud.rtc.plugin.soundEffect.IPreSoundEffectOperation;
import cn.rongcloud.rtc.plugin.soundEffect.ISounEffectOperation;
import cn.rongcloud.rtc.plugin.soundEffect.SoundEffectOperation;
import cn.rongcloud.rtc.utils.AudioBufferStream;
import cn.rongcloud.rtc.utils.AudioUtil;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.RLog;
import java.nio.ByteBuffer;

public class AudioWriteHelper
implements OnAudioBufferAvailableListener,
IPreSoundEffectOperation {
    private AudioBufferStream mAudioBufferStream;
    private static final int MAX_VOL = 100;
    private static final int MIN_VOL = 0;
    private int mixingVolume = 100;
    private RCRTCAudioMixer.Mode mode;
    private volatile boolean isRelease = false;
    private SoundEffectOperation effectOperation;
    private FFmpegAudioMixer mAudioMixer;
    private boolean useEffect;

    public AudioWriteHelper(boolean useEffect) {
        VoiceBeautifierPlugin voiceBeautifierPlugin;
        RCMicOutputStreamImpl stream = (RCMicOutputStreamImpl)RTCEngineImpl.getInstance().getDefaultAudioStream();
        if (null != stream) {
            stream.registerAudioBufferListener(this);
        }
        if ((voiceBeautifierPlugin = RTCEngineImpl.getInstance().getVoiceBeautyPlugin()) != null && useEffect) {
            this.useEffect = true;
            ReportUtil.appStatus(ReportUtil.TAG.SOUND_EFFECT_INIT, "AudioWriteHelper", "");
            this.effectOperation = voiceBeautifierPlugin.createSoundEffect();
            this.effectOperation.linkPreOperation(this);
        } else {
            this.useEffect = false;
        }
    }

    public boolean isUseEffect() {
        return this.useEffect;
    }

    public void write(byte[] data, int sampleRate, int channelCount, int audioFormat, int volume, RCRTCAudioMixer.Mode mode) {
        if (this.isRelease) {
            return;
        }
        this.mixingVolume = Math.max(0, Math.min(100, volume));
        this.mode = mode;
        if (this.effectOperation != null && this.useEffect) {
            if (this.effectOperation.getChannel() != channelCount || sampleRate != this.effectOperation.getSampleRate() || this.effectOperation.getAudioFormat() != audioFormat) {
                this.effectOperation.initParams(sampleRate, channelCount, audioFormat);
            }
            this.effectOperation.operate(data);
        } else {
            AudioBufferStream audioBufferStream = null;
            if (this.mAudioBufferStream == null) {
                this.mAudioBufferStream = new AudioBufferStream(sampleRate, channelCount, audioFormat, RTCEngineImpl.getInstance().getAudioSampleRate(), RTCEngineImpl.getInstance().isStereo() ? 2 : 1, 2);
            }
            if (null != (audioBufferStream = this.mAudioBufferStream)) {
                audioBufferStream.write(data);
            }
        }
    }

    @Override
    public void operated(ByteBuffer buffer, int dataLength) {
        AudioBufferStream audioBufferStream = null;
        if (this.mAudioBufferStream == null) {
            this.mAudioBufferStream = new AudioBufferStream(this.effectOperation.getSampleRate(), this.effectOperation.getChannel(), this.effectOperation.getAudioFormat(), RTCEngineImpl.getInstance().getAudioSampleRate(), RTCEngineImpl.getInstance().isStereo() ? 2 : 1, 2);
        }
        if (null != (audioBufferStream = this.mAudioBufferStream)) {
            byte[] data = new byte[dataLength];
            buffer.get(data, 0, dataLength);
            audioBufferStream.write(data);
        }
    }

    public void setRate(float speed) {
        if (this.effectOperation != null) {
            float calRate = speed / 100.0f;
            this.effectOperation.setRate(calRate);
        }
    }

    public void setTempo(float tempo) {
        if (this.effectOperation != null) {
            float calSpeed = tempo / 100.0f;
            this.effectOperation.setTempo(calSpeed);
        }
    }

    public void setPitch(int pitch) {
        if (this.effectOperation != null) {
            this.effectOperation.setPitchSemiTones(pitch);
        }
    }

    @Override
    public void addNext(ISounEffectOperation next) {
    }

    @Override
    public void onAudioBuffer(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
        AudioBufferStream audioBufferStream = this.mAudioBufferStream;
        if (audioBufferStream == null) {
            return;
        }
        byte[] data = audioBufferStream.read(sizeInBytes / (channelCount * 2));
        if (data == null) {
            return;
        }
        AudioUtil.adjustVolumeAsShort(data, AudioUtil.linearToLog(this.mixingVolume));
        switch (this.mode) {
            case MIX: {
                int bgmChannelCnt;
                int n = bgmChannelCnt = RTCEngineImpl.getInstance().isStereo() ? 2 : 1;
                if (channelCount == bgmChannelCnt && sampleRate == RTCEngineImpl.getInstance().getAudioSampleRate()) {
                    if (this.mAudioMixer == null) {
                        this.mAudioMixer = new FFmpegAudioMixer();
                        int ret = this.mAudioMixer.init(sizeInBytes, sampleRate, channelCount, audioFormat);
                        if (ret != 0) {
                            RLog.d((String)"AudioWriteHelper", (String)"- onAudioBuffer: FFmpegAudioMixer init failed !");
                            this.mAudioMixer.unInit();
                            this.mAudioMixer = null;
                            ReportUtil.libError(ReportUtil.TAG.FFMPEGAUDIOMIXINIT, "method|status", "- AudioWriteHelper onAudioBuffer()", "FmpegAudioMixer init failed !");
                            return;
                        }
                        ReportUtil.libStatus(ReportUtil.TAG.FFMPEGAUDIOMIXINIT, "method|status", "- AudioWriteHelper onAudioBuffer()", "FFmpegAudioMixer init success !");
                    }
                    try {
                        byte[] target = this.mAudioMixer.mix(data, byteBuffer);
                        if (target != null && target.length > 0) {
                            byteBuffer.clear();
                            byteBuffer.put(target);
                            break;
                        }
                        AudioUtil.mixAsShort(data, byteBuffer);
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                AudioUtil.mixAsShort(data, byteBuffer);
                break;
            }
            case REPLACE: {
                byteBuffer.clear();
                byteBuffer.put(data);
                break;
            }
        }
    }

    public void release() {
        RCMicOutputStreamImpl stream;
        this.isRelease = true;
        AudioBufferStream audioBufferStream = this.mAudioBufferStream;
        this.mAudioBufferStream = null;
        if (null != audioBufferStream) {
            audioBufferStream.release();
        }
        if (this.effectOperation != null) {
            ReportUtil.appStatus(ReportUtil.TAG.SOUND_EFFECT_RELEASE, "AudioWriteHelper", "");
            this.effectOperation.release();
            this.effectOperation = null;
        }
        if (this.mAudioMixer != null) {
            this.mAudioMixer.unInit();
            this.mAudioMixer = null;
            ReportUtil.libStatus(ReportUtil.TAG.FFMPEGAUDIOMIXUNINIT, "method|status", "- AudioWriteHelper stop()", "FFmpegAudioMixer unInit()");
        }
        if (null != (stream = (RCMicOutputStreamImpl)RTCEngineImpl.getInstance().getDefaultAudioStream())) {
            stream.unregisterAudioBufferListener(this);
        }
    }
}

