/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Paint;
import android.text.Editable;
import android.text.InputFilter;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.CSSConstants;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.action.GraphicSize;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXEditText;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.core.ui.DCKeyboardManager;
import io.dcloud.common.core.ui.keyboard.DCEditText;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.utils.UniUtils;
import io.dcloud.feature.uniapp.utils.UniViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DCWXInput
extends WXComponent<WXEditText> {
    private final InputMethodManager mInputMethodManager;
    private String mBeforeText = "";
    protected String mType = "text";
    private boolean isPassword = false;
    private int mEditorAction = 6;
    private String mReturnKeyType = null;
    private List<TextView.OnEditorActionListener> mEditorActionListeners;
    private boolean mListeningConfirm = false;
    private boolean mIgnoreNextOnInputEvent = false;
    private TextFormatter mFormatter = null;
    private List<TextWatcher> mTextChangedListeners;
    private TextWatcher mTextChangedEventDispatcher;
    private int mFormatRepeatCount = 0;
    private static final int MAX_TEXT_FORMAT_REPEAT = 3;
    private TextPaint mPaint = new TextPaint();
    private int mLineHeight = -1;
    final String ADJUST_POSITION = "adjustPosition";
    final String PASSWORD = "password";
    float keyboardHeight = 0.0f;
    boolean isConfirmHold = false;
    public boolean isNeedConfirm = true;
    private int cursor = -1;
    private String placeholderTextAlign;
    private int selectionStart = Integer.MAX_VALUE;
    private int selectionEnd = Integer.MAX_VALUE;
    private String textAlign = "left";
    private JSONObject placeholderStyle = new JSONObject();
    private float measureHeight = -1.0f;
    private float measureWidht = -1.0f;
    private WXComponent.OnFocusChangeListener mOnFocusChangeListener = new WXComponent.OnFocusChangeListener(){
        int count = 0;

        @Override
        public void onFocusChange(boolean hasFocus) {
            TextView text = (TextView)DCWXInput.this.getHostView();
            if (text == null) {
                return;
            }
            HashMap<String, Object> ret = new HashMap<String, Object>(1);
            HashMap<String, Object> sub = new HashMap<String, Object>(1);
            sub.put("value", text.getText().toString());
            if (hasFocus) {
                if (DCWXInput.this.keyboardHeight == 0.0f) {
                    this.fireEventForFocus(text);
                } else {
                    sub.put("height", Float.valueOf(DCWXInput.this.keyboardHeight));
                    sub.put("value", text.getText().toString());
                    ret.put("detail", sub);
                    DCWXInput.this.fireEvent("focus", ret);
                }
            } else {
                ret.put("detail", sub);
                DCWXInput.this.fireEvent("blur", ret);
            }
        }

        private void fireEventForFocus(final TextView text) {
            ((WXEditText)DCWXInput.this.getHostView()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (DCWXInput.this.keyboardHeight == 0.0f) {
                        ++count;
                        if (count > 3) {
                            HashMap<String, Object> ret = new HashMap<String, Object>(1);
                            HashMap<String, Object> sub = new HashMap<String, Object>(1);
                            sub.put("value", text.getText().toString());
                            sub.put("height", Float.valueOf(DCWXInput.this.keyboardHeight));
                            ret.put("detail", sub);
                            DCWXInput.this.fireEvent("focus", ret);
                            return;
                        }
                        this.fireEventForFocus(text);
                    } else {
                        count = 0;
                        HashMap<String, Object> ret = new HashMap<String, Object>(1);
                        HashMap<String, Object> sub = new HashMap<String, Object>(1);
                        sub.put("value", text.getText().toString());
                        sub.put("height", Float.valueOf(DCWXInput.this.keyboardHeight));
                        ret.put("detail", sub);
                        DCWXInput.this.fireEvent("focus", ret);
                    }
                }
            }, 200L);
        }
    };
    private BroadcastReceiver mTypefaceObserver;
    private String mFontFamily;
    private AtomicBoolean isLayoutFinished = new AtomicBoolean(false);
    private WXSDKInstance.FrameViewEventListener mFrameViewEventListener;

    public DCWXInput(WXSDKInstance instance, WXVContainer parent, boolean isLazy, BasicComponentData basicComponentData) {
        super(instance, parent, isLazy, basicComponentData);
        this.interceptFocusAndBlurEvent();
        this.mInputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        this.setContentBoxMeasurement(new ContentBoxMeasurement(){

            @Override
            public void measureInternal(float width, float height, int widthMeasureMode, int heightMeasureMode) {
                if (DCWXInput.this.getBasicComponentData().getStyles() == null || DCWXInput.this.getBasicComponentData().getStyles().size() == 0) {
                    DCWXInput.this.measureWidht = width;
                }
                if (CSSConstants.isUndefined(height)) {
                    this.mMeasureHeight = WXViewUtils.getRealPxByWidth((float)DCWXInput.this.getInstance().getDefaultFontSize() * 1.4f, DCWXInput.this.getInstance().getInstanceViewPortWidthWithFloat());
                    DCWXInput.this.measureHeight = this.mMeasureHeight;
                }
            }

            @Override
            public void layoutBefore() {
                DCWXInput.this.updateStyleAndAttrs();
            }

            @Override
            public void layoutAfter(float computedWidth, float computedHeight) {
            }
        });
    }

    @Override
    protected void setHostLayoutParams(WXEditText host, int width, int height, int left, int right, int top, int bottom) {
        super.setHostLayoutParams(host, width, height, left, right, top, bottom);
    }

    @Override
    protected void setLayoutSize(GraphicSize mLayoutSize) {
        super.setLayoutSize(mLayoutSize);
    }

    @Override
    protected void layoutDirectionDidChanged(boolean isRTL) {
        String alignStr = (String)this.getStyles().get("textAlign");
        int textAlign = this.getTextAlign(alignStr);
        if (textAlign <= 0) {
            textAlign = 0x800003;
        }
        if (this.getHostView() != null) {
            ((WXEditText)this.getHostView()).setGravity(textAlign | this.getVerticalGravity());
        }
    }

    final float getMeasuredLineHeight() {
        return this.mLineHeight != -1 && this.mLineHeight > 0 ? (float)this.mLineHeight : this.mPaint.getFontMetrics(null);
    }

    protected float getMeasureHeight() {
        return WXViewUtils.getRealPxByWidth(this.getMeasuredLineHeight() < 50.0f ? 50.0f : this.getMeasureHeight(), this.getInstance().getInstanceViewPortWidthWithFloat());
    }

    private void updateStyleAndAttrs() {
        if (this.getStyles().size() > 0) {
            int lineHeight;
            int fontSize = -1;
            int fontStyle = -1;
            int fontWeight = -1;
            String fontFamily = null;
            if (this.getStyles().containsKey("fontSize")) {
                fontSize = WXStyle.getFontSize(this.getStyles(), this.getInstance().getDefaultFontSize(), this.getViewPortWidth());
            }
            if (this.getStyles().containsKey("fontFamily")) {
                fontFamily = WXStyle.getFontFamily(this.getStyles());
            }
            if (this.getStyles().containsKey("fontStyle")) {
                fontStyle = WXStyle.getFontStyle(this.getStyles());
            }
            if (this.getStyles().containsKey("fontWeight")) {
                fontWeight = WXStyle.getFontWeight(this.getStyles());
            }
            if ((lineHeight = WXStyle.getLineHeight(this.getStyles(), this.getViewPortWidth())) != -1) {
                this.mLineHeight = lineHeight;
            }
            if (fontSize != -1) {
                this.mPaint.setTextSize((float)fontSize);
            }
            if (fontFamily != null) {
                TypefaceUtil.applyFontStyle((Paint)this.mPaint, fontStyle, fontWeight, fontFamily);
            }
        }
    }

    @Override
    protected WXEditText initComponentHostView(@NonNull Context context) {
        WXEditText inputView = new WXEditText(context, this.getInstanceId());
        this.appleStyleAfterCreated(inputView);
        inputView.setImeOptions(6);
        return inputView;
    }

    @Override
    protected void onHostViewInitialized(WXEditText host) {
        super.onHostViewInitialized(host);
        if (this.measureWidht > 0.0f) {
            WXBridgeManager.getInstance().setStyleWidth(this.getInstanceId(), this.getRef(), this.measureWidht);
        }
        if (this.measureHeight > 0.0f) {
            WXBridgeManager.getInstance().setStyleHeight(this.getInstanceId(), this.getRef(), this.measureHeight);
        }
        this.addFocusChangeListener(new WXComponent.OnFocusChangeListener(){

            @Override
            public void onFocusChange(boolean hasFocus) {
                int align;
                if (!hasFocus) {
                    DCWXInput.this.decideSoftKeyboard();
                }
                DCWXInput.this.setPseudoClassStatus(":focus", hasFocus);
                if (hasFocus) {
                    DCWXInput.this.setTextAlign(DCWXInput.this.textAlign);
                } else if (DCWXInput.this.getHostView() != null && PdrUtil.isEmpty((Object)((WXEditText)DCWXInput.this.getHostView()).getText().toString()) && (align = DCWXInput.this.getTextAlign(DCWXInput.this.placeholderTextAlign == null ? DCWXInput.this.textAlign : DCWXInput.this.placeholderTextAlign)) > 0) {
                    ((WXEditText)DCWXInput.this.getHostView()).setGravity(align | DCWXInput.this.getVerticalGravity());
                }
            }
        });
        this.addKeyboardListener(host);
        if (this.isNeedConfirm) {
            this.addEditorChangeListener();
        }
    }

    private void addEditorChangeListener() {
        this.addEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (DCWXInput.this.mListeningConfirm && actionId == DCWXInput.this.mEditorAction) {
                    HashMap<String, Object> ret = new HashMap<String, Object>(1);
                    HashMap<String, String> sub = new HashMap<String, String>(1);
                    sub.put("value", v.getText().toString());
                    ret.put("detail", sub);
                    DCWXInput.this.fireEvent("confirm", ret);
                    if (!DCWXInput.this.isConfirmHold) {
                        DCWXInput.this.blur();
                    }
                    return true;
                }
                return DCWXInput.this.isConfirmHold;
            }
        });
    }

    @Override
    protected boolean isConsumeTouch() {
        return !this.isDisabled();
    }

    protected int getVerticalGravity() {
        return 16;
    }

    protected void appleStyleAfterCreated(final WXEditText editText) {
        String alignStr = (String)this.getStyles().get("textAlign");
        int textAlign = this.getTextAlign(alignStr);
        if (textAlign <= 0) {
            textAlign = 0x800003;
        }
        editText.setGravity(textAlign | this.getVerticalGravity());
        int colorInt = WXResourceUtils.getColor("#999999");
        if (colorInt != Integer.MIN_VALUE) {
            editText.setHintTextColor(colorInt);
        }
        this.mTextChangedEventDispatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (DCWXInput.this.mTextChangedListeners != null) {
                    for (TextWatcher watcher : DCWXInput.this.mTextChangedListeners) {
                        watcher.beforeTextChanged(s, start, count, after);
                    }
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (DCWXInput.this.mFormatter != null) {
                    String raw = DCWXInput.this.mFormatter.recover(s.toString());
                    String result = DCWXInput.this.mFormatter.format(raw);
                    if (!result.equals(s.toString()) && DCWXInput.this.mFormatRepeatCount < 3) {
                        DCWXInput.this.mFormatRepeatCount = DCWXInput.this.mFormatRepeatCount + 1;
                        int index = editText.getSelectionStart();
                        int cursorIndex = DCWXInput.this.mFormatter.format(DCWXInput.this.mFormatter.recover(s.subSequence(0, index).toString())).length();
                        editText.setText(result);
                        editText.setSelection(cursorIndex);
                        return;
                    }
                    DCWXInput.this.mFormatRepeatCount = 0;
                }
                if (DCWXInput.this.mTextChangedListeners != null) {
                    for (TextWatcher watcher : DCWXInput.this.mTextChangedListeners) {
                        watcher.onTextChanged(s, start, before, count);
                    }
                }
            }

            public void afterTextChanged(Editable s) {
                if (DCWXInput.this.mTextChangedListeners != null) {
                    for (TextWatcher watcher : DCWXInput.this.mTextChangedListeners) {
                        watcher.afterTextChanged(s);
                    }
                }
            }
        };
        editText.addTextChangedListener(this.mTextChangedEventDispatcher);
        editText.setTextSize(0, WXStyle.getFontSize(this.getStyles(), this.getInstance().getDefaultFontSize(), this.getInstance().getInstanceViewPortWidthWithFloat()));
        editText.setSingleLine(true);
    }

    @Override
    public void addEvent(String type) {
        if (this.getHostView() == null || TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        if (type.equals("input")) {
            this.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    if (DCWXInput.this.mIgnoreNextOnInputEvent) {
                        DCWXInput.this.mIgnoreNextOnInputEvent = false;
                        DCWXInput.this.mBeforeText = s.toString();
                        return;
                    }
                    HashMap<String, Object> ret = new HashMap<String, Object>(1);
                    HashMap<String, Object> sub = new HashMap<String, Object>(3);
                    sub.put("value", s.toString());
                    sub.put("cursor", ((WXEditText)DCWXInput.this.getHostView()).getSelectionEnd());
                    try {
                        if (before == 0 && count != 0) {
                            String charCode = s.subSequence(start, start + count).toString();
                            sub.put("keyCode", Character.codePointAt(charCode, charCode.length() - 1));
                        } else if (before != 0 && count == 0) {
                            String charCode = DCWXInput.this.mBeforeText.subSequence(start, start + before).toString();
                            sub.put("keyCode", Character.codePointAt(charCode, charCode.length() - 1));
                        }
                    }
                    catch (Exception e) {
                        sub.put("keyCode", "0");
                    }
                    DCWXInput.this.mBeforeText = s.toString();
                    ret.put("detail", sub);
                    DCWXInput.this.fireEvent("input", ret);
                }

                public void afterTextChanged(Editable s) {
                }
            });
        }
        if ("confirm".equals(type)) {
            this.mListeningConfirm = true;
        }
        if ("focus".equals(type) || "blur".equals(type)) {
            this.setFocusAndBlur();
        }
        super.addEvent(type);
    }

    protected void setFocusAndBlur() {
        if (!this.ismHasFocusChangeListener(this.mOnFocusChangeListener)) {
            this.addFocusChangeListener(this.mOnFocusChangeListener);
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "disabled": {
                Boolean disabled = WXUtils.getBoolean(param, false);
                ((WXEditText)this.getHostView()).setFocusable(disabled == false);
                ((WXEditText)this.getHostView()).setFocusableInTouchMode(disabled == false);
                ((WXEditText)this.getHostView()).setCursorVisible(disabled == false);
                return true;
            }
            case "placeholder": {
                return true;
            }
            case "placeholderColor": {
                String placeholder_color = WXUtils.getString(param, null);
                if (placeholder_color != null) {
                    this.setPlaceholderColor(placeholder_color);
                }
                return true;
            }
            case "autoFocus": 
            case "focus": {
                Boolean result = WXUtils.getBoolean(param, false);
                this.setAutofocus(result);
                return true;
            }
            case "color": {
                String color2 = WXUtils.getString(param, null);
                if (color2 != null) {
                    this.setColor(color2);
                }
                return true;
            }
            case "fontSize": {
                String fontsize = WXUtils.getString(param, null);
                if (fontsize != null) {
                    this.setFontSize(fontsize);
                }
                return true;
            }
            case "textAlign": {
                String text_align = WXUtils.getString(param, null);
                if (text_align != null) {
                    this.setTextAlign(text_align);
                }
                return true;
            }
            case "singleline": {
                Boolean singLineResult = WXUtils.getBoolean(param, null);
                if (singLineResult != null) {
                    this.setSingleLine(singLineResult);
                }
                return true;
            }
            case "lines": {
                Integer lines = WXUtils.getInteger(param, null);
                if (lines != null) {
                    this.setLines(lines);
                }
                return true;
            }
            case "maxLength": {
                Integer maxlength = WXUtils.getInteger(param, null);
                if (maxlength != null) {
                    this.setMaxLength(maxlength);
                }
                return true;
            }
            case "maxlength": {
                Integer maxLength = WXUtils.getInteger(param, null);
                if (maxLength != null) {
                    this.setMaxLength(maxLength);
                }
                return true;
            }
            case "max": {
                return true;
            }
            case "min": {
                return true;
            }
            case "returnKeyType": {
                this.setReturnKeyType(String.valueOf(param));
                return true;
            }
            case "keepSelectionIndex": {
                return true;
            }
            case "allowCopyPaste": {
                boolean allowCopyPaste = WXUtils.getBoolean(param, true);
                if (this.getHostView() != null) {
                    ((WXEditText)this.getHostView()).setAllowCopyPaste(allowCopyPaste);
                }
                return true;
            }
            case "cursor": {
                int cursor = WXUtils.getInt(param);
                if (cursor > 0 && cursor <= ((WXEditText)this.getHostView()).getText().length()) {
                    ((WXEditText)this.getHostView()).setSelection(cursor);
                } else if (cursor > ((WXEditText)this.getHostView()).getText().length()) {
                    ((WXEditText)this.getHostView()).setSelection(((WXEditText)this.getHostView()).getText().length());
                }
                return true;
            }
            case "confirmHold": {
                this.isConfirmHold = WXUtils.getBoolean(param, false);
                break;
            }
            case "selectionStart": {
                this.selectionStart = WXUtils.getInteger(param, Integer.MAX_VALUE);
                this.setSelectionRange(this.selectionStart, this.selectionEnd);
                break;
            }
            case "selectionEnd": {
                this.selectionEnd = WXUtils.getInteger(param, Integer.MAX_VALUE);
                this.setSelectionRange(this.selectionStart, this.selectionEnd);
                break;
            }
            case "fontFamily": {
                if (param != null) {
                    try {
                        FontDO fontDO = TypefaceUtil.getFontDO(param.toString());
                        if (fontDO != null && fontDO.getTypeface() != null && this.getHostView() != null) {
                            ((WXEditText)this.getHostView()).setTypeface(fontDO.getTypeface());
                        } else {
                            this.registerTypefaceObserver(param.toString());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    private void registerTypefaceObserver(String desiredFontFamily) {
        if (WXEnvironment.getApplication() == null) {
            WXLogUtils.w("WXText", "ApplicationContent is null on register typeface observer");
            return;
        }
        this.mFontFamily = desiredFontFamily;
        if (this.mTypefaceObserver != null) {
            return;
        }
        this.mTypefaceObserver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String fontFamily = intent.getStringExtra("fontFamily");
                if (!DCWXInput.this.mFontFamily.equals(fontFamily)) {
                    return;
                }
                FontDO fontDO = TypefaceUtil.getFontDO(fontFamily);
                if (fontDO != null && fontDO.getTypeface() != null && DCWXInput.this.getHostView() != null) {
                    WXEditText hostView = (WXEditText)DCWXInput.this.getHostView();
                    hostView.setTypeface(fontDO.getTypeface());
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).registerReceiver(this.mTypefaceObserver, new IntentFilter("type_face_available"));
    }

    @WXComponentProp(name="returnKeyType")
    public void setReturnKeyType(String type) {
        if (this.getHostView() == null || type.equals(this.mReturnKeyType)) {
            return;
        }
        this.mReturnKeyType = type;
        switch (type) {
            case "default": {
                this.mEditorAction = 0;
                break;
            }
            case "go": {
                this.mEditorAction = 2;
                break;
            }
            case "next": {
                this.mEditorAction = 5;
                break;
            }
            case "search": {
                this.mEditorAction = 3;
                break;
            }
            case "send": {
                this.mEditorAction = 4;
                break;
            }
            case "done": {
                this.mEditorAction = 6;
                break;
            }
        }
        this.blur();
        ((WXEditText)this.getHostView()).setImeOptions(this.mEditorAction);
    }

    public void setPlaceholder(String placeholder) {
        if (placeholder == null || this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setHint(placeholder);
    }

    @WXComponentProp(name="placeholderColor")
    public void setPlaceholderColor(String color2) {
        int colorInt;
        if (this.getHostView() != null && !TextUtils.isEmpty((CharSequence)color2) && (colorInt = WXResourceUtils.getColor(color2)) != Integer.MIN_VALUE) {
            ((WXEditText)this.getHostView()).setHintTextColor(colorInt);
        }
    }

    public void setType(String type) {
        Log.e((String)"weex", (String)("setType=" + type));
        if (type == null || this.getHostView() == null || this.mType.equals(type)) {
            return;
        }
        this.mType = type;
        ((EditText)this.getHostView()).setInputType(this.getInputType(this.mType));
    }

    @WXComponentProp(name="autofocus")
    public void setAutofocus(final boolean autofocus) {
        if (this.getHostView() == null) {
            return;
        }
        final EditText inputView = (EditText)this.getHostView();
        if (!this.isLayoutFinished.get()) {
            if (this.getInstance().isFrameViewShow()) {
                ((WXEditText)this.getHostView()).getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        if (DCWXInput.this.getInstance() == null) {
                            return;
                        }
                        if (autofocus) {
                            DCWXInput.this.isLayoutFinished.set(true);
                            DCWXInput.this.hostViewFocus(inputView);
                            DCWXInput.this.setSelectionRange(DCWXInput.this.selectionStart, DCWXInput.this.selectionEnd);
                        } else {
                            inputView.clearFocus();
                        }
                        ((WXEditText)DCWXInput.this.getHostView()).getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                });
            } else {
                if (this.mFrameViewEventListener != null) {
                    this.getInstance().removeFrameViewEventListener(this.mFrameViewEventListener);
                }
                this.mFrameViewEventListener = new WXSDKInstance.FrameViewEventListener(){

                    @Override
                    public void onShowAnimationEnd() {
                        if (DCWXInput.this.getInstance() == null) {
                            return;
                        }
                        if (autofocus) {
                            DCWXInput.this.isLayoutFinished.set(true);
                            DCWXInput.this.hostViewFocus(inputView);
                            DCWXInput.this.setSelectionRange(DCWXInput.this.selectionStart, DCWXInput.this.selectionEnd);
                        } else {
                            inputView.clearFocus();
                        }
                        DCWXInput.this.getInstance().removeFrameViewEventListener(this);
                        DCWXInput.this.mFrameViewEventListener = null;
                    }
                };
                this.getInstance().addFrameViewEventListener(this.mFrameViewEventListener);
            }
        } else {
            if (autofocus) {
                this.hostViewFocus(inputView);
            } else {
                this.hideSoftKeyboard();
            }
            inputView.clearFocus();
        }
    }

    @WXComponentProp(name="adjustPosition")
    public void setAdjustPosition(Object value) {
        if (this.getHostView() != null) {
            boolean isAdjustPan = WXUtils.getBoolean(value, true);
            String mode = isAdjustPan ? DCKeyboardManager.SOFT_INPUT_MODE_ADJUST_PAN : DCKeyboardManager.SOFT_INPUT_MODE_ADJUST_NOTHING;
            ((WXEditText)this.getHostView()).setInputSoftMode(mode);
        }
    }

    private void hostViewFocus(EditText inputView) {
        inputView.setFocusable(true);
        inputView.setFocusableInTouchMode(true);
        inputView.setCursorVisible(true);
        inputView.requestFocus();
        this.showSoftKeyboard();
    }

    @WXComponentProp(name="value")
    public void setText(String value) {
        WXEditText view = (WXEditText)this.getHostView();
        if (view == null) {
            return;
        }
        if (TextUtils.equals((CharSequence)view.getText(), (CharSequence)value)) {
            return;
        }
        this.mIgnoreNextOnInputEvent = true;
        view.setText(value);
        int index = this.cursor > 0 ? this.cursor : value.length();
        view.setSelection(value == null ? 0 : index);
    }

    @WXComponentProp(name="color")
    public void setColor(String color2) {
        int colorInt;
        if (this.getHostView() != null && !TextUtils.isEmpty((CharSequence)color2) && (colorInt = WXResourceUtils.getColor(color2)) != Integer.MIN_VALUE) {
            ((WXEditText)this.getHostView()).setTextColor(colorInt);
        }
    }

    @WXComponentProp(name="fontSize")
    public void setFontSize(String fontSize) {
        if (this.getHostView() != null && fontSize != null) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("fontSize", fontSize);
            ((WXEditText)this.getHostView()).setTextSize(0, WXStyle.getFontSize(map, this.getInstance().getDefaultFontSize(), this.getInstance().getInstanceViewPortWidthWithFloat()));
        }
    }

    @WXComponentProp(name="placeholderStyle")
    public void setPlaceholderStyle(JSONObject styleStr1) {
        if (this.placeholderStyle == null || this.placeholderStyle.isEmpty()) {
            return;
        }
        CharSequence hint = ((WXEditText)this.getHostView()).getHint();
        if (hint == null && this.getAttrs().containsKey("placeholder")) {
            hint = WXUtils.getString(this.getAttrs().get("placeholder"), "");
        }
        SpannableString ss = new SpannableString(hint);
        AbsoluteSizeSpan sizeSpan = new AbsoluteSizeSpan((int)((WXEditText)this.getHostView()).getTextSize());
        ForegroundColorSpan foreSpan = new ForegroundColorSpan(((WXEditText)this.getHostView()).getCurrentHintTextColor());
        BackgroundColorSpan backSpan = null;
        StyleSpan styleSpan = null;
        for (Map.Entry set : this.placeholderStyle.entrySet()) {
            block12 : switch ((String)set.getKey()) {
                case "opacity": {
                    break;
                }
                case "background-color": 
                case "backgroundColor": {
                    String color1 = String.valueOf(set.getValue());
                    int colorInt1 = WXResourceUtils.getColor(color1);
                    if (colorInt1 == Integer.MIN_VALUE) break;
                    backSpan = new BackgroundColorSpan(colorInt1);
                    break;
                }
                case "color": {
                    String color2 = String.valueOf(set.getValue());
                    int colorInt = WXResourceUtils.getColor(color2);
                    if (colorInt == Integer.MIN_VALUE) break;
                    foreSpan = new ForegroundColorSpan(colorInt);
                    break;
                }
                case "text-align": 
                case "textAlign": {
                    this.placeholderTextAlign = String.valueOf(set.getValue());
                    int align = this.getTextAlign(String.valueOf(set.getValue()));
                    if (align <= 0) break;
                    ((WXEditText)this.getHostView()).setGravity(align | this.getVerticalGravity());
                    break;
                }
                case "font-weight": 
                case "fontWeight": {
                    switch (String.valueOf(set.getValue())) {
                        case "600": 
                        case "700": 
                        case "800": 
                        case "900": 
                        case "bold": {
                            styleSpan = new StyleSpan(1);
                            break block12;
                        }
                    }
                    styleSpan = new StyleSpan(0);
                    break;
                }
                case "font-size": 
                case "fontSize": {
                    String size = String.valueOf(set.getValue());
                    if (size.endsWith("px")) {
                        size = size.replaceAll("px", "");
                    } else if (size.endsWith("wx")) {
                        size = size.replaceAll("wx", "");
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>(1);
                    map.put("fontSize", size);
                    sizeSpan = new AbsoluteSizeSpan(WXUtils.getInteger(WXStyle.getFontSize(map, this.getInstance().getDefaultFontSize(), this.getInstance().getInstanceViewPortWidthWithFloat()), this.getInstance().getDefaultFontSize()).intValue());
                }
            }
        }
        ss.setSpan((Object)sizeSpan, 0, ss.length(), 33);
        if (backSpan != null) {
            ss.setSpan(backSpan, 0, ss.length(), 33);
        }
        if (styleSpan != null) {
            ss.setSpan(styleSpan, 0, ss.length(), 33);
        }
        ss.setSpan((Object)foreSpan, 0, ss.length(), 33);
        ((WXEditText)this.getHostView()).setHint((CharSequence)ss);
    }

    @WXComponentProp(name="placeholderClass")
    public void setPlaceholderClass(JSONObject styles) {
        this.setPlaceholderStyle(styles);
    }

    @WXComponentProp(name="textAlign")
    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
        int align = this.getTextAlign(textAlign);
        if (align > 0) {
            ((WXEditText)this.getHostView()).setGravity(align | this.getVerticalGravity());
        }
    }

    @WXComponentProp(name="singleline")
    public void setSingleLine(boolean singleLine) {
        if (this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setSingleLine(singleLine);
    }

    @WXComponentProp(name="lines")
    public void setLines(int lines) {
        if (this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setLines(lines);
    }

    @WXComponentProp(name="maxLength")
    public void setMaxLength(int maxLength) {
        if (this.getHostView() == null) {
            return;
        }
        if (maxLength == -1) {
            maxLength = Integer.MAX_VALUE;
        }
        ((WXEditText)this.getHostView()).setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
    }

    @WXComponentProp(name="maxlength")
    @Deprecated
    public void setMaxlength(int maxLength) {
        this.setMaxLength(maxLength);
    }

    private int getInputType(String type) {
        int inputType;
        switch (type) {
            case "text": {
                inputType = 1;
                break;
            }
            case "date": {
                inputType = 0;
                ((WXEditText)this.getHostView()).setFocusable(false);
                break;
            }
            case "datetime": {
                inputType = 4;
                break;
            }
            case "email": {
                inputType = 33;
                break;
            }
            case "password": {
                inputType = 129;
                if (this.getHostView() == null) break;
                ((WXEditText)this.getHostView()).setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                break;
            }
            case "tel": {
                inputType = 3;
                break;
            }
            case "time": {
                inputType = 0;
                if (this.getHostView() == null) break;
                ((WXEditText)this.getHostView()).setFocusable(false);
                break;
            }
            case "url": {
                inputType = 17;
                break;
            }
            case "digit": {
                inputType = 8194;
                break;
            }
            case "number": {
                inputType = 2;
                break;
            }
            default: {
                inputType = 1;
            }
        }
        return inputType;
    }

    @WXComponentProp(name="cursorSpacing")
    public void setCursorSpacing(String v) {
        if (this.getHostView() != null) {
            float spacing = UniViewUtils.getRealPxByWidth(UniUtils.getFloat(v), this.getInstance().getInstanceViewPortWidthWithFloat());
            ((WXEditText)this.getHostView()).setCursorSpacing(spacing);
        }
    }

    private void showSoftKeyboard() {
        if (this.getHostView() != null) {
            ((WXEditText)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    DCWXInput.this.mInputMethodManager.showSoftInput(DCWXInput.this.getHostView(), 1);
                }
            }), 100L);
        }
    }

    void hideSoftKeyboard() {
        if (this.getHostView() != null) {
            ((WXEditText)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    DCWXInput.this.mInputMethodManager.hideSoftInputFromWindow(((WXEditText)DCWXInput.this.getHostView()).getWindowToken(), 0);
                }
            }), 16L);
        }
    }

    private int getTextAlign(String textAlign) {
        int align;
        boolean isRTL = this.isLayoutRTL();
        int n = align = isRTL ? 0x800005 : 0x800003;
        if (TextUtils.isEmpty((CharSequence)textAlign)) {
            return align;
        }
        switch (textAlign) {
            case "left": {
                align = 0x800003;
                break;
            }
            case "center": {
                align = 17;
                break;
            }
            case "right": {
                align = 0x800005;
            }
        }
        return align;
    }

    @JSMethod
    public void blur() {
        WXEditText host = (WXEditText)this.getHostView();
        if (host != null && host.hasFocus()) {
            if (this.getParent() != null) {
                this.getParent().interceptFocus();
            }
            host.clearFocus();
            this.hideSoftKeyboard();
        }
    }

    public String getValue() {
        return ((WXEditText)this.getHostView()).getText().toString();
    }

    @JSMethod
    public void setValue(String text) {
        WXEditText host = (WXEditText)this.getHostView();
        host.setText(text);
    }

    @JSMethod
    public void focus() {
        WXEditText host = (WXEditText)this.getHostView();
        if (host != null && !host.hasFocus()) {
            if (this.getParent() != null) {
                this.getParent().ignoreFocus();
            }
            host.requestFocus();
            host.setFocusable(true);
            host.setFocusableInTouchMode(true);
            this.showSoftKeyboard();
        }
    }

    @Override
    protected Object convertEmptyProperty(String propName, Object originalValue) {
        switch (propName) {
            case "fontSize": {
                return this.getInstance().getDefaultFontSize();
            }
            case "color": {
                return "black";
            }
        }
        return super.convertEmptyProperty(propName, originalValue);
    }

    private void decideSoftKeyboard() {
        Context context;
        Object hostView = this.getHostView();
        if (hostView != null && (context = this.getContext()) instanceof Activity) {
            hostView.postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    View currentFocus = ((Activity)context).getCurrentFocus();
                    if (currentFocus != null && !(currentFocus instanceof EditText) && !currentFocus.isFocused()) {
                        DCWXInput.this.mInputMethodManager.hideSoftInputFromWindow(((WXEditText)DCWXInput.this.getHostView()).getWindowToken(), 0);
                    }
                }
            }), 16L);
        }
    }

    private void setSelectionRange(int selectionStart, int selectionEnd) {
        EditText hostView;
        if (selectionEnd != Integer.MAX_VALUE && selectionStart != Integer.MAX_VALUE && (hostView = (EditText)this.getHostView()) != null) {
            int length = ((WXEditText)this.getHostView()).length();
            if (selectionStart > selectionEnd) {
                return;
            }
            if (selectionStart < 0) {
                selectionStart = 0;
            }
            if (selectionEnd > length) {
                selectionEnd = length;
            }
            if (selectionEnd < 0) {
                selectionEnd = 0;
            }
            hostView.setSelection(selectionStart, selectionEnd);
        }
    }

    @UniJSMethod
    public void getSelectionRange(String callbackId) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(2);
        EditText hostView = (EditText)this.getHostView();
        if (hostView != null) {
            int start = hostView.getSelectionStart();
            int end = hostView.getSelectionEnd();
            if (!hostView.hasFocus()) {
                start = 0;
                end = 0;
            }
            result.put("selectionStart", start);
            result.put("selectionEnd", end);
        }
        WXBridgeManager.getInstance().callback(this.getInstanceId(), callbackId, result, false);
    }

    @UniJSMethod
    public void getCursor(JSCallback callback) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        if (this.getHostView() != null && ((WXEditText)this.getHostView()).isFocused()) {
            map.put("cursor", ((WXEditText)this.getHostView()).getSelectionEnd());
        } else {
            map.put("cursor", 0);
        }
        callback.invoke(map);
    }

    @JSMethod
    public void setTextFormatter(JSONObject params) {
        try {
            String formatRule = params.getString("formatRule");
            String formatReplace = params.getString("formatReplace");
            String recoverRule = params.getString("recoverRule");
            String recoverReplace = params.getString("recoverReplace");
            PatternWrapper format = this.parseToPattern(formatRule, formatReplace);
            PatternWrapper recover = this.parseToPattern(recoverRule, recoverReplace);
            if (format != null && recover != null) {
                this.mFormatter = new TextFormatter(format, recover);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private final void addEditorActionListener(TextView.OnEditorActionListener listener) {
        TextView view;
        if (listener != null && (view = (TextView)this.getHostView()) != null) {
            if (this.mEditorActionListeners == null) {
                this.mEditorActionListeners = new ArrayList<TextView.OnEditorActionListener>();
                view.setOnEditorActionListener(new TextView.OnEditorActionListener(){
                    private boolean handled = true;

                    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                        for (TextView.OnEditorActionListener l : DCWXInput.this.mEditorActionListeners) {
                            if (l == null) continue;
                            this.handled &= l.onEditorAction(v, actionId, event);
                        }
                        return this.handled;
                    }
                });
            }
            this.mEditorActionListeners.add(listener);
        }
    }

    void addTextChangedListener(TextWatcher watcher) {
        if (this.mTextChangedListeners == null) {
            this.mTextChangedListeners = new ArrayList<TextWatcher>();
        }
        this.mTextChangedListeners.add(watcher);
    }

    private void addKeyboardListener(final WXEditText host) {
        if (host == null) {
            return;
        }
        Context context = host.getContext();
        if (context instanceof Activity) {
            ((WXEditText)this.getHostView()).setkeyBoardHeightChangeListener(new DCEditText.OnKeyboardHeightChangeListener(){

                public void onChange(boolean isShown, int keyBoardHeight) {
                    if (DCWXInput.this.getInstance() == null || DCWXInput.this.getInstance().isDestroy() || host == null) {
                        return;
                    }
                    DCWXInput.this.keyboardHeight = (int)WXViewUtils.getWebPxByWidth((float)keyBoardHeight, DCWXInput.this.getInstance().getInstanceViewPortWidthWithFloat());
                    HashMap<String, Number> event = new HashMap<String, Number>(2);
                    event.put("height", Float.valueOf(DCWXInput.this.keyboardHeight));
                    event.put("duration", 0);
                    HashMap<String, Object> ret = new HashMap<String, Object>(1);
                    ret.put("detail", event);
                    DCWXInput.this.fireEvent("keyboardheightchange", ret);
                    if (host.isFocused()) {
                        String inputType;
                        String string2 = inputType = DCWXInput.this.isPassword ? "password" : DCWXInput.this.mType;
                        if (!(isShown || DCWXInput.this.isConfirmHold || inputType.equalsIgnoreCase("password") || DCKeyboardManager.getInstance().getFrontInputType().equals("password"))) {
                            DCWXInput.this.blur();
                        }
                        if (isShown) {
                            DCKeyboardManager.getInstance().setFrontInputType(inputType);
                        }
                    }
                    if (isShown) {
                        DCWXInput.this.keyboardHeight = DCWXInput.this.keyboardHeight;
                    }
                }
            });
        }
    }

    @Override
    public void updateProperties(Map<String, Object> props) {
        if (props != null && props.size() > 0) {
            this.setType(props.containsKey("type") ? String.valueOf(props.get("type")) : this.mType);
            if (this.mType != null && this.mType.equals("text") && props.containsKey("confirmType")) {
                this.setReturnKeyType(props.containsKey("confirmType") ? String.valueOf(props.get("confirmType")) : (this.mReturnKeyType == null ? "done" : this.mReturnKeyType));
            }
            if (this.getAttrs().containsKey("password")) {
                String type;
                this.isPassword = WXUtils.getBoolean(this.getAttrs().get("password"), false);
                String string2 = type = this.isPassword ? "password" : this.mType;
                if (type == null || this.getHostView() == null) {
                    return;
                }
                ((EditText)this.getHostView()).setInputType(this.getInputType(type));
            }
            if (props.containsKey("cursor")) {
                this.cursor = WXUtils.getInteger(props.get("cursor"), 0);
            }
            if (props.containsKey("selectionStart")) {
                this.selectionStart = WXUtils.getInteger(props.get("selectionStart"), Integer.MAX_VALUE);
            }
            if (props.containsKey("selectionEnd")) {
                this.selectionEnd = WXUtils.getInteger(props.get("selectionEnd"), Integer.MAX_VALUE);
            }
            if (props.containsKey("placeholder")) {
                this.setPlaceholder(WXUtils.getString(props.get("placeholder"), ""));
            }
            if (props.containsKey("placeholderClass")) {
                this.placeholderStyle.putAll((Map)((JSONObject)JSONObject.parse((String)WXUtils.getString(props.get("placeholderClass"), "{}"))));
            }
            if (props.containsKey("placeholderStyle")) {
                this.placeholderStyle.putAll((Map)((JSONObject)JSONObject.parse((String)WXUtils.getString(props.get("placeholderStyle"), "{}"))));
            }
            if (props.containsKey("adjustPosition")) {
                this.setAdjustPosition(props.get("adjustPosition"));
            }
        }
        super.updateProperties(props);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mEditorActionListeners != null) {
            this.mEditorActionListeners.clear();
        }
        if (this.mTextChangedListeners != null) {
            this.mTextChangedListeners.clear();
        }
        if (this.mTextChangedEventDispatcher != null) {
            this.mTextChangedEventDispatcher = null;
        }
        if (this.getHostView() != null) {
            ((WXEditText)this.getHostView()).destroy();
        }
    }

    private PatternWrapper parseToPattern(String jsPattern, String replace) {
        if (jsPattern == null || replace == null) {
            return null;
        }
        String checker = "/[\\S]+/[i]?[m]?[g]?";
        if (!Pattern.compile(checker).matcher(jsPattern).matches()) {
            WXLogUtils.w("WXInput", "Illegal js pattern syntax: " + jsPattern);
            return null;
        }
        int flags = 0;
        boolean global = false;
        String flagsStr = jsPattern.substring(jsPattern.lastIndexOf("/") + 1);
        String regExp = jsPattern.substring(jsPattern.indexOf("/") + 1, jsPattern.lastIndexOf("/"));
        if (flagsStr.contains("i")) {
            flags |= 2;
        }
        if (flagsStr.contains("m")) {
            flags |= 0x20;
        }
        if (flagsStr.contains("g")) {
            global = true;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regExp, flags);
        }
        catch (PatternSyntaxException e) {
            WXLogUtils.w("WXInput", "Pattern syntax error: " + regExp);
        }
        if (pattern == null) {
            return null;
        }
        PatternWrapper wrapper = new PatternWrapper();
        wrapper.global = global;
        wrapper.matcher = pattern;
        wrapper.replace = replace;
        return wrapper;
    }

    public static class TextFormatter {
        private PatternWrapper format;
        private PatternWrapper recover;

        private TextFormatter(PatternWrapper format, PatternWrapper recover) {
            this.format = format;
            this.recover = recover;
        }

        String format(String src) {
            try {
                if (this.format != null) {
                    if (this.format.global) {
                        return this.format.matcher.matcher(src).replaceAll(this.format.replace);
                    }
                    return this.format.matcher.matcher(src).replaceFirst(this.format.replace);
                }
            }
            catch (Throwable t) {
                WXLogUtils.w("WXInput", "[format] " + t.getMessage());
            }
            return src;
        }

        String recover(String formatted) {
            try {
                if (this.recover != null) {
                    if (this.recover.global) {
                        return this.recover.matcher.matcher(formatted).replaceAll(this.recover.replace);
                    }
                    return this.recover.matcher.matcher(formatted).replaceFirst(this.recover.replace);
                }
            }
            catch (Throwable t) {
                WXLogUtils.w("WXInput", "[formatted] " + t.getMessage());
            }
            return formatted;
        }
    }

    private static class PatternWrapper {
        private boolean global = false;
        private Pattern matcher;
        private String replace;

        private PatternWrapper() {
        }
    }

    private static interface ReturnTypes {
        public static final String DEFAULT = "default";
        public static final String GO = "go";
        public static final String NEXT = "next";
        public static final String SEARCH = "search";
        public static final String SEND = "send";
        public static final String DONE = "done";
    }
}

