/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import com.taobao.weex.utils.WXLogUtils;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.weex.DCFileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class WXFileUtils {
    public static String loadFileOrAsset(String path, Context context) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            File file = new File(path);
            if (file.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(file);
                    return WXFileUtils.readStreamToString(fis);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                return WXFileUtils.loadAsset(path, context);
            }
        }
        return "";
    }

    public static String loadAsset(String path, Context context) {
        if (context == null || TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        InputStream inputStream = null;
        try {
            path = DCFileUtils.getAssetPath(path);
            inputStream = DCFileUtils.loadWeexAsset(path, context);
            if (inputStream == null) {
                inputStream = context.getAssets().open(path);
            }
            return WXFileUtils.readStreamToString(inputStream);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStreamToString(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        try {
            StringBuilder builder = new StringBuilder(inputStream.available() + 10);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            char[] data = new char[4096];
            int len = -1;
            while ((len = bufferedReader.read(data)) > 0) {
                builder.append(data, 0, len);
            }
            String string2 = builder.toString();
            return string2;
        }
        catch (IOException e) {
            WXLogUtils.e("", e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                WXLogUtils.e("WXFileUtils loadAsset: ", e);
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                WXLogUtils.e("WXFileUtils loadAsset: ", e);
            }
        }
        return "";
    }

    public static byte[] readBytesFromAssets(String path, Context context) {
        if (context == null || TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(path);
            byte[] data = new byte[4096];
            int length = inputStream.read(data);
            byte[] result = new byte[length];
            System.arraycopy(data, 0, result, 0, length);
            return result;
        }
        catch (IOException e) {
            WXLogUtils.e("", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFile(String path, byte[] content, Context context) {
        if (TextUtils.isEmpty((CharSequence)path) || content == null || context == null) {
            return false;
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(path);
            outStream.write(content);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            WXLogUtils.e("WXFileUtils saveFile: " + WXLogUtils.getStackTrace(e));
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static String md5(String template) {
        try {
            if (template == null) {
                return "";
            }
            return WXFileUtils.md5(template.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String md5(byte[] bts) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(bts);
            BigInteger bigInt = new BigInteger(1, digest.digest());
            return bigInt.toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    public static String base64Md5(String template) {
        try {
            if (template == null) {
                return "";
            }
            return WXFileUtils.base64Md5(template.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String base64Md5(byte[] bts) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(bts);
            return Base64.encodeToString((byte[])digest.digest(), (int)2);
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    private static String[] validCPUABIS() {
        String[] supportedAbis = null;
        if (Build.VERSION.SDK_INT >= 21) {
            supportedAbis = Build.SUPPORTED_ABIS;
        }
        if (null == supportedAbis || supportedAbis.length == 0) {
            supportedAbis = new String[]{Build.CPU_ABI};
        }
        return supportedAbis;
    }

    private static boolean validLibPath(String path) {
        String[] supportedAbis;
        for (String item : supportedAbis = WXFileUtils.validCPUABIS()) {
            if (!path.contains(item)) continue;
            return true;
        }
        return false;
    }

    private static boolean replaceLib(String replaceLibAbi, String currentLibAbi) {
        if (null != replaceLibAbi && null != currentLibAbi) {
            String[] supportedAbis;
            boolean replaceFind = false;
            for (String item : supportedAbis = WXFileUtils.validCPUABIS()) {
                if (currentLibAbi.contains(item) && replaceFind) {
                    return true;
                }
                if (!replaceLibAbi.contains(item)) continue;
                replaceFind = true;
            }
            return false;
        }
        return true;
    }

    public static boolean extractSo(String apkFile, String path) throws IOException {
        boolean exist = false;
        if (!PdrUtil.isSafeEntryName((String)apkFile) || !PdrUtil.isSafeEntryName((String)path)) {
            return false;
        }
        HashMap<String, String> currentABIMap = new HashMap<String, String>();
        ZipFile zip = new ZipFile(apkFile);
        BufferedInputStream zipInputStream = new BufferedInputStream(new FileInputStream(apkFile));
        ZipInputStream zin = new ZipInputStream(zipInputStream);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (zipEntry.isDirectory() || !WXFileUtils.validLibPath(zipEntry.getName()) || !zipEntry.getName().contains("weex") && !zipEntry.getName().equals("libjsc.so") && !zipEntry.getName().equals("libJavaScriptCore.so")) continue;
            exist = true;
            String[] fileNames = zipEntry.getName().split("/");
            String fileName = fileNames[fileNames.length - 1];
            File zipFile = new File(path + "/" + fileName);
            String currentABI = (String)currentABIMap.get(fileName);
            if (!WXFileUtils.replaceLib(zipEntry.getName(), currentABI)) continue;
            currentABIMap.put(fileName, zipEntry.getName());
            if (zipFile.exists()) {
                zipFile.delete();
            }
            InputStream inputStream = zip.getInputStream(zipEntry);
            byte[] data = new byte[1024];
            zipFile.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(zipFile);
            while (inputStream.read(data) != -1) {
                outputStream.write(data);
            }
            outputStream.close();
        }
        zin.closeEntry();
        return exist;
    }

    public static void copyFile(File oldFile, File newFile) {
        block8: {
            FileInputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = new FileInputStream(oldFile);
                byte[] data = new byte[1024];
                outputStream = new FileOutputStream(newFile);
                while (inputStream.read(data) != -1) {
                    outputStream.write(data);
                }
                inputStream.close();
                outputStream.close();
            }
            catch (Exception e) {
                WXLogUtils.e("copyFile " + e.getMessage() + ": " + oldFile.getAbsolutePath() + ": " + newFile.getAbsolutePath());
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (outputStream == null) break block8;
                try {
                    outputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void copyFileWithException(File oldFile, File newFile) throws Exception {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(oldFile);
            byte[] data = new byte[1024];
            outputStream = new FileOutputStream(newFile);
            while (inputStream.read(data) != -1) {
                outputStream.write(data);
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                WXFileUtils.closeIo(inputStream);
                WXFileUtils.closeIo(outputStream);
                throw throwable;
            }
        }
        WXFileUtils.closeIo(inputStream);
        WXFileUtils.closeIo(outputStream);
    }

    public static void closeIo(Closeable c) {
        if (null == c) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

