/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.extend;

import android.content.Context;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.ViewPager;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXIndicator;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.BaseFrameLayout;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.feature.weex.extend.DCWXCircleViewPager;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

@Component(lazyload=false)
public class DCWXSlider
extends WXVContainer<FrameLayout> {
    public static final String INDEX = "index";
    public static final String SOURCE = "source";
    public static final String INFINITE = "infinite";
    private boolean isInfinite = true;
    Map<String, Object> params = new HashMap<String, Object>();
    private float offsetXAccuracy = 0.1f;
    private int initIndex = -1;
    private boolean keepIndex = true;
    private Runnable initRunnable;
    DCWXCircleViewPager mViewPager;
    protected WXIndicator mIndicator;
    protected WXCirclePageAdapter mAdapter;
    protected boolean mShowIndicators = true;
    protected ViewPager.OnPageChangeListener mPageChangeListener = new SliderPageChangeListener();
    protected boolean isDrag = false;

    @Deprecated
    public DCWXSlider(WXSDKInstance instance, WXVContainer parent, String instanceId, boolean isLazy, BasicComponentData basicComponentData) {
        this(instance, parent, basicComponentData);
    }

    public DCWXSlider(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
    }

    @Override
    protected BaseFrameLayout initComponentHostView(@NonNull Context context) {
        BaseFrameLayout view = new BaseFrameLayout(context);
        if (this.getAttrs() != null) {
            Object obj = this.getAttrs().get(INFINITE);
            this.isInfinite = WXUtils.getBoolean(obj, true);
        }
        FrameLayout.LayoutParams pagerParams = new FrameLayout.LayoutParams(-1, -1);
        this.mViewPager = new DCWXCircleViewPager(context);
        this.mViewPager.setCircle(this.isInfinite);
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)pagerParams);
        this.mAdapter = new WXCirclePageAdapter(this.isInfinite);
        this.mViewPager.setAdapter(this.mAdapter);
        view.addView((View)this.mViewPager);
        this.mViewPager.addOnPageChangeListener(this.mPageChangeListener);
        this.registerActivityStateListener();
        return view;
    }

    @Override
    public ViewGroup.LayoutParams getChildLayoutParams(WXComponent child, View childView, int width, int height, int left, int right, int top, int bottom) {
        ViewGroup.LayoutParams lp = childView.getLayoutParams();
        if (lp == null) {
            lp = new FrameLayout.LayoutParams(width, height);
        } else {
            lp.width = width;
            lp.height = height;
        }
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            if (child instanceof WXIndicator) {
                this.setMarginsSupportRTL((ViewGroup.MarginLayoutParams)lp, left, top, right, bottom);
            } else {
                this.setMarginsSupportRTL((ViewGroup.MarginLayoutParams)lp, 0, 0, 0, 0);
            }
        }
        return lp;
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if ("scroll".equals(type)) {
            if (this.mViewPager == null) {
                return;
            }
            this.mViewPager.addOnPageChangeListener(new SliderOnScrollListener(this));
        }
    }

    @Override
    public boolean containsGesture(WXGestureType WXGestureType2) {
        return super.containsGesture(WXGestureType2);
    }

    @Override
    public ViewGroup getRealView() {
        return this.mViewPager;
    }

    @Override
    public void addSubView(View view, int index) {
        if (view == null || this.mAdapter == null) {
            return;
        }
        if (view instanceof WXCircleIndicator) {
            return;
        }
        this.mAdapter.addPageView(view);
        this.hackTwoItemsInfiniteScroll();
        if (this.initIndex != -1 && this.mAdapter.getRealCount() > this.initIndex) {
            if (this.initRunnable == null) {
                this.initRunnable = new Runnable(){

                    @Override
                    public void run() {
                        DCWXSlider.this.initIndex = DCWXSlider.this.getInitIndex();
                        int realIndex = DCWXSlider.this.getRealIndex(DCWXSlider.this.initIndex);
                        DCWXSlider.this.mViewPager.setCurrentItem(realIndex);
                        DCWXSlider.this.initIndex = -1;
                        DCWXSlider.this.initRunnable = null;
                    }
                };
            }
            this.initIndex = this.getInitIndex();
            this.mViewPager.setCurrentItem(this.getRealIndex(this.initIndex));
            this.mViewPager.removeCallbacks(this.initRunnable);
            this.mViewPager.postDelayed(this.initRunnable, 50L);
        } else if (!this.keepIndex) {
            this.mViewPager.setCurrentItem(this.getRealIndex(0));
        }
        if (this.mIndicator != null) {
            ((WXCircleIndicator)this.mIndicator.getHostView()).forceLayout();
            ((WXCircleIndicator)this.mIndicator.getHostView()).requestLayout();
        }
    }

    @Override
    public void setLayout(WXComponent component) {
        if (this.mAdapter != null) {
            this.mAdapter.setLayoutDirectionRTL(this.isLayoutRTL());
        }
        super.setLayout(component);
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        if (child == null || child.getHostView() == null || this.mAdapter == null) {
            return;
        }
        this.mAdapter.removePageView((View)child.getHostView());
        this.hackTwoItemsInfiniteScroll();
        super.remove(child, destroy);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mViewPager != null) {
            this.mViewPager.stopAutoScroll();
            this.mViewPager.removeAllViews();
            this.mViewPager.destory();
        }
    }

    @Override
    public void onActivityResume() {
        super.onActivityResume();
        if (this.mViewPager != null && this.mViewPager.isAutoScroll()) {
            this.mViewPager.startAutoScroll();
        }
    }

    @Override
    public void onActivityStop() {
        super.onActivityStop();
        if (this.mViewPager != null) {
            this.mViewPager.pauseAutoScroll();
        }
    }

    public int getCurrentIndex() {
        if (this.mViewPager != null) {
            return this.mViewPager.superGetCurrentItem();
        }
        return -1;
    }

    public void addIndicator(WXIndicator indicator) {
        FrameLayout root = (FrameLayout)this.getHostView();
        if (root == null) {
            return;
        }
        this.mIndicator = indicator;
        this.mIndicator.setShowIndicators(this.mShowIndicators);
        WXCircleIndicator indicatorView = (WXCircleIndicator)indicator.getHostView();
        if (indicatorView != null) {
            indicatorView.setCircleViewPager(this.mViewPager);
            root.addView((View)indicatorView);
        }
    }

    private int getInitIndex() {
        Object index = this.getAttrs().get(INDEX);
        if (index == null) {
            return 0;
        }
        int select = WXUtils.getInteger(index, this.initIndex);
        if (this.mAdapter == null || this.mAdapter.getCount() == 0) {
            return 0;
        }
        if (select >= this.mAdapter.getRealCount()) {
            select %= this.mAdapter.getRealCount();
        }
        return select;
    }

    private int getRealIndex(int idx) {
        int retIdx = idx;
        if (this.mAdapter.getRealCount() > 0) {
            if (idx >= this.mAdapter.getRealCount()) {
                retIdx = this.mAdapter.getRealCount() - 1;
            }
            if (this.isLayoutRTL()) {
                retIdx = this.mAdapter.getRealCount() - 1 - retIdx;
            }
        }
        return retIdx += 0;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "value": {
                String value = WXUtils.getString(param, null);
                if (value != null) {
                    this.setValue(value);
                }
                return true;
            }
            case "autoPlay": {
                String aotu_play = WXUtils.getString(param, null);
                if (aotu_play != null) {
                    this.setAutoPlay(aotu_play);
                }
                return true;
            }
            case "showIndicators": {
                String indicators = WXUtils.getString(param, null);
                if (indicators != null) {
                    this.setShowIndicators(indicators);
                }
                return true;
            }
            case "interval": {
                Integer interval = WXUtils.getInteger(param, null);
                if (interval != null) {
                    this.setInterval(interval);
                }
                return true;
            }
            case "index": {
                Integer index = WXUtils.getInteger(param, null);
                if (index != null) {
                    this.setIndex(index);
                }
                return true;
            }
            case "offsetXAccuracy": {
                Float accuracy = WXUtils.getFloat(param, Float.valueOf(0.1f));
                if (accuracy.floatValue() != 0.0f) {
                    this.setOffsetXAccuracy(accuracy.floatValue());
                }
                return true;
            }
            case "scrollable": {
                boolean scrollable = WXUtils.getBoolean(param, true);
                this.setScrollable(scrollable);
                return true;
            }
            case "keepIndex": {
                this.keepIndex = WXUtils.getBoolean(param, false);
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @Deprecated
    @WXComponentProp(name="value")
    public void setValue(String value) {
        int i;
        if (value == null || this.getHostView() == null) {
            return;
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            WXLogUtils.e("", e);
            return;
        }
        this.setIndex(i);
    }

    @WXComponentProp(name="autoPlay")
    public void setAutoPlay(String autoPlay) {
        if (TextUtils.isEmpty((CharSequence)autoPlay) || autoPlay.equals("false")) {
            this.mViewPager.stopAutoScroll();
        } else {
            this.mViewPager.stopAutoScroll();
            this.mViewPager.startAutoScroll();
        }
    }

    @WXComponentProp(name="vertical")
    public void setVertical(boolean vertical) {
        if (this.mViewPager != null) {
            this.mViewPager.setVertical(vertical);
        }
    }

    @WXComponentProp(name="showIndicators")
    public void setShowIndicators(String show) {
        this.mShowIndicators = !TextUtils.isEmpty((CharSequence)show) && !show.equals("false");
        if (this.mIndicator == null) {
            return;
        }
        this.mIndicator.setShowIndicators(this.mShowIndicators);
    }

    @WXComponentProp(name="interval")
    public void setInterval(int intervalMS) {
        if (this.mViewPager != null && intervalMS > 0) {
            this.mViewPager.setIntervalTime(intervalMS);
        }
    }

    @WXComponentProp(name="index")
    public void setIndex(int index) {
        if (this.mViewPager != null && this.mAdapter != null) {
            if (index >= this.mAdapter.getRealCount() || index < 0) {
                this.initIndex = index;
                return;
            }
            index = this.getRealIndex(index);
            if (this.mAdapter.getRealCount() == 3 && index == 2 && this.mViewPager.getCurrentItem() == 0) {
                this.mViewPager.setCurrentItem(1, false);
            }
            this.mViewPager.setCurrentItem(index);
            if (this.mIndicator != null && this.mIndicator.getHostView() != null && ((WXCircleIndicator)this.mIndicator.getHostView()).getRealCurrentItem() != index) {
                WXLogUtils.d("setIndex >>>> correction indicator to " + index);
                ((WXCircleIndicator)this.mIndicator.getHostView()).setRealCurrentItem(index);
                ((WXCircleIndicator)this.mIndicator.getHostView()).invalidate();
                if (this.mPageChangeListener != null && this.mAdapter != null) {
                    this.mPageChangeListener.onPageSelected(this.mAdapter.getFirst() + index);
                }
            }
        }
    }

    @WXComponentProp(name="scrollable")
    public void setScrollable(boolean scrollable) {
        if (this.mViewPager != null && this.mAdapter != null) {
            this.mViewPager.setScrollable(scrollable);
        }
    }

    @WXComponentProp(name="offsetXAccuracy")
    public void setOffsetXAccuracy(float accuracy) {
        this.offsetXAccuracy = accuracy;
    }

    private void hackTwoItemsInfiniteScroll() {
        if (this.mViewPager == null || this.mAdapter == null) {
            return;
        }
        if (this.isInfinite) {
            if (this.mAdapter.getRealCount() == 2) {
                final GestureDetector gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new FlingGestureListener(this.mViewPager));
                this.mViewPager.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View v, MotionEvent event) {
                        return gestureDetector.onTouchEvent(event);
                    }
                });
            } else {
                this.mViewPager.setOnTouchListener(null);
            }
        }
    }

    private static class FlingGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private static final int SWIPE_MIN_DISTANCE = WXViewUtils.dip2px(50.0f);
        private static final int SWIPE_MAX_OFF_PATH = WXViewUtils.dip2px(250.0f);
        private static final int SWIPE_THRESHOLD_VELOCITY = WXViewUtils.dip2px(200.0f);
        private WeakReference<WXCircleViewPager> pagerRef;

        FlingGestureListener(WXCircleViewPager pager) {
            this.pagerRef = new WeakReference<WXCircleViewPager>(pager);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            WXCircleViewPager mViewPager = (WXCircleViewPager)this.pagerRef.get();
            if (mViewPager == null) {
                return false;
            }
            try {
                if (Math.abs(e1.getY() - e2.getY()) > (float)SWIPE_MAX_OFF_PATH) {
                    return false;
                }
                if (e1.getX() - e2.getX() > (float)SWIPE_MIN_DISTANCE && Math.abs(velocityX) > (float)SWIPE_THRESHOLD_VELOCITY && mViewPager.superGetCurrentItem() == 1) {
                    mViewPager.setCurrentItem(0, false);
                    return true;
                }
                if (e2.getX() - e1.getX() > (float)SWIPE_MIN_DISTANCE && Math.abs(velocityX) > (float)SWIPE_THRESHOLD_VELOCITY && mViewPager.superGetCurrentItem() == 0) {
                    mViewPager.setCurrentItem(1, false);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    protected static class SliderOnScrollListener
    implements ViewPager.OnPageChangeListener {
        private float lastPositionOffset = 99.0f;
        private int selectedPosition;
        private DCWXSlider target;
        private int scrollState = 0;
        private int preScrollstate = 0;
        private boolean pageSelected = false;
        private float lastValue = 0.0f;

        public SliderOnScrollListener(DCWXSlider target) {
            this.target = target;
            this.selectedPosition = target.mViewPager.superGetCurrentItem();
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (this.lastPositionOffset == 99.0f) {
                this.lastPositionOffset = positionOffset;
                this.lastValue = positionOffset;
                return;
            }
            float positionO = positionOffset;
            float offset = positionOffset - this.lastPositionOffset;
            if (offset == 0.0f) {
                this.lastPositionOffset = positionOffset;
                return;
            }
            if (this.scrollState == 1) {
                this.pageSelected = false;
                if (positionO == 0.0f) {
                    return;
                }
                if (position == this.target.mViewPager.superGetCurrentItem()) {
                    positionO = Math.abs(positionO);
                } else if (position < this.target.mViewPager.superGetCurrentItem()) {
                    positionO = -Math.abs(positionO);
                }
            } else if (this.scrollState == 2 || this.scrollState == 0) {
                positionO = positionO == 0.0f ? (float)((double)Math.abs(offset) > 0.9 ? (this.pageSelected ? 1 : 0) : (this.pageSelected ? -1 : 0)) : (float)(offset > 0.0f ? (this.pageSelected ? 1 : -1) : (this.pageSelected ? -1 : 1)) * Math.abs(positionO);
                if (this.preScrollstate == 2 && this.scrollState == 2 && (positionO > 0.0f && this.lastValue < 0.0f || positionO < 0.0f && this.lastValue > 0.0f)) {
                    positionO = -positionO;
                }
            }
            if (positionO < 0.0f && positionO > -1.0f) {
                positionO = -(1.0f + positionO);
            }
            if (this.preScrollstate == 2 && this.scrollState == 1) {
                this.target.mViewPager.getmScroller().forceFinished(true);
                this.target.fireEvent("scrollend");
            }
            this.preScrollstate = this.scrollState;
            this.lastValue = positionO;
            if (this.target.mViewPager.isVertical()) {
                HashMap<String, Object> event = new HashMap<String, Object>(1);
                event.put("offsetYRatio", Float.valueOf(-positionO));
                event.put("drag", this.target.mViewPager.getPointCounr() > 0);
                this.target.fireEvent("scroll", event);
                this.lastPositionOffset = positionOffset;
            } else {
                HashMap<String, Object> event = new HashMap<String, Object>(1);
                event.put("offsetXRatio", Float.valueOf(-positionO));
                event.put("drag", this.target.mViewPager.getPointCounr() > 0);
                this.target.fireEvent("scroll", event);
                this.lastPositionOffset = positionOffset;
            }
        }

        public void onPageSelected(int position) {
            this.pageSelected = true;
            this.selectedPosition = position;
        }

        public void onPageScrollStateChanged(int state) {
            this.scrollState = state;
            switch (state) {
                case 0: {
                    this.lastPositionOffset = 99.0f;
                    this.lastValue = 99.0f;
                    if (this.preScrollstate != 2) {
                        return;
                    }
                    this.preScrollstate = 0;
                    this.target.isDrag = false;
                    this.target.fireEvent("scrollend");
                    break;
                }
                case 1: {
                    this.target.isDrag = true;
                    this.target.fireEvent("scrollstart");
                    break;
                }
            }
        }
    }

    protected class SliderPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private int lastPos = -1;

        protected SliderPageChangeListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int pos) {
            if (DCWXSlider.this.mAdapter.getRealPosition(pos) == this.lastPos) {
                return;
            }
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("onPageSelected >>>>" + DCWXSlider.this.mAdapter.getRealPosition(pos) + " lastPos: " + this.lastPos);
            }
            if (DCWXSlider.this.mAdapter == null || DCWXSlider.this.mAdapter.getRealCount() == 0) {
                return;
            }
            int realPosition = DCWXSlider.this.mAdapter.getRealPosition(pos);
            if (DCWXSlider.this.mChildren == null || realPosition >= DCWXSlider.this.mChildren.size()) {
                return;
            }
            if (DCWXSlider.this.getEvents().size() == 0) {
                return;
            }
            WXEvent event = DCWXSlider.this.getEvents();
            String ref = DCWXSlider.this.getRef();
            if (event.contains("change") && WXViewUtils.onScreenArea(DCWXSlider.this.getHostView())) {
                DCWXSlider.this.params.put(DCWXSlider.INDEX, realPosition);
                DCWXSlider.this.params.put(DCWXSlider.SOURCE, DCWXSlider.this.isDrag ? "touch" : "autoplay");
                HashMap<String, Object> domChanges = new HashMap<String, Object>();
                HashMap<String, Object> attrsChanges = new HashMap<String, Object>();
                attrsChanges.put(DCWXSlider.INDEX, realPosition);
                attrsChanges.put(DCWXSlider.SOURCE, DCWXSlider.this.isDrag ? "touch" : "autoplay");
                domChanges.put("attrs", attrsChanges);
                DCWXSlider.this.getAttrs().putAll((Map<? extends String, ?>)attrsChanges);
                WXSDKManager.getInstance().fireEvent(DCWXSlider.this.getInstanceId(), ref, "change", DCWXSlider.this.params, domChanges);
            }
            DCWXSlider.this.mViewPager.requestLayout();
            ((FrameLayout)DCWXSlider.this.getHostView()).invalidate();
            this.lastPos = DCWXSlider.this.mAdapter.getRealPosition(pos);
        }

        public void onPageScrollStateChanged(int arg0) {
            FrameLayout root = (FrameLayout)DCWXSlider.this.getHostView();
            if (null != root) {
                root.invalidate();
            }
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new DCWXSlider(instance, parent, basicComponentData);
        }
    }
}

