/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.earmonitor;

import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.util.Log;
import cn.rongcloud.rtc.api.RCRTCAudioRouteManager;
import cn.rongcloud.rtc.earmonitor.EarMonitor;
import cn.rongcloud.rtc.earmonitor.SilentPlayer;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import com.huawei.multimedia.audiokit.interfaces.EnhancedDeviceInfo;
import com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit;
import com.huawei.multimedia.audiokit.interfaces.HwAudioKit;
import com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback;
import com.huawei.multimedia.audiokit.interfaces.UnsupportedVersionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class HuaweiEarMonitor
implements EarMonitor {
    private static final String TAG = "HWEarMonitor";
    private HwAudioKit audioKit;
    private HwAudioKaraokeFeatureKit feature;
    private SilentPlayer silentPlayer;
    private Context context;
    private boolean enabled = false;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public synchronized void init(Context context) {
        if (this.audioKit != null) {
            Log.d((String)TAG, (String)"Already initialized.");
            return;
        }
        this.context = context;
        this.silentPlayer = new SilentPlayer();
        this.audioKit = new HwAudioKit(context, new IAudioKitCallback(){

            public void onResult(int code) {
                HwAudioKit audioKit = HuaweiEarMonitor.this.audioKit;
                if (audioKit == null) {
                    Log.e((String)HuaweiEarMonitor.TAG, (String)"init: feature is null.");
                    return;
                }
                if (code == 0) {
                    Log.d((String)HuaweiEarMonitor.TAG, (String)"init: AUDIO_KIT_SUCCESS");
                    HuaweiEarMonitor.this.feature = (HwAudioKaraokeFeatureKit)audioKit.createFeature(HwAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
                } else if (code == 1000) {
                    HuaweiEarMonitor.this.feature.setParameter(HwAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_VOLUME_BASE, 100);
                    Log.d((String)HuaweiEarMonitor.TAG, (String)"init: KARAOKE_SUCCESS");
                } else {
                    Log.d((String)HuaweiEarMonitor.TAG, (String)("init: FAILED " + code));
                }
            }
        });
        this.audioKit.initialize();
    }

    @Override
    public int enable() {
        if (this.feature == null || this.enabled) {
            Log.e((String)TAG, (String)"enable: feature is null.");
            return -1;
        }
        if (!this.feature.isKaraokeFeatureSupport()) {
            Log.e((String)TAG, (String)"enable: not support.");
            return -1;
        }
        AudioManager am = (AudioManager)this.context.getSystemService("audio");
        am.setMode(0);
        if (this.feature.enableKaraokeFeature(true) != 0) {
            Log.e((String)TAG, (String)"enable: failed.");
            try {
                RCRTCAudioRouteManager.getInstance().resetAudioRouteState();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"enable: AudioRouteManager not init");
            }
            return -1;
        }
        RTCEngineImpl.getInstance().addAudioSource(RTCEngineImpl.EAudioSource.HUAWEIEAR, 1);
        this.enabled = true;
        this.silentPlayer.play();
        return 0;
    }

    @Override
    public void disable() {
        if (this.enabled) {
            this.enabled = false;
            RTCEngineImpl.getInstance().removeAudioSource(RTCEngineImpl.EAudioSource.HUAWEIEAR);
            this.silentPlayer.stop();
            if (this.feature != null) {
                this.feature.enableKaraokeFeature(false);
                this.silentPlayer.stop();
            }
        }
    }

    @Override
    public boolean isSupported() {
        return this.feature != null && this.feature.isKaraokeFeatureSupport();
    }

    @Override
    public synchronized void destroy() {
        this.disable();
        if (this.feature != null) {
            this.feature.destroy();
            this.feature = null;
        }
        if (this.audioKit != null) {
            this.audioKit.destroy();
            this.audioKit = null;
        }
        this.silentPlayer = null;
    }

    @Override
    public void adjustVolume(int volume) {
        if (this.feature != null) {
            this.feature.setParameter(HwAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_VOLUME_BASE, volume);
        }
    }

    @Override
    public void reclaim() {
        this.disable();
    }

    public String toString() {
        return "HuaweiEarMonitor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isKaraokeSupport(Context context) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicInteger initResult = new AtomicInteger(-1);
        HwAudioKit hwAudioKit = new HwAudioKit(context, new IAudioKitCallback(){

            public void onResult(int i) {
                initResult.set(i);
                countDownLatch.countDown();
            }
        });
        hwAudioKit.initialize();
        try {
            countDownLatch.await(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            hwAudioKit.destroy();
            return false;
        }
        if (initResult.get() != 0) {
            return false;
        }
        try {
            int[] outputDeviceTypes = HuaweiEarMonitor.getCurrentAudioOutputDeviceTypes(context);
            if (outputDeviceTypes == null) {
                boolean bl = false;
                return bl;
            }
            for (int outputDeviceType : outputDeviceTypes) {
                EnhancedDeviceInfo deviceInfo = hwAudioKit.getEnhancedDeviceInfo(outputDeviceType);
                if (deviceInfo == null || !deviceInfo.isKaraokeSupported()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (UnsupportedVersionException e) {
            e.printStackTrace();
        }
        finally {
            hwAudioKit.destroy();
        }
        return false;
    }

    public static int[] getCurrentAudioOutputDeviceTypes(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null && Build.VERSION.SDK_INT >= 23) {
            AudioDeviceInfo[] devices = audioManager.getDevices(2);
            int[] deviceTypes = new int[devices.length];
            for (int i = 0; i < devices.length; ++i) {
                deviceTypes[i] = devices[i].getType();
            }
            return deviceTypes;
        }
        return null;
    }
}

