/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.os.Process;
import cn.rongcloud.rtc.core.CalledByNative;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.core.audio.EAudioInput;
import cn.rongcloud.rtc.core.audio.IAudioInput;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.core.audio.RongRtcAudioUtils;
import cn.rongcloud.rtc.core.rongRTC.DevicesUtils;
import cn.rongcloud.rtc.plugin.VoiceBeautifierPlugin;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.nio.ByteBuffer;

public class CustomAudioRecord
implements IAudioInput {
    private static final String TAG = "CustomAudioRecordExternal";
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    public static final int DEFAULT_AUDIO_FORMAT = 2;
    private final Context context;
    private final AudioManager audioManager;
    private final int audioSource;
    private final int audioFormat;
    private int mSampleRate;
    private int mChannelCount;
    OnAudioBufferAvailableListener mPreListener;
    OnAudioBufferAvailableListener mPostListener;
    private long nativeAudioRecord;
    private ByteBuffer byteBuffer;
    private AudioRecordProxy audioRecord;
    private AudioRecordThread audioThread;
    private volatile boolean microphoneMute;
    private byte[] emptyBytes;

    @CalledByNative
    public void onPcmProcessed(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
        if (null != this.mPostListener) {
            this.mPostListener.onAudioBuffer(byteBuffer, sizeInBytes, sampleRate, channelCount, audioFormat);
        }
    }

    @CalledByNative
    CustomAudioRecord(Context context, AudioManager audioManager, AudioRecordProxy aRecordProxy) {
        this(null, null, context, audioManager, aRecordProxy, DevicesUtils.getAudioSource(), 2);
    }

    public CustomAudioRecord(OnAudioBufferAvailableListener preListener, OnAudioBufferAvailableListener postListener, Context context, AudioManager audioManager, AudioRecordProxy aRecordProxy, int audioSource, int audioFormat) {
        this.context = context;
        this.audioManager = audioManager;
        this.audioRecord = aRecordProxy;
        this.audioSource = audioSource;
        this.audioFormat = audioFormat;
        this.mPreListener = preListener;
        this.mPostListener = postListener;
    }

    @Override
    public void setVoiceBeautifier(VoiceBeautifierPlugin beautifier) {
        if (this.audioRecord != null) {
            this.audioRecord.setVoiceBeautifier(beautifier);
        }
    }

    @Override
    public void setEcho(boolean enable) {
    }

    @CalledByNative
    public void setNativeAudioRecord(long nativeAudioRecord) {
        this.nativeAudioRecord = nativeAudioRecord;
    }

    @CalledByNative
    boolean isAcousticEchoCancelerSupported() {
        return false;
    }

    @CalledByNative
    boolean isNoiseSuppressorSupported() {
        return false;
    }

    @CalledByNative
    private boolean enableBuiltInAEC(boolean enable) {
        Logging.d(TAG, "enableBuiltInAEC(" + enable + ")");
        return false;
    }

    @CalledByNative
    private boolean enableBuiltInNS(boolean enable) {
        Logging.d(TAG, "enableBuiltInNS(" + enable + ")");
        return false;
    }

    @CalledByNative
    private int initRecording(int sampleRate, int channels) {
        if (this.audioRecord == null) {
            ReportUtil.libError(ReportUtil.TAG.AUDIOINPUTSTATUS, "type|status|desc", "audiorecord", "initRecording", "AudioRecord is NULL when init.");
            return -1;
        }
        if (this.audioRecord.isInitialized()) {
            ReportUtil.libError(ReportUtil.TAG.AUDIOINPUTSTATUS, "type|status|desc", "audiorecord", "initRecording", "AudioRecord already initialized.");
            return -1;
        }
        int bytesPerFrame = channels * CustomAudioRecord.getBytesPerSample(this.audioFormat);
        int framesPerBuffer = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
        if (!this.byteBuffer.hasArray()) {
            ReportUtil.libError(ReportUtil.TAG.AUDIOINPUTSTATUS, "type|status|desc", "audiorecord", "initRecording", "!(byteBuffer.hasArray())");
            return -1;
        }
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.nativeAudioRecord, this.byteBuffer);
        int channelConfig = this.channelCountToConfiguration(channels);
        int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)this.audioFormat);
        if (minBufferSize == -1 || minBufferSize == -2) {
            ReportUtil.libError(ReportUtil.TAG.AUDIOINPUTSTATUS, "type|status|desc", "audiorecord", "initRecording", "minBufferSize != SUCCESS");
            return -1;
        }
        int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
        Logging.d(TAG, "bufferSizeInBytes: " + bufferSizeInBytes);
        this.mSampleRate = sampleRate;
        this.mChannelCount = channels;
        try {
            this.audioRecord.init(this.audioSource, sampleRate, channelConfig, this.audioFormat, bufferSizeInBytes);
        }
        catch (IllegalArgumentException e) {
            ReportUtil.libError(ReportUtil.TAG.AUDIOINPUTSTATUS, "type|status|desc", "audiorecord", "initRecording", e);
            this.releaseAudioResources();
            return -1;
        }
        if (!this.audioRecord.isInitialized()) {
            this.releaseAudioResources();
            ReportUtil.libError(ReportUtil.TAG.AUDIOINPUTSTATUS, "type|status|desc", "audiorecord", "initRecording", "!audioRecord.isInitialized()");
            return -1;
        }
        ReportUtil.libStatus(ReportUtil.TAG.AUDIOINPUTSTATUS, "type|status|sampleRate|channels", "audiorecord", "initRecording", sampleRate, channels);
        return framesPerBuffer;
    }

    @CalledByNative
    private boolean startRecording() {
        Logging.d(TAG, "startRecording");
        ReportUtil.libStatus(ReportUtil.TAG.AUDIOINPUTSTATUS, "type|status", "audiorecord", "startRecording");
        try {
            this.audioRecord.start();
        }
        catch (IllegalStateException e) {
            return false;
        }
        if (!this.audioRecord.isRecording()) {
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    @CalledByNative
    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        this.audioThread.stopThread();
        Logging.d(TAG, "stopRecording over");
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
            RongRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        }
        this.audioThread = null;
        this.releaseAudioResources();
        ReportUtil.libStatus(ReportUtil.TAG.AUDIOINPUTSTATUS, "type|status", "audiorecord", "stopRecording");
        return true;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(long var1, ByteBuffer var3);

    private native void nativeDataIsRecorded(long var1, int var3);

    private native void nativeDataIsRecordedWithCallBack(long var1, int var3);

    private static native long nativeCreateNativeObject(long var0);

    @Override
    public EAudioInput getType() {
        return EAudioInput.AUDIORECORD;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public long createNativeObject(long builder) {
        return CustomAudioRecord.nativeCreateNativeObject(builder);
    }

    @Override
    public void setMicrophoneMute(boolean mute) {
        Logging.w(TAG, "setMicrophoneMute(" + mute + ")");
        if (null == this.audioRecord) {
            return;
        }
        this.microphoneMute = mute;
        if (mute) {
            this.audioRecord.stop();
        } else {
            this.audioRecord.start();
        }
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        this.audioRecord.release();
    }

    private static int getBytesPerSample(int audioFormat) {
        switch (audioFormat) {
            case 3: {
                return 1;
            }
            case 1: 
            case 2: 
            case 13: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Bad audio format " + audioFormat);
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(CustomAudioRecord.TAG, "AudioRecordThread" + RongRtcAudioUtils.getThreadInfo());
            while (this.keepAlive) {
                int bytesRead = CustomAudioRecord.this.audioRecord.read(CustomAudioRecord.this.byteBuffer, CustomAudioRecord.this.byteBuffer.capacity());
                if (bytesRead == CustomAudioRecord.this.byteBuffer.capacity()) {
                    if (null != CustomAudioRecord.this.mPreListener) {
                        CustomAudioRecord.this.mPreListener.onAudioBuffer(CustomAudioRecord.this.byteBuffer, bytesRead, CustomAudioRecord.this.mSampleRate, CustomAudioRecord.this.mChannelCount, CustomAudioRecord.this.audioFormat);
                    }
                    if (!this.keepAlive) continue;
                    CustomAudioRecord.this.nativeDataIsRecorded(CustomAudioRecord.this.nativeAudioRecord, bytesRead);
                    continue;
                }
                String errorMessage = "audioRecord.read failed: " + bytesRead;
                Logging.e(CustomAudioRecord.TAG, errorMessage);
            }
            try {
                if (CustomAudioRecord.this.audioRecord != null) {
                    CustomAudioRecord.this.audioRecord.stop();
                }
            }
            catch (IllegalStateException e) {
                Logging.e(CustomAudioRecord.TAG, "audioRecord.stop failed: " + e.getMessage());
            }
        }

        public void stopThread() {
            Logging.d(CustomAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface AudioRecordProxy {
        public void init(int var1, int var2, int var3, int var4, int var5);

        public void setVoiceBeautifier(VoiceBeautifierPlugin var1);

        public int read(ByteBuffer var1, int var2);

        public void start();

        public void stop();

        public void release();

        public boolean isInitialized();

        public boolean isRecording();
    }
}

