/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.tools.multiroom;

import android.text.TextUtils;
import cn.rongcloud.rtc.engine.tools.multiroom.AbstractMultipleRoom;
import cn.rongcloud.rtc.proxy.message.InviteMessage;
import cn.rongcloud.rtc.utils.FinLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InviteNotifyMessageElement
extends AbstractMultipleRoom {
    public static final String TAG = "InviteNotifyMessageElement";
    private Map<String, InviteMessage> concurrentHashMap = new ConcurrentHashMap<String, InviteMessage>(16);

    public void put(String inviterUserId, InviteMessage message) {
        if (message == null) {
            FinLog.e(TAG, "InviteNotifyMessageElement. InviteMessage is empty.");
            return;
        }
        FinLog.d(TAG, "InviteNotifyMessageElement.put inviterUserId : " + inviterUserId);
        this.concurrentHashMap.put(inviterUserId, message);
    }

    public InviteMessage remove(String inviterUserId) {
        FinLog.d(TAG, "InviteNotifyMessageElement.remove inviterUserId : " + inviterUserId);
        return this.concurrentHashMap.remove(inviterUserId);
    }

    public void remove(String inviterUserId, String inviteSessionId) {
        InviteMessage inviteMessage = this.concurrentHashMap.get(inviterUserId);
        if (inviteMessage != null && !TextUtils.isEmpty((CharSequence)inviteMessage.getInviteSessionId()) && TextUtils.equals((CharSequence)inviteMessage.getInviteSessionId(), (CharSequence)inviteSessionId)) {
            FinLog.d(TAG, "InviteNotifyMessageElement.remove inviterUserId : " + inviterUserId + " , inviteSessionId :" + inviteSessionId);
            this.concurrentHashMap.remove(inviterUserId);
        }
    }

    public InviteMessage get(String inviterUserId) {
        return this.concurrentHashMap.get(inviterUserId);
    }

    @Override
    public void release() {
        super.release();
        if (this.concurrentHashMap != null) {
            this.concurrentHashMap.clear();
        }
    }
}

