/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.utils;

import android.content.Context;
import android.content.Intent;
import com.heytap.mcssdk.PushService;
import com.heytap.mcssdk.utils.LogUtil;
import com.heytap.mcssdk.utils.Utils;
import com.heytap.msp.push.mode.MessageStat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class StatUtil {
    private static final String TYPE = "type";
    private static final String COUNT = "count";
    private static final String STAT_LIST = "list";
    private static final int MCS_SUPPORT_VERSION = 1017;

    public static void statisticMessage(Context context, MessageStat message) {
        LinkedList<MessageStat> list = new LinkedList<MessageStat>();
        list.add(message);
        StatUtil.statisticMessage(context, list);
    }

    public static boolean statisticMessage(Context context, List<MessageStat> messages) {
        LinkedList<MessageStat> list = new LinkedList<MessageStat>();
        list.addAll(messages);
        LogUtil.d("isSupportStatisticByMcs:" + StatUtil.isSupportStatisticByMcs(context) + ",list size:" + list.size());
        if (list.size() > 0 && StatUtil.isSupportStatisticByMcs(context)) {
            return StatUtil.statisticMessageByMcs(context, list);
        }
        return false;
    }

    private static boolean isSupportStatisticByMcs(Context context) {
        String pkg = PushService.getInstance().getMcsPackageName(context);
        return Utils.isExistPackage(context, pkg) && Utils.getVersionCode(context, pkg) >= 1017;
    }

    private static boolean statisticMessageByMcs(Context context, List<MessageStat> messages) {
        int commandType = 12291;
        try {
            Intent intent = new Intent();
            intent.setAction(PushService.getInstance().getReceiveSdkAction(context));
            intent.setPackage(PushService.getInstance().getMcsPackageName(context));
            intent.putExtra("appPackage", context.getPackageName());
            intent.putExtra(TYPE, commandType);
            intent.putExtra(COUNT, messages.size());
            ArrayList<String> list = new ArrayList<String>();
            for (MessageStat message : messages) {
                list.add(message.toJsonObject());
            }
            intent.putStringArrayListExtra(STAT_LIST, list);
            context.startService(intent);
            return true;
        }
        catch (Exception e) {
            LogUtil.e("statisticMessage--Exception" + e.getMessage());
            return false;
        }
    }
}

