/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.msp.push.notification;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Person;
import android.content.Context;
import android.content.LocusId;
import android.graphics.Bitmap;
import android.graphics.drawable.Icon;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.RequiresApi;
import android.widget.RemoteViews;

public class PushNotification {

    public static class Builder
    extends Notification.Builder {
        private int autoDelete;
        private int importantLevel;
        private String messageId;
        private String statisticData;
        private Icon icon;
        private int iconRes;
        private int iconLevel;

        @RequiresApi(api=26)
        public Builder(Context context, String channelId) {
            super(context, channelId);
        }

        public Builder(Context context) {
            super(context);
        }

        public Builder addExtraAutoDelete(int autoDelete) {
            this.autoDelete = autoDelete;
            return this;
        }

        public Builder addExtraImportanceLevel(int importantLevel) {
            this.importantLevel = importantLevel;
            return this;
        }

        public Builder addExtraMessageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder addExtraStatisticData(String statisticData) {
            this.statisticData = statisticData;
            return this;
        }

        public int getAutoDelete() {
            return this.autoDelete;
        }

        public int getImportantLevel() {
            return this.importantLevel;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public String getStatisticData() {
            return this.statisticData;
        }

        public Builder setShortcutId(String shortcutId) {
            super.setShortcutId(shortcutId);
            return this;
        }

        public Builder setLocusId(LocusId locusId) {
            super.setLocusId(locusId);
            return this;
        }

        public Builder setBadgeIconType(int icon) {
            super.setBadgeIconType(icon);
            return this;
        }

        public Builder setGroupAlertBehavior(int groupAlertBehavior) {
            super.setGroupAlertBehavior(groupAlertBehavior);
            return this;
        }

        public Builder setBubbleMetadata(Notification.BubbleMetadata data) {
            super.setBubbleMetadata(data);
            return this;
        }

        public Builder setChannelId(String channelId) {
            super.setChannelId(channelId);
            return this;
        }

        public Builder setTimeoutAfter(long durationMs) {
            super.setTimeoutAfter(durationMs);
            return this;
        }

        public Builder setWhen(long when) {
            super.setWhen(when);
            return this;
        }

        public Builder setShowWhen(boolean show) {
            super.setShowWhen(show);
            return this;
        }

        public Builder setUsesChronometer(boolean b) {
            super.setUsesChronometer(b);
            return this;
        }

        public Builder setChronometerCountDown(boolean countDown) {
            super.setChronometerCountDown(countDown);
            return this;
        }

        public Builder setSmallIcon(@DrawableRes int icon) {
            super.setSmallIcon(icon);
            this.iconRes = icon;
            return this;
        }

        public Builder setSmallIcon(@DrawableRes int icon, int level) {
            super.setSmallIcon(icon, level);
            this.iconRes = icon;
            this.iconLevel = level;
            return this;
        }

        public Builder setSmallIcon(Icon icon) {
            super.setSmallIcon(icon);
            this.icon = icon;
            return this;
        }

        public int getIconRes() {
            return this.iconRes;
        }

        public int getIconLevel() {
            return this.iconLevel;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public Builder setContentTitle(CharSequence title) {
            super.setContentTitle(title);
            return this;
        }

        public Builder setContentText(CharSequence text) {
            super.setContentText(text);
            return this;
        }

        public Builder setSubText(CharSequence text) {
            super.setSubText(text);
            return this;
        }

        public Builder setSettingsText(CharSequence text) {
            super.setSettingsText(text);
            return this;
        }

        public Builder setRemoteInputHistory(CharSequence[] text) {
            super.setRemoteInputHistory(text);
            return this;
        }

        public Builder setNumber(int number) {
            super.setNumber(number);
            return this;
        }

        @Deprecated
        public Builder setContentInfo(CharSequence info) {
            super.setContentInfo(info);
            return this;
        }

        public Builder setProgress(int max, int progress, boolean indeterminate) {
            super.setProgress(max, progress, indeterminate);
            return this;
        }

        public Builder setCustomContentView(RemoteViews views) {
            super.setCustomContentView(views);
            return this;
        }

        public Builder setCustomBigContentView(RemoteViews contentView) {
            super.setCustomBigContentView(contentView);
            return this;
        }

        public Builder setCustomHeadsUpContentView(RemoteViews contentView) {
            super.setCustomHeadsUpContentView(contentView);
            return this;
        }

        public Builder setContentIntent(PendingIntent intent) {
            super.setContentIntent(intent);
            return this;
        }

        public Builder setDeleteIntent(PendingIntent intent) {
            super.setDeleteIntent(intent);
            return this;
        }

        public Builder setFullScreenIntent(PendingIntent intent, boolean highPriority) {
            super.setFullScreenIntent(intent, highPriority);
            return this;
        }

        public Builder setTicker(CharSequence tickerText) {
            super.setTicker(tickerText);
            return this;
        }

        public Builder setLargeIcon(Bitmap b) {
            super.setLargeIcon(b);
            return this;
        }

        public Builder setLargeIcon(Icon icon) {
            super.setLargeIcon(icon);
            return this;
        }

        @Deprecated
        public Builder setSound(Uri sound) {
            super.setSound(sound);
            return this;
        }

        @Deprecated
        public Builder setSound(Uri sound, int streamType) {
            super.setSound(sound, streamType);
            return this;
        }

        @Deprecated
        public Builder setSound(Uri sound, AudioAttributes audioAttributes) {
            super.setSound(sound, audioAttributes);
            return this;
        }

        @Deprecated
        public Builder setVibrate(long[] pattern) {
            super.setVibrate(pattern);
            return this;
        }

        @Deprecated
        public Builder setLights(@ColorInt int argb, int onMs, int offMs) {
            super.setLights(argb, onMs, offMs);
            return this;
        }

        public Builder setOngoing(boolean ongoing) {
            super.setOngoing(ongoing);
            return this;
        }

        public Builder setColorized(boolean colorize) {
            super.setColorized(colorize);
            return this;
        }

        public Builder setOnlyAlertOnce(boolean onlyAlertOnce) {
            super.setOnlyAlertOnce(onlyAlertOnce);
            return this;
        }

        public Builder setAutoCancel(boolean autoCancel) {
            super.setAutoCancel(autoCancel);
            return this;
        }

        public Builder setLocalOnly(boolean localOnly) {
            super.setLocalOnly(localOnly);
            return this;
        }

        @Deprecated
        public Builder setDefaults(int defaults) {
            super.setDefaults(defaults);
            return this;
        }

        @Deprecated
        public Builder setPriority(int pri) {
            super.setPriority(pri);
            return this;
        }

        public Builder setCategory(String category) {
            super.setCategory(category);
            return this;
        }

        public Builder addPerson(String uri) {
            super.addPerson(uri);
            return this;
        }

        public Builder addPerson(Person person) {
            super.addPerson(person);
            return this;
        }

        public Builder setGroup(String groupKey) {
            super.setGroup(groupKey);
            return this;
        }

        public Builder setGroupSummary(boolean isGroupSummary) {
            super.setGroupSummary(isGroupSummary);
            return this;
        }

        public Builder setSortKey(String sortKey) {
            super.setSortKey(sortKey);
            return this;
        }

        public Builder addExtras(Bundle extras) {
            super.addExtras(extras);
            return this;
        }

        public Builder setExtras(Bundle extras) {
            super.setExtras(extras);
            return this;
        }

        @Deprecated
        public Builder addAction(int icon, CharSequence title, PendingIntent intent) {
            super.addAction(icon, title, intent);
            return this;
        }

        public Builder addAction(Notification.Action action) {
            super.addAction(action);
            return this;
        }

        public Builder setActions(Notification.Action ... actions) {
            super.setActions(actions);
            return this;
        }

        public Builder setStyle(Notification.Style style) {
            super.setStyle(style);
            return this;
        }

        public Builder setVisibility(int visibility) {
            super.setVisibility(visibility);
            return this;
        }

        public Builder setPublicVersion(Notification n) {
            super.setPublicVersion(n);
            return this;
        }

        public Builder extend(Notification.Extender extender) {
            super.extend(extender);
            return this;
        }

        public Builder setColor(int argb) {
            super.setColor(argb);
            return this;
        }

        public Builder setAllowSystemGeneratedContextualActions(boolean allowed) {
            super.setAllowSystemGeneratedContextualActions(allowed);
            return this;
        }

        @Deprecated
        public Builder setContent(RemoteViews views) {
            super.setContent(views);
            return this;
        }

        @Deprecated
        public Builder setTicker(CharSequence tickerText, RemoteViews views) {
            super.setTicker(tickerText, views);
            return this;
        }
    }
}

