/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.composer;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.daasuu.mp4compose.SampleType;
import com.daasuu.mp4compose.composer.IAudioComposer;
import com.daasuu.mp4compose.composer.MuxRender;
import com.daasuu.mp4compose.logger.Logger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;

class AudioComposer
implements IAudioComposer {
    private static final String TAG = "AudioComposer";
    private final MediaExtractor mediaExtractor;
    private final int trackIndex;
    private final MuxRender muxRender;
    private final SampleType sampleType = SampleType.AUDIO;
    private final MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
    private int bufferSize;
    private ByteBuffer buffer;
    private boolean isEOS;
    private long writtenPresentationTimeUs;
    private final long trimStartUs;
    private final long trimEndUs;
    private final Logger logger;

    AudioComposer(@NonNull MediaExtractor mediaExtractor, int trackIndex, @NonNull MuxRender muxRender, long trimStartMs, long trimEndMs, @NonNull Logger logger) {
        this.mediaExtractor = mediaExtractor;
        this.trackIndex = trackIndex;
        this.muxRender = muxRender;
        this.trimStartUs = TimeUnit.MILLISECONDS.toMicros(trimStartMs);
        this.trimEndUs = trimEndMs == -1L ? trimEndMs : TimeUnit.MILLISECONDS.toMicros(trimEndMs);
        this.logger = logger;
        MediaFormat actualOutputFormat = this.mediaExtractor.getTrackFormat(this.trackIndex);
        this.muxRender.setOutputFormat(this.sampleType, actualOutputFormat);
        this.bufferSize = actualOutputFormat.containsKey("max-input-size") ? actualOutputFormat.getInteger("max-input-size") : 65536;
        this.buffer = ByteBuffer.allocateDirect(this.bufferSize).order(ByteOrder.nativeOrder());
        mediaExtractor.seekTo(this.trimStartUs, 0);
    }

    @Override
    @SuppressLint(value={"Assert"})
    public boolean stepPipeline() {
        int flags;
        if (this.isEOS) {
            return false;
        }
        int trackIndex = this.mediaExtractor.getSampleTrackIndex();
        this.logger.debug(TAG, "stepPipeline trackIndex:" + trackIndex);
        if (trackIndex < 0 || this.writtenPresentationTimeUs >= this.trimEndUs && this.trimEndUs != -1L) {
            this.buffer.clear();
            this.bufferInfo.set(0, 0, 0L, 4);
            this.muxRender.writeSampleData(this.sampleType, this.buffer, this.bufferInfo);
            this.isEOS = true;
            this.mediaExtractor.unselectTrack(this.trackIndex);
            return true;
        }
        if (trackIndex != this.trackIndex) {
            return false;
        }
        this.buffer.clear();
        int sampleSize = this.mediaExtractor.readSampleData(this.buffer, 0);
        if (sampleSize > this.bufferSize) {
            this.logger.warning(TAG, "Sample size smaller than buffer size, resizing buffer: " + sampleSize);
            this.bufferSize = 2 * sampleSize;
            this.buffer = ByteBuffer.allocateDirect(this.bufferSize).order(ByteOrder.nativeOrder());
        }
        boolean isKeyFrame = (this.mediaExtractor.getSampleFlags() & 1) != 0;
        int n = flags = isKeyFrame ? 1 : 0;
        if (this.mediaExtractor.getSampleTime() >= this.trimStartUs && (this.mediaExtractor.getSampleTime() <= this.trimEndUs || this.trimEndUs == -1L)) {
            this.bufferInfo.set(0, sampleSize, this.mediaExtractor.getSampleTime(), flags);
            this.muxRender.writeSampleData(this.sampleType, this.buffer, this.bufferInfo);
        }
        this.writtenPresentationTimeUs = this.mediaExtractor.getSampleTime();
        this.mediaExtractor.advance();
        return true;
    }

    @Override
    public long getWrittenPresentationTimeUs() {
        return this.writtenPresentationTimeUs;
    }

    @Override
    public boolean isFinished() {
        return this.isEOS;
    }

    @Override
    public void setup() {
    }

    @Override
    public void release() {
    }
}

