/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.gl;

import android.opengl.GLES20;
import com.daasuu.mp4compose.utils.EglUtil;

public class GlFramebufferObject {
    private int width;
    private int height;
    private int framebufferName;
    private int renderBufferName;
    private int texName;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTexName() {
        return this.texName;
    }

    public void setup(int width, int height) {
        int[] args = new int[1];
        GLES20.glGetIntegerv((int)3379, (int[])args, (int)0);
        if (width > args[0] || height > args[0]) {
            throw new IllegalArgumentException("GL_MAX_TEXTURE_SIZE " + args[0]);
        }
        GLES20.glGetIntegerv((int)34024, (int[])args, (int)0);
        if (width > args[0] || height > args[0]) {
            throw new IllegalArgumentException("GL_MAX_RENDERBUFFER_SIZE " + args[0]);
        }
        GLES20.glGetIntegerv((int)36006, (int[])args, (int)0);
        int saveFramebuffer = args[0];
        GLES20.glGetIntegerv((int)36007, (int[])args, (int)0);
        int saveRenderbuffer = args[0];
        GLES20.glGetIntegerv((int)32873, (int[])args, (int)0);
        int saveTexName = args[0];
        this.release();
        try {
            this.width = width;
            this.height = height;
            GLES20.glGenFramebuffers((int)args.length, (int[])args, (int)0);
            this.framebufferName = args[0];
            GLES20.glBindFramebuffer((int)36160, (int)this.framebufferName);
            GLES20.glGenRenderbuffers((int)args.length, (int[])args, (int)0);
            this.renderBufferName = args[0];
            GLES20.glBindRenderbuffer((int)36161, (int)this.renderBufferName);
            GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)width, (int)height);
            GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.renderBufferName);
            GLES20.glGenTextures((int)args.length, (int[])args, (int)0);
            this.texName = args[0];
            GLES20.glBindTexture((int)3553, (int)this.texName);
            EglUtil.setupSampler(3553, 9729, 9728);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texName, (int)0);
            int status = GLES20.glCheckFramebufferStatus((int)36160);
            if (status != 36053) {
                throw new RuntimeException("Failed to initialize framebuffer object " + status);
            }
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
        GLES20.glBindFramebuffer((int)36160, (int)saveFramebuffer);
        GLES20.glBindRenderbuffer((int)36161, (int)saveRenderbuffer);
        GLES20.glBindTexture((int)3553, (int)saveTexName);
    }

    public void release() {
        int[] args = new int[]{this.texName};
        GLES20.glDeleteTextures((int)args.length, (int[])args, (int)0);
        this.texName = 0;
        args[0] = this.renderBufferName;
        GLES20.glDeleteRenderbuffers((int)args.length, (int[])args, (int)0);
        this.renderBufferName = 0;
        args[0] = this.framebufferName;
        GLES20.glDeleteFramebuffers((int)args.length, (int[])args, (int)0);
        this.framebufferName = 0;
    }

    public void enable() {
        GLES20.glBindFramebuffer((int)36160, (int)this.framebufferName);
    }
}

