/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.media.player.api;

import android.os.Handler;
import android.os.HandlerThread;
import cn.rongcloud.rtc.api.stream.view.RCRTCBaseView;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.media.player.api.PlayerModuleUtils;
import cn.rongcloud.rtc.media.player.api.RCPlayer;
import cn.rongcloud.rtc.plugin.player.IPlayer;
import cn.rongcloud.rtc.plugin.player.IPlayerPrepareListener;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class RCPlayerEngine
implements IPlayer {
    private Handler mHandler;
    private Handler mHandler_Q;
    private RCPlayer mPlayer;
    private static final String TAG = "RCPlayerEngine";
    private AtomicInteger mCount = null;
    private int delayMillis = 1000;
    private Runnable runnable_Quality = new Runnable(){

        @Override
        public void run() {
            float tcpSpeed;
            RCPlayer player = RCPlayerEngine.this.mPlayer;
            if (player != null && (tcpSpeed = PlayerModuleUtils.formatedSpeed(player.getTcpSpeed())) != -1.0f) {
                if (tcpSpeed < 4.0f) {
                    if (RCPlayerEngine.this.mCount != null) {
                        RCPlayerEngine.this.mCount.incrementAndGet();
                        ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"tcpSpeed|count", (Object[])new Object[]{Float.valueOf(tcpSpeed), RCPlayerEngine.this.mCount.get()});
                    }
                } else if (RCPlayerEngine.this.mCount != null) {
                    RCPlayerEngine.this.mCount.set(0);
                }
                if (RCPlayerEngine.this.mCount != null && RCPlayerEngine.this.mCount.get() == 10) {
                    RTCEngineImpl.getInstance().sendMessage(5057, new Object[0]);
                    if (RCPlayerEngine.this.mCount != null) {
                        RCPlayerEngine.this.mCount.set(0);
                    }
                } else {
                    Handler handler = RCPlayerEngine.this.mHandler_Q;
                    if (handler != null) {
                        handler.postDelayed((Runnable)this, (long)RCPlayerEngine.this.delayMillis);
                    }
                }
            }
        }
    };

    public RCPlayerEngine() {
        HandlerThread handlerThread = new HandlerThread("RCPlayerThread_Work");
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                RCPlayerEngine.this.mPlayer = new RCPlayer();
            }
        });
        this.mCount = new AtomicInteger(0);
        HandlerThread handlerThread_Q = new HandlerThread("RCPlayerThread_Quality");
        handlerThread_Q.start();
        this.mHandler_Q = new Handler(handlerThread_Q.getLooper());
    }

    public void prepare(final String path, final RCRTCBaseView videoView, final int videoFps, final int startOnPrepared, final IPlayerPrepareListener prepareListener) {
        if (this.mHandler == null) {
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.prepare. handler is empty"});
            if (prepareListener != null) {
                prepareListener.onError();
            }
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RCPlayerEngine.this.mPlayer != null) {
                    RCPlayerEngine.this.mPlayer.prepare(path, videoView, videoFps, startOnPrepared, new IPlayerPrepareListener(){

                        public void onCompletion() {
                            if (RCPlayerEngine.this.mHandler_Q != null) {
                                RCPlayerEngine.this.mHandler_Q.postDelayed(RCPlayerEngine.this.runnable_Quality, (long)RCPlayerEngine.this.delayMillis);
                            }
                            if (prepareListener != null) {
                                prepareListener.onCompletion();
                            }
                        }

                        public void onError() {
                            if (prepareListener != null) {
                                prepareListener.onError();
                            }
                        }
                    });
                } else {
                    ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.prepare. player is empty"});
                    if (prepareListener != null) {
                        prepareListener.onError();
                    }
                }
            }
        });
    }

    public void switchPlaybackAddress(final String path, final int videoFps, final IPlayerPrepareListener prepareListener) {
        if (this.mHandler == null) {
            if (prepareListener != null) {
                prepareListener.onError();
            }
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.switchPlaybackAddress. handler is empty"});
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RCPlayerEngine.this.mPlayer != null) {
                    if (RCPlayerEngine.this.mHandler_Q != null) {
                        RCPlayerEngine.this.mHandler_Q.removeCallbacks(RCPlayerEngine.this.runnable_Quality);
                    }
                    RCPlayerEngine.this.mPlayer.switchPlaybackAddress(path, videoFps, new IPlayerPrepareListener(){

                        public void onCompletion() {
                            if (prepareListener != null) {
                                prepareListener.onCompletion();
                            }
                            if (RCPlayerEngine.this.mHandler_Q != null) {
                                RCPlayerEngine.this.mHandler_Q.postDelayed(RCPlayerEngine.this.runnable_Quality, (long)RCPlayerEngine.this.delayMillis);
                            }
                        }

                        public void onError() {
                            if (prepareListener != null) {
                                prepareListener.onError();
                            }
                        }
                    });
                } else {
                    ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.switchPlaybackAddress. player is empty"});
                    if (prepareListener != null) {
                        prepareListener.onError();
                    }
                }
            }
        });
    }

    public void release() {
        if (this.mHandler == null) {
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.release. handler is empty"});
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RCPlayerEngine.this.mPlayer != null) {
                    RCPlayerEngine.this.mPlayer.release();
                } else {
                    ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.release. player is empty"});
                }
            }
        });
    }

    public void start() {
        if (this.mHandler == null) {
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.start. handler is empty"});
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RCPlayerEngine.this.mPlayer != null) {
                    RCPlayerEngine.this.mPlayer.start();
                } else {
                    ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.start. player is empty"});
                }
            }
        });
    }

    public void restore(final String newPath, final IPlayerPrepareListener prepareListener) {
        if (this.mHandler == null) {
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.restore. handler is empty"});
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RCPlayerEngine.this.mPlayer != null) {
                    RCPlayerEngine.this.mPlayer.restore(newPath, new IPlayerPrepareListener(){

                        public void onCompletion() {
                            if (prepareListener != null) {
                                prepareListener.onCompletion();
                            }
                            if (RCPlayerEngine.this.mHandler_Q != null) {
                                RCPlayerEngine.this.mHandler_Q.postDelayed(RCPlayerEngine.this.runnable_Quality, (long)RCPlayerEngine.this.delayMillis);
                            }
                        }

                        public void onError() {
                            if (prepareListener != null) {
                                prepareListener.onError();
                            }
                        }
                    });
                } else {
                    ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.restore. player is empty"});
                }
            }
        });
    }

    public void pause() {
        if (this.mHandler == null) {
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.pause. handler is empty"});
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RCPlayerEngine.this.mPlayer != null) {
                    RCPlayerEngine.this.mPlayer.pause();
                } else {
                    ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.pause. player is empty"});
                }
            }
        });
    }

    public static String getVersion() {
        return "5.2.4";
    }

    public void quitLooper() {
        if (this.mHandler == null) {
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayerEngine.release. handler is empty"});
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                RCPlayerEngine.this.mHandler.getLooper().quit();
                RCPlayerEngine.this.mHandler_Q.getLooper().quit();
            }
        });
    }
}

