/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.live;

import android.content.Context;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import java.lang.ref.WeakReference;

@JNINamespace(value="liteav::live")
public class OrientationMonitorAndroid {
    private static final String TAG = "OrientationMonitor";
    private final long mNativeOrientationMonitorAndroid;
    private a mDisplayOrientationListener;
    private final Object mLock;
    private boolean mIsReleased;

    @CalledByNative
    public OrientationMonitorAndroid(long nativeOrientationMonitorAndroid) {
        this.mNativeOrientationMonitorAndroid = nativeOrientationMonitorAndroid;
        this.mLock = new Object();
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            LiteavLog.e(TAG, "Invalid application context, init orientation monitor failed.");
            return;
        }
        this.mDisplayOrientationListener = new a(context, new WeakReference<OrientationMonitorAndroid>(this));
        this.mDisplayOrientationListener.enable();
    }

    public native void nativeSetOrientation(long var1, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public int getOrientation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDisplayOrientationListener.a.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void release() {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsReleased = true;
            this.mDisplayOrientationListener.disable();
            return;
        }
    }

    static final class a
    extends OrientationEventListener {
        private final WeakReference<OrientationMonitorAndroid> b;
        private Display c;
        b a;

        public a(Context context, WeakReference<OrientationMonitorAndroid> weakReference) {
            super(context);
            this.b = weakReference;
            try {
                this.c = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
                if (this.c == null) {
                    LiteavLog.w(OrientationMonitorAndroid.TAG, "Get display instance failed.");
                    return;
                }
                this.a = com.tencent.liteav.live.OrientationMonitorAndroid$a.a(this.c.getRotation());
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
                LiteavLog.e(OrientationMonitorAndroid.TAG, exception2.getMessage());
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onOrientationChanged(int orientation) {
            b b2;
            if (this.c != null && (b2 = com.tencent.liteav.live.OrientationMonitorAndroid$a.a(this.c.getRotation())) != this.a) {
                this.a = b2;
                OrientationMonitorAndroid orientationMonitorAndroid = this.b != null ? (OrientationMonitorAndroid)this.b.get() : null;
                if (orientationMonitorAndroid != null) {
                    Object object = orientationMonitorAndroid.mLock;
                    synchronized (object) {
                        if (orientationMonitorAndroid.mIsReleased) {
                            return;
                        }
                        OrientationMonitorAndroid orientationMonitorAndroid2 = orientationMonitorAndroid;
                        orientationMonitorAndroid2.nativeSetOrientation(orientationMonitorAndroid2.mNativeOrientationMonitorAndroid, this.a.index);
                        return;
                    }
                }
            }
        }

        private static b a(int n2) {
            switch (n2) {
                case 1: {
                    return com.tencent.liteav.live.OrientationMonitorAndroid$b.b;
                }
                case 2: {
                    return com.tencent.liteav.live.OrientationMonitorAndroid$b.c;
                }
                case 3: {
                    return com.tencent.liteav.live.OrientationMonitorAndroid$b.d;
                }
            }
            return com.tencent.liteav.live.OrientationMonitorAndroid$b.a;
        }
    }

    static enum b {
        a(0),
        b(1),
        c(2),
        d(3);

        final int index;

        private b(int n3) {
            this.index = n3;
        }
    }
}

