/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.videobase.utils.Rotation;

@JNINamespace(value="liteav::video")
public class CaptureCloudConfig {
    private Rotation frontCameraRealRotation = null;
    private Rotation backCameraRealRotation = null;
    private int camera2SupportMinApiLevel = Integer.MAX_VALUE;

    @CalledByNative
    public CaptureCloudConfig() {
    }

    @CalledByNative
    public void setCamera2SupportMinApiLevel(int value) {
        this.camera2SupportMinApiLevel = value;
    }

    public int getCamera2SupportMinApiLevel() {
        return this.camera2SupportMinApiLevel;
    }

    @CalledByNative
    public void setCameraRealRotation(int frontRotation, int backRotation) {
        this.frontCameraRealRotation = Rotation.b(frontRotation) ? Rotation.a(frontRotation) : null;
        this.backCameraRealRotation = Rotation.b(backRotation) ? Rotation.a(backRotation) : null;
    }

    public Rotation getCameraRealRotation(boolean frontCamera) {
        if (frontCamera) {
            return this.frontCameraRealRotation;
        }
        return this.backCameraRealRotation;
    }
}

