/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2.capture;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.videoproducer.capture.CameraControllerInterface;
import com.tencent.liteav.videoproducer.capture.CameraEventCallback;
import com.tencent.liteav.videoproducer2.capture.a;
import com.tencent.liteav.videoproducer2.capture.b;
import com.tencent.liteav.videoproducer2.capture.c;
import com.tencent.liteav.videoproducer2.capture.d;

@JNINamespace(value="liteav::video")
public class NativeCameraCaptureListener
implements SurfaceTexture.OnFrameAvailableListener,
CameraEventCallback {
    @NonNull
    private final CustomHandler mCallbackHandler;
    private long mNativeHandle;

    @CalledByNative
    public NativeCameraCaptureListener(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        Looper looper = Looper.myLooper();
        this.mCallbackHandler = new CustomHandler(looper);
    }

    @CalledByNative
    public synchronized void resetNativeHandle() {
        this.mNativeHandle = 0L;
    }

    private synchronized void runInNative(Runnable runnable) {
        if (this.mNativeHandle != 0L) {
            runnable.run();
        }
    }

    @CalledByNative
    public Handler getCallbackHandler() {
        return this.mCallbackHandler;
    }

    @Override
    public void onCameraError(CameraControllerInterface cameraController) {
        this.mCallbackHandler.runOrPost(a.a(this));
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.mCallbackHandler.runOrPost(b.a(this, surfaceTexture));
    }

    private static native void nativeOnCameraError(long var0);

    private static native void nativeOnFrameAvailable(long var0, SurfaceTexture var2);

    static /* synthetic */ void lambda$onFrameAvailable$3(NativeCameraCaptureListener this_, SurfaceTexture surfaceTexture) {
        NativeCameraCaptureListener nativeCameraCaptureListener = this_;
        nativeCameraCaptureListener.runInNative(c.a(nativeCameraCaptureListener, surfaceTexture));
    }

    static /* synthetic */ void lambda$null$2(NativeCameraCaptureListener this_, SurfaceTexture surfaceTexture) {
        NativeCameraCaptureListener.nativeOnFrameAvailable(this_.mNativeHandle, surfaceTexture);
    }

    static /* synthetic */ void lambda$onCameraError$1(NativeCameraCaptureListener this_) {
        NativeCameraCaptureListener nativeCameraCaptureListener = this_;
        nativeCameraCaptureListener.runInNative(d.a(nativeCameraCaptureListener));
    }

    static /* synthetic */ void lambda$null$0(NativeCameraCaptureListener this_) {
        NativeCameraCaptureListener.nativeOnCameraError(this_.mNativeHandle);
    }
}

