/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tplayer.plugins.report;

import com.tencent.thumbplayer.common.a.a;
import com.tencent.thumbplayer.utils.TPLogUtil;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TPReportParams {
    private static final String TAG = "TPReportParams";
    public static final int PLAY_TYPE_VOD = 0;
    public static final int PLAY_TYPE_LIVE = 1;
    public static final int PLAY_TYPE_UNKNOWN = -1;
    public static final int PLAYER_STEP_INIT_PLAYER = 5;
    public static final int PLAYER_STEP_GET_CDN_URL = 15;
    public static final int PLAYER_STEP_FIRST_LOAD = 30;
    public static final int PLAYER_STEP_FIRST_RENDERING = 32;
    public static final int PLAYER_STEP_LOAD_SUBTITLE = 33;
    public static final int PLAYER_STEP_REDIRECT = 34;
    public static final int PLAYER_STEP_BUFFERING = 35;
    public static final int PLAYER_STEP_USER_SEEK = 40;
    public static final int PLAYER_STEP_PLAY_DONE = 50;
    public static final int LIVE_STEP_LOADING_SUCC = 205;
    public static final int LIVE_STEP_FAILED = 150;
    public static final int LIVE_STEP_PLAY = 263;
    public static final int PLAY_END_REASON_EOS = 0;
    public static final int PLAY_END_REASON_USER_STOP = 1;
    public static final int PLAY_END_REASON_APP_EXIT = 2;
    public static final int PLAY_END_REASON_PLAYER_ERROR = 3;
    public static final int BUFFERING_REASON_NETWORK_UNSTABLE = 1400100;
    public static final int BUFFERING_REASON_DOWNLOAD_TASK = 1400101;
    public static final int BUFFERING_REASON_NETWORK_DEVICE_EXCEPTION = 1400102;
    public static final int BUFFERING_REASON_CDN_TIMEOUT = 1400103;
    public static final int BUFFERING_REASON_CDN_TIMEOUT_BUT_CONNECTED = 1400104;
    public static final int BUFFERING_REASON_RECEIVE_TIMEOUT = 1400105;
    public static final int BUFFERING_REASON_RECEIVE_TIMEOUT_BUT_CONNECTED = 1400106;
    public static final int BUFFERING_REASON_SLOWLY_SPEED = 1400107;
    public static final int BUFFERING_REASON_SLOWLY_SPEED_BUT_CONNECTED = 1400108;
    public static final int BUFFERING_REASON_BITRATE_JITTER = 1400109;
    public static final int BUFFERING_REASON_P2P_FASTER_THAN_HTTP = 1400110;
    public static final int BUFFERING_REASON_DOWNLOAD_SHORT_TIME = 1400111;
    public static final int BUFFERING_REASON_P2P_UPLOAD = 1400112;
    public static final int VIDEO_DL_TYPE_MP4 = 1;
    public static final int VIDEO_DL_TYPE_HLS = 3;
    public static final int PLAY_SCENE_NORMAL_PLAY = 1;
    public static final int PLAY_SCENE_TRICK_PLAY = 2;
    public static final int PLAY_EVENT_NONE = 0;
    public static final int PLAY_EVENT_SEEK = 1;
    public static final int PLAY_EVENT_PAUSE_BY_DEVICE = 2;
    public static final int PLAY_EVENT_SCREEN_SHOT = 3;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_WIFI = 1;
    public static final int NETWORK_TYPE_2G = 2;
    public static final int NETWORK_TYPE_3G = 3;
    public static final int NETWORK_TYPE_4G = 4;
    public static final int NETWORK_TYPE_5G = 5;
    public static final int NETWORK_TYPE_ETHERNET = 10;
    public static final int PLAYER_TYPE_SYSTEM_PLAYER = 0;
    public static final int PLAYER_TYPE_THUMB_PLAYER = 1;
    public static final String ERROR_CODE_NO_ERROR = "0";
    public static final String PROP_KEY_DATA = "data";
    public static final String JSON_KEY_VAL = "val";
    private CommonParams commonParams = new CommonParams();
    private PlayerInitParams initParams = new PlayerInitParams();
    private GetCdnUrlParams getCdnParams = new GetCdnUrlParams();
    private FirstLoadParams firstLoadParams = new FirstLoadParams();
    private FirstRenderParams firstRenderParams = new FirstRenderParams();
    private LoadSubtitleParams loadSubtitleParams = new LoadSubtitleParams();
    private RedirectParams redirectParams = new RedirectParams();
    private BufferingTotalParams bufferingTotalParams = new BufferingTotalParams();
    private UserSeekTotalParams userSeekTotalParams = new UserSeekTotalParams();
    private PlayDoneParams playDoneParams = new PlayDoneParams();
    private LiveExParam liveExParam = new LiveExParam();
    private VodExParam vodExParam = new VodExParam();

    public TPReportParams() {
        this.commonParams.reset();
        this.initParams.reset();
        this.getCdnParams.reset();
        this.firstLoadParams.reset();
        this.firstRenderParams.reset();
        this.loadSubtitleParams.reset();
        this.redirectParams.reset();
        this.bufferingTotalParams.reset();
        this.userSeekTotalParams.reset();
        this.playDoneParams.reset();
    }

    public CommonParams getCommonParams() {
        return this.commonParams;
    }

    public PlayerInitParams getInitParams() {
        return this.initParams;
    }

    public GetCdnUrlParams getGetCdnParams() {
        return this.getCdnParams;
    }

    public FirstLoadParams getFirstLoadParams() {
        return this.firstLoadParams;
    }

    public FirstRenderParams getFirstRenderParams() {
        return this.firstRenderParams;
    }

    public LoadSubtitleParams getLoadSubtitleParams() {
        return this.loadSubtitleParams;
    }

    public RedirectParams getRedirectParams() {
        return this.redirectParams;
    }

    public BufferingTotalParams getBufferingTotalParams() {
        return this.bufferingTotalParams;
    }

    public UserSeekTotalParams getUserSeekTotalParams() {
        return this.userSeekTotalParams;
    }

    public PlayDoneParams getPlayDoneParams() {
        return this.playDoneParams;
    }

    public LiveExParam getLiveExParam() {
        return this.liveExParam;
    }

    public BufferingOnceParams createBufferingOnceParams() {
        return new BufferingOnceParams();
    }

    public UserSeekOnceParams createUserSeekOnceParams() {
        return new UserSeekOnceParams();
    }

    public VodExParam getVodExParam() {
        return this.vodExParam;
    }

    public void resetAllParam() {
        this.commonParams.reset();
        this.firstLoadParams.reset();
        this.firstRenderParams.reset();
        this.loadSubtitleParams.reset();
        this.getCdnParams.reset();
        this.redirectParams.reset();
        this.bufferingTotalParams.reset();
        this.userSeekTotalParams.reset();
        this.playDoneParams.reset();
        this.liveExParam.reset();
        this.vodExParam.reset();
    }

    public class LiveExParam {
        long reportTimeLong;
        String userIpString;
        String userQQString;
        int prePlayLengthInt;
        int adPlayLengthInt;
        String playerVersionString;
        String downloadServerIpString;
        int deviceTypeInt;
        int networkTypeInt;
        int freeTypeInt;
        int isUseP2PInt;
        int isStreamP2PInt;
        int liveProgramIdInt;
        int streamIdInt;
        int contentIdInt;
        int playTimeInt;
        int isUserPayInt;
        String defSwitchString;
        int liveTypeInt;
        String cdnServerString;
        String downloadUrl;
        int isLookBackInt;
        int liveDelayInt;
        int liveTagInt;
        String extraInfoString;
        String spanId;
        String tuid;
        int connectTimeInt;
        int maxSpeedInt;
        int testSpeedInt;
        int downSpeedInt;
        int reconnectCntInt;
        long loadingTimeLong;
        int blockTimeInt;
        int blockCountInt;
        int errCodeInt;
        int getUrlTimeInt;
        String fullErrCodeString;
        int getStreamDurationInt;
        int getSyncFrameDurationInt;

        public void reset() {
        }

        public void paramsToProperties(a a2) {
            a2.a("ftime", this.reportTimeLong);
            a2.a("sip", this.userIpString);
            a2.a("iqq", this.userQQString);
            a2.a("prdlength", this.prePlayLengthInt);
            a2.a("playad", this.adPlayLengthInt);
            a2.a("fplayerver", this.playerVersionString);
            a2.a("dsip", this.downloadServerIpString);
            a2.a("devtype", this.deviceTypeInt);
            a2.a("nettype", this.networkTypeInt);
            a2.a("freetype", this.freeTypeInt);
            a2.a("use_p2p", this.isUseP2PInt);
            a2.a("p2p_play", this.isStreamP2PInt);
            a2.a("livepid", this.liveProgramIdInt);
            a2.a("sid", this.streamIdInt);
            a2.a("contentid", this.contentIdInt);
            a2.a("playtime", this.playTimeInt);
            a2.a("isuserpay", this.isUserPayInt);
            a2.a("switch", this.defSwitchString);
            a2.a("live_type", this.liveTypeInt);
            a2.a("xserverip", this.cdnServerString);
            a2.a("durl", this.downloadUrl);
            a2.a("lookback", this.isLookBackInt);
            a2.a("live_delay", this.liveDelayInt);
            a2.a("live_tag", this.liveTagInt);
            a2.a("extraInfo", this.extraInfoString);
            a2.a("cnntime", this.connectTimeInt);
            a2.a("maxspeed", this.maxSpeedInt);
            a2.a("testspeed", this.testSpeedInt);
            a2.a("downspeed", this.downSpeedInt);
            a2.a("recnncount", this.reconnectCntInt);
            a2.a("loadingtime", this.loadingTimeLong);
            a2.a("blocktime", this.blockTimeInt);
            a2.a("blockcount", this.blockCountInt);
            a2.a("errorcode", this.errCodeInt);
            a2.a("geturltime", this.getUrlTimeInt);
            a2.a("fullecode", this.fullErrCodeString);
            a2.a("get_stream_data_duration", this.getStreamDurationInt);
            a2.a("get_sync_frame_duration", this.getSyncFrameDurationInt);
            a2.a("spanId", this.spanId);
            a2.a("tuid", this.tuid);
        }

        public void paramsToJson(JSONObject jSONObject) {
        }
    }

    public class VodExParam {
        int freeTypeInt;
        int currentPlayInt;
        int optimizedPlayInt;
        int hasSubtitleInt;
        int isSelectedSubtitleInt;
        int multiTrackInt;
        int bizIdInt;
        int hevcLcInt;
        int clipInt;
        int statusInt;
        int hitDownloaded;

        public void reset() {
        }

        public void paramsToProperties(a a2) {
            a2.a("freetype", this.freeTypeInt);
            a2.a("currentplay", this.currentPlayInt);
            a2.a("optimizedplay", this.optimizedPlayInt);
            a2.a("subtitles", this.hasSubtitleInt);
            a2.a("selsubtitles", this.isSelectedSubtitleInt);
            a2.a("multitrack", this.multiTrackInt);
            a2.a("bizid", this.bizIdInt);
            a2.a("hevclv", this.hevcLcInt);
            a2.a("clip", this.clipInt);
            a2.a("status", this.statusInt);
            a2.a("hitdownloaded", this.hitDownloaded);
        }

        public void paramsToJson(JSONObject jSONObject) {
        }
    }

    public class PlayDoneParams {
        public int reasonInt;
        public long endTimeUnix;
        public float playDurationFloat;
        public String errCodeString;

        public void reset() {
            this.reasonInt = 0;
            this.endTimeUnix = 0L;
            this.playDurationFloat = 0.0f;
            this.errCodeString = TPReportParams.ERROR_CODE_NO_ERROR;
        }

        public void paramsToProperties(a a2) {
            a2.a("reason", this.reasonInt);
            a2.a("etime", this.endTimeUnix);
            a2.a("playduration", this.playDurationFloat);
            a2.a("code", this.errCodeString);
        }

        public void paramsToJson(JSONObject jSONObject) {
            try {
                jSONObject.put("reason", this.reasonInt);
                jSONObject.put("etime", this.endTimeUnix);
                jSONObject.put("playduration", (double)this.playDurationFloat);
                jSONObject.put("code", (Object)this.errCodeString);
                return;
            }
            catch (JSONException jSONException) {
                TPLogUtil.e(TPReportParams.TAG, jSONException);
                return;
            }
        }
    }

    public class UserSeekOnceParams {
        public int formatInt;
        public long startPresentTimeLong;
        public long endPresentTimeLong;
        public long seekStartTimeUnix;
        public long seekEndTimeUnix;
        public String errCodeString;

        public void reset() {
            this.startPresentTimeLong = 0L;
            this.endPresentTimeLong = 0L;
            this.seekStartTimeUnix = 0L;
            this.seekEndTimeUnix = 0L;
            this.errCodeString = TPReportParams.ERROR_CODE_NO_ERROR;
        }

        public void paramsToProperties(a a2) {
            a2.a("format", this.formatInt);
            a2.a("pstime", this.startPresentTimeLong);
            a2.a("petime", this.endPresentTimeLong);
            a2.a("lstime", this.seekStartTimeUnix);
            a2.a("letime", this.seekEndTimeUnix);
            a2.a("code", this.errCodeString);
        }

        public void paramsToJson(JSONObject jSONObject) {
            try {
                jSONObject.put("format", this.formatInt);
                jSONObject.put("pstime", this.startPresentTimeLong);
                jSONObject.put("petime", this.endPresentTimeLong);
                jSONObject.put("lstime", this.seekStartTimeUnix);
                jSONObject.put("letime", this.seekEndTimeUnix);
                jSONObject.put("code", (Object)this.errCodeString);
                return;
            }
            catch (JSONException jSONException) {
                TPLogUtil.e(TPReportParams.TAG, jSONException);
                return;
            }
        }
    }

    public class UserSeekTotalParams {
        public int seekTotalCountInt;
        public int seekBufferingCountInt;
        public int seekBufferingDurationInt;
        public List<UserSeekOnceParams> seekOnceParamsList = new LinkedList<UserSeekOnceParams>();

        public void reset() {
            this.seekTotalCountInt = 0;
            this.seekBufferingCountInt = 0;
            this.seekBufferingDurationInt = 0;
            this.seekOnceParamsList.clear();
        }

        public void paramsToProperties(a a2) {
            a2.a("scount", this.seekTotalCountInt);
            a2.a("tbcount", this.seekBufferingCountInt);
            a2.a("tbduration", this.seekBufferingDurationInt);
        }

        public void paramsToJson(JSONObject jSONObject) {
            try {
                jSONObject.put("scount", this.seekTotalCountInt);
                jSONObject.put("tbcount", this.seekBufferingCountInt);
                jSONObject.put("tbduration", this.seekBufferingDurationInt);
                JSONArray jSONArray = new JSONArray();
                for (UserSeekOnceParams userSeekOnceParams : this.seekOnceParamsList) {
                    JSONObject jSONObject2 = new JSONObject();
                    userSeekOnceParams.paramsToJson(jSONObject2);
                    jSONArray.put((Object)jSONObject2);
                }
                jSONObject.put(TPReportParams.JSON_KEY_VAL, (Object)jSONArray);
                return;
            }
            catch (JSONException jSONException) {
                TPLogUtil.e(TPReportParams.TAG, jSONException);
                return;
            }
        }
    }

    public class BufferingOnceParams {
        public int sceneInt;
        public int lastEventInt;
        public int reasonInt;
        public int formatInt;
        public long bufferingPresentTimeLong;
        public long starTimeUnix;
        public long endTimeUnix;
        public String urlString;
        public String errCodeString;

        public void reset() {
            this.sceneInt = 1;
            this.lastEventInt = 0;
            this.reasonInt = 1400100;
        }

        public void paramsToProperties(a a2) {
            a2.a("scene", this.sceneInt);
            a2.a("levent", this.lastEventInt);
            a2.a("reason", this.reasonInt);
            a2.a("format", this.formatInt);
            a2.a("ptime", this.bufferingPresentTimeLong);
            a2.a("stime", this.starTimeUnix);
            a2.a("etime", this.endTimeUnix);
            a2.a("url", this.urlString);
            a2.a("code", this.errCodeString);
        }

        public void paramsToJson(JSONObject jSONObject) {
            try {
                jSONObject.put("scene", this.sceneInt);
                jSONObject.put("levent", this.lastEventInt);
                jSONObject.put("reason", this.reasonInt);
                jSONObject.put("format", this.formatInt);
                jSONObject.put("ptime", this.bufferingPresentTimeLong);
                jSONObject.put("stime", this.starTimeUnix);
                jSONObject.put("etime", this.endTimeUnix);
                jSONObject.put("url", (Object)this.urlString);
                jSONObject.put("code", (Object)this.errCodeString);
                return;
            }
            catch (JSONException jSONException) {
                TPLogUtil.e(TPReportParams.TAG, jSONException);
                return;
            }
        }
    }

    public class BufferingTotalParams {
        public int bufferingCountInt;
        public int bufferingDurationInt;
        public List<BufferingOnceParams> bufferingOnceParamsList = new LinkedList<BufferingOnceParams>();

        public void reset() {
            this.bufferingCountInt = 0;
            this.bufferingDurationInt = 0;
            this.bufferingOnceParamsList.clear();
        }

        public void paramsToProperties(a a2) {
            a2.a("bcount", this.bufferingCountInt);
            a2.a("tduration", this.bufferingDurationInt);
        }

        public void paramsToJson(JSONObject jSONObject) {
            try {
                jSONObject.put("bcount", this.bufferingCountInt);
                jSONObject.put("tduration", this.bufferingDurationInt);
                JSONArray jSONArray = new JSONArray();
                for (BufferingOnceParams bufferingOnceParams : this.bufferingOnceParamsList) {
                    JSONObject jSONObject2 = new JSONObject();
                    bufferingOnceParams.paramsToJson(jSONObject2);
                    jSONArray.put((Object)jSONObject2);
                }
                jSONObject.put(TPReportParams.JSON_KEY_VAL, (Object)jSONArray);
                return;
            }
            catch (JSONException jSONException) {
                TPLogUtil.e(TPReportParams.TAG, jSONException);
                return;
            }
        }
    }

    public class RedirectParams {
        public long starTimeUnix;
        public long endTimeUnix;
        public String redirectedUrlString;
        public int cdnTypeInt;
        public int redirectCountInt;
        public String errCodeString;

        public void reset() {
            this.starTimeUnix = 0L;
            this.endTimeUnix = 0L;
            this.redirectedUrlString = "";
            this.cdnTypeInt = 0;
            this.redirectCountInt = 0;
            this.errCodeString = TPReportParams.ERROR_CODE_NO_ERROR;
        }

        public void paramsToProperties(a a2) {
            a2.a("etime", this.endTimeUnix);
            a2.a("url", this.redirectedUrlString);
            a2.a("vt", this.cdnTypeInt);
            a2.a("t302", this.redirectCountInt);
            a2.a("code", this.errCodeString);
        }

        public void paramsToJson(JSONObject jSONObject) {
            try {
                jSONObject.put("etime", this.endTimeUnix);
                jSONObject.put("url", (Object)this.redirectedUrlString);
                jSONObject.put("vt", this.cdnTypeInt);
                jSONObject.put("t302", this.redirectCountInt);
                jSONObject.put("code", (Object)this.errCodeString);
                return;
            }
            catch (JSONException jSONException) {
                TPLogUtil.e(TPReportParams.TAG, jSONException);
                return;
            }
        }
    }

    public class LoadSubtitleParams {
        public long starTimeUnix;
        public long endTimeUnix;
        public int bufferingDurationInt;
        public String subtitleUrlString;
        public int cdnTypeInt;
        public int cgiUrlIndex;
        public String errCodeString;

        public void reset() {
            this.starTimeUnix = 0L;
            this.endTimeUnix = 0L;
            this.bufferingDurationInt = 0;
            this.subtitleUrlString = "";
            this.cdnTypeInt = 0;
            this.cgiUrlIndex = 0;
            this.errCodeString = TPReportParams.ERROR_CODE_NO_ERROR;
        }

        public void paramsToProperties(a a2) {
            a2.a("stime", this.starTimeUnix);
            a2.a("etime", this.endTimeUnix);
            a2.a("bufferduration", this.bufferingDurationInt);
            a2.a("url", this.subtitleUrlString);
            a2.a("vt", this.cdnTypeInt);
            a2.a("urlindex", this.cgiUrlIndex);
            a2.a("code", this.errCodeString);
        }

        public void paramsToJson(JSONObject jSONObject) {
            try {
                jSONObject.put("stime", this.starTimeUnix);
                jSONObject.put("etime", this.endTimeUnix);
                jSONObject.put("bufferduration", this.bufferingDurationInt);
                jSONObject.put("url", (Object)this.subtitleUrlString);
                jSONObject.put("vt", this.cdnTypeInt);
                jSONObject.put("urlindex", this.cgiUrlIndex);
                jSONObject.put("code", (Object)this.errCodeString);
                return;
            }
            catch (JSONException jSONException) {
                TPLogUtil.e(TPReportParams.TAG, jSONException);
                return;
            }
        }
    }

    public class FirstRenderParams {
        public long starTimeUnix;
        public long endTimeUnix;
        public String errCodeString;

        public void reset() {
            this.starTimeUnix = 0L;
            this.endTimeUnix = 0L;
            this.errCodeString = TPReportParams.ERROR_CODE_NO_ERROR;
        }

        public void paramsToProperties(a a2) {
            a2.a("stime", this.starTimeUnix);
            a2.a("etime", this.endTimeUnix);
            a2.a("code", this.errCodeString);
        }

        public void paramsToJson(JSONObject jSONObject) {
            try {
                jSONObject.put("stime", this.starTimeUnix);
                jSONObject.put("etime", this.endTimeUnix);
                jSONObject.put("code", (Object)this.errCodeString);
                return;
            }
            catch (JSONException jSONException) {
                TPLogUtil.e(TPReportParams.TAG, jSONException);
                return;
            }
        }
    }

    public class FirstLoadParams {
        public long starTimeUnix;
        public long firstOpenTimeUnix;
        public long firstPacketReadTimeUnix;
        public long endTimeUnix;
        public String cdnUrlString;
        public int cgiUrlIndex;
        public String errCodeString;

        public void reset() {
            this.starTimeUnix = 0L;
            this.firstOpenTimeUnix = 0L;
            this.firstPacketReadTimeUnix = 0L;
            this.endTimeUnix = 0L;
            this.cdnUrlString = "";
            this.cgiUrlIndex = 0;
            this.errCodeString = TPReportParams.ERROR_CODE_NO_ERROR;
        }

        public void paramsToProperties(a a2) {
            a2.a("stime", this.starTimeUnix);
            a2.a("etime", this.endTimeUnix);
            a2.a("fileopenedtime", this.firstOpenTimeUnix);
            a2.a("firstpacketreadtime", this.firstPacketReadTimeUnix);
            a2.a("url", this.cdnUrlString);
            a2.a("urlindex", this.cgiUrlIndex);
            a2.a("code", this.errCodeString);
        }

        public void paramsToJson(JSONObject jSONObject) {
            try {
                jSONObject.put("stime", this.starTimeUnix);
                jSONObject.put("etime", this.endTimeUnix);
                jSONObject.put("fileopenedtime", this.firstOpenTimeUnix);
                jSONObject.put("firstpacketreadtime", this.firstPacketReadTimeUnix);
                jSONObject.put("url", (Object)this.cdnUrlString);
                jSONObject.put("urlindex", this.cgiUrlIndex);
                jSONObject.put("code", (Object)this.errCodeString);
                return;
            }
            catch (JSONException jSONException) {
                TPLogUtil.e(TPReportParams.TAG, jSONException);
                return;
            }
        }
    }

    public class GetCdnUrlParams {
        public long starTimeUnix;
        public long endTimeUnix;
        public String proxyIpString;
        public String errCodeString;

        public void reset() {
            this.starTimeUnix = 0L;
            this.endTimeUnix = 0L;
            this.proxyIpString = "";
            this.errCodeString = TPReportParams.ERROR_CODE_NO_ERROR;
        }

        public void paramsToProperties(a a2) {
            a2.a("stime", this.starTimeUnix);
            a2.a("etime", this.endTimeUnix);
            a2.a("ip", this.proxyIpString);
            a2.a("code", this.errCodeString);
        }

        public void paramsToJson(JSONObject jSONObject) {
            try {
                jSONObject.put("stime", this.starTimeUnix);
                jSONObject.put("etime", this.endTimeUnix);
                jSONObject.put("ip", (Object)this.proxyIpString);
                jSONObject.put("code", (Object)this.errCodeString);
                return;
            }
            catch (JSONException jSONException) {
                TPLogUtil.e(TPReportParams.TAG, jSONException);
                return;
            }
        }
    }

    public class PlayerInitParams {
        public long playStarTimeUnix;
        public long playEndTimeUnix;
        public String errCodeString;

        public void reset() {
            this.playStarTimeUnix = 0L;
            this.playEndTimeUnix = 0L;
            this.errCodeString = TPReportParams.ERROR_CODE_NO_ERROR;
        }

        public void paramsToProperties(a a2) {
            a2.a("stime", this.playStarTimeUnix);
            a2.a("etime", this.playEndTimeUnix);
            a2.a("code", this.errCodeString);
        }

        public void paramsToJson(JSONObject jSONObject) {
            try {
                jSONObject.put("stime", this.playStarTimeUnix);
                jSONObject.put("etime", this.playEndTimeUnix);
                jSONObject.put("code", (Object)this.errCodeString);
                return;
            }
            catch (JSONException jSONException) {
                TPLogUtil.e(TPReportParams.TAG, jSONException);
                return;
            }
        }
    }

    public class CommonParams {
        public int stepInt;
        public int seqInt = 0;
        public long platformLong;
        public String flowIdString;
        public String playNoString;
        public String uinString;
        public String qqOpenIdString;
        public String wxOpenIdString;
        public int loginTypeInt;
        public String guidString;
        public String uipString;
        public String cdnUipString;
        public String cdnIpString;
        public int onlineInt;
        public int p2pInt;
        public int signalStrengthInt;
        public int networkTypeInt;
        public int networkSpeedInt;
        public String deviceNameString;
        public String deviceResolutionString;
        public int testIdInt;
        public String osVersionString;
        public String p2pVersionString;
        public String appVersionString;
        public String playerVersionString;
        public int playerTypeInt;
        public int cdnIdInt;
        public int scenesId;
        public int playTypeInt;
        public int downloadTypeInt;
        public String vidString;
        public String mediaResolutionString;
        public int mediaFormatInt;
        public int mediaRateInt;
        public float mediaDurationFloat;
        public String proto;
        public String protover;

        public void reset() {
            this.stepInt = 0;
            this.seqInt = 0;
            this.platformLong = 0L;
            this.flowIdString = "";
            this.playNoString = "";
            this.uinString = "";
            this.qqOpenIdString = "";
            this.wxOpenIdString = "";
            this.loginTypeInt = 0;
            this.guidString = "";
            this.uipString = "";
            this.cdnUipString = "";
            this.cdnIpString = "";
            this.onlineInt = 0;
            this.p2pInt = 0;
            this.signalStrengthInt = 0;
            this.networkTypeInt = 0;
            this.networkSpeedInt = 0;
            this.deviceNameString = "";
            this.deviceResolutionString = "";
            this.testIdInt = 0;
            this.osVersionString = "";
            this.p2pVersionString = "";
            this.appVersionString = "";
            this.playerVersionString = "";
            this.playerTypeInt = 0;
            this.cdnIdInt = 0;
            this.scenesId = 0;
            this.downloadTypeInt = 0;
            this.vidString = "";
            this.mediaResolutionString = "";
            this.mediaFormatInt = 0;
            this.mediaRateInt = 0;
            this.mediaDurationFloat = 0.0f;
            this.proto = "";
            this.protover = "";
        }

        public void paramsToProperties(a a2) {
            a2.a("step", this.stepInt);
            a2.a("seq", this.seqInt);
            a2.a("platform", this.platformLong);
            a2.a("flowid", this.flowIdString);
            a2.a("playno", this.playNoString);
            a2.a("uin", this.uinString);
            a2.a("QQopenid", this.qqOpenIdString);
            a2.a("WXopenid", this.wxOpenIdString);
            a2.a("logintype", this.loginTypeInt);
            a2.a("guid", this.guidString);
            a2.a("uip", this.uipString);
            a2.a("cdnuip", this.cdnUipString);
            a2.a("cdnip", this.cdnIpString);
            a2.a("online", this.onlineInt);
            a2.a("p2p", this.p2pInt);
            a2.a("sstrength", this.signalStrengthInt);
            a2.a("network", this.networkTypeInt);
            a2.a("speed", this.networkSpeedInt);
            a2.a("device", this.deviceNameString);
            a2.a("resolution", this.deviceResolutionString);
            a2.a("testid", this.testIdInt);
            a2.a("osver", this.osVersionString);
            a2.a("p2pver", this.p2pVersionString);
            a2.a("appver", this.appVersionString);
            a2.a("playerver", this.playerVersionString);
            a2.a("playertype", this.playerTypeInt);
            a2.a("cdnid", this.cdnIdInt);
            a2.a("scenesid", this.scenesId);
            a2.a("playtype", this.playTypeInt);
            a2.a("dltype", this.downloadTypeInt);
            a2.a("vid", this.vidString);
            a2.a("definition", this.mediaResolutionString);
            a2.a("fmt", this.mediaFormatInt);
            a2.a("rate", this.mediaRateInt);
            a2.a("duration", this.mediaDurationFloat);
            a2.a("proto", this.proto);
            a2.a("protover", this.protover);
        }

        public void paramsToJson(JSONObject jSONObject) {
        }
    }
}

