/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import com.tencent.liteav.videobase.a.b;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public class TXCSavePreFrameFilter {
    private int mSavePreFrameNumber = 1;
    private b mDrawFilter = null;
    private int mVideoWidth = -1;
    private int mVideoHeight = -1;
    private e mGLTexturePool;
    private ArrayList<d> mRecyclerTextureBuffers = new ArrayList();
    private ArrayList<d> mPreTextureBuffers = new ArrayList();

    public void initFilter(e texturePool) {
        this.mGLTexturePool = texturePool;
        if (this.mDrawFilter == null) {
            this.mDrawFilter = new b();
            this.mDrawFilter.initialize(texturePool);
        }
    }

    public void onOutputSizeChanged(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        if (this.mDrawFilter != null) {
            this.mDrawFilter.onOutputSizeChanged(width, height);
        }
    }

    public boolean onDrawToTexture(int textureId, d outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        d d2;
        boolean bl2 = false;
        if (this.mPreTextureBuffers.size() >= this.mSavePreFrameNumber && this.mPreTextureBuffers.size() > 0) {
            d2 = this.mPreTextureBuffers.get(0);
            if (this.mDrawFilter != null) {
                this.mDrawFilter.onDraw(d2.a(), outTexture, cubeCoordsBuffer, textureCoordsBuffer);
            }
            this.mRecyclerTextureBuffers.add(d2);
            this.mPreTextureBuffers.remove(0);
            bl2 = true;
        }
        if ((d2 = this.mRecyclerTextureBuffers.size() > 0 ? this.mRecyclerTextureBuffers.remove(0) : this.mGLTexturePool.a(this.mVideoWidth, this.mVideoHeight)) != null) {
            this.mDrawFilter.onDraw(textureId, d2, cubeCoordsBuffer, textureCoordsBuffer);
            this.mPreTextureBuffers.add(d2);
        }
        return bl2;
    }

    public void setSavePreFrameNumber(int number) {
        if (number <= 0) {
            return;
        }
        this.mSavePreFrameNumber = number;
    }

    public void destroy() {
        Iterator<d> iterator;
        if (this.mDrawFilter != null) {
            this.mDrawFilter.uninitialize();
            this.mDrawFilter = null;
        }
        if (this.mRecyclerTextureBuffers != null) {
            iterator = this.mRecyclerTextureBuffers.iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
            this.mRecyclerTextureBuffers.clear();
            this.mRecyclerTextureBuffers = null;
        }
        if (this.mPreTextureBuffers != null) {
            iterator = this.mPreTextureBuffers.iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
            this.mPreTextureBuffers.clear();
            this.mPreTextureBuffers = null;
        }
    }
}

