/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.tencent.liteav.videobase.a.b;
import com.tencent.liteav.videobase.frame.e;

public class TXCZoomInOutFilter
extends b {
    public static final String SPIRITOUT_VERT = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nuniform mat4 textureTransform;\nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}";
    public static final String SPIRITOUT_FRAG = "precision highp float;\nvarying lowp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\nuniform lowp float alphaLevel;\nuniform vec2 offsetR; \nuniform vec2 offsetG;\nuniform vec2 offsetB;\n\nvoid main()\n{\n   mediump vec4 fout;\n   fout.r = texture2D(inputImageTexture, textureCoordinate + offsetR).r; \n   fout.g = texture2D(inputImageTexture, textureCoordinate + offsetG).g; \n   fout.b = texture2D(inputImageTexture, textureCoordinate + offsetB).b; \n   fout.a = alphaLevel;\n\n    gl_FragColor = fout;\n}\n";
    private int mTextureTransformMatrixLocation = -1;
    private int mOffsetRLocation = -1;
    private int mOffsetGLocation = -1;
    private int mOffsetBLocation = -1;
    private int mAlphaUniforLocation = -1;
    private float mAlphaLevel = 0.3f;
    private static String TAG = "ZoomInOut";
    private float[] mTextureTransformMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public TXCZoomInOutFilter() {
        super(SPIRITOUT_VERT, SPIRITOUT_FRAG);
    }

    @Override
    public void onInit(e texturePool) {
        super.onInit(texturePool);
        this.mTextureTransformMatrixLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"textureTransform");
        this.mAlphaUniforLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"alphaLevel");
        this.mOffsetRLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"offsetR");
        this.mOffsetGLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"offsetG");
        this.mOffsetBLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"offsetB");
        TXCZoomInOutFilter tXCZoomInOutFilter = this;
        tXCZoomInOutFilter.setAlphaLevel(tXCZoomInOutFilter.mAlphaLevel);
    }

    public void setColorOffset(float[] r2, float[] g2, float[] b2) {
        TXCZoomInOutFilter tXCZoomInOutFilter = this;
        tXCZoomInOutFilter.setFloatVec2OnDraw(tXCZoomInOutFilter.mOffsetRLocation, r2);
        TXCZoomInOutFilter tXCZoomInOutFilter2 = this;
        tXCZoomInOutFilter2.setFloatVec2OnDraw(tXCZoomInOutFilter2.mOffsetGLocation, g2);
        TXCZoomInOutFilter tXCZoomInOutFilter3 = this;
        tXCZoomInOutFilter3.setFloatVec2OnDraw(tXCZoomInOutFilter3.mOffsetBLocation, b2);
    }

    public void setAlphaLevel(float alpha) {
        this.mAlphaLevel = alpha;
        TXCZoomInOutFilter tXCZoomInOutFilter = this;
        tXCZoomInOutFilter.setFloatOnDraw(tXCZoomInOutFilter.mAlphaUniforLocation, this.mAlphaLevel);
    }

    public void setZoomLevel(float level, int number) {
        Matrix.setIdentityM((float[])this.mTextureTransformMatrix, (int)0);
        if ((double)Math.abs(level) <= 1.0E-5) {
            return;
        }
        for (int i2 = 0; i2 < number; ++i2) {
            float[] fArray = new float[16];
            Matrix.setIdentityM((float[])fArray, (int)0);
            float f2 = level;
            Matrix.scaleM((float[])fArray, (int)0, (float)f2, (float)f2, (float)1.0f);
            Matrix.multiplyMM((float[])this.mTextureTransformMatrix, (int)0, (float[])fArray, (int)0, (float[])this.mTextureTransformMatrix, (int)0);
            Matrix.setIdentityM((float[])fArray, (int)0);
            Matrix.translateM((float[])fArray, (int)0, (float)0.02f, (float)0.02f, (float)1.0f);
            Matrix.multiplyMM((float[])this.mTextureTransformMatrix, (int)0, (float[])fArray, (int)0, (float[])this.mTextureTransformMatrix, (int)0);
        }
    }

    @Override
    public void beforeDrawArrays(int textureId) {
        super.beforeDrawArrays(textureId);
        GLES20.glUniformMatrix4fv((int)this.mTextureTransformMatrixLocation, (int)1, (boolean)false, (float[])this.mTextureTransformMatrix, (int)0);
    }
}

