/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.watermark;

import android.text.TextUtils;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.videoprocessor.watermark.PasterBase;
import com.tencent.ugc.videoprocessor.watermark.data.AnimatedPaster;
import com.tencent.ugc.videoprocessor.watermark.data.AnimatedPasterJsonConfig;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AnimatedPasterFilterChain
extends PasterBase {
    private static final String TAG = "AnimatedPasterFilterChain";
    private List<TXVideoEditConstants.TXAnimatedPaster> mAnimatedPasterList;
    private CopyOnWriteArrayList<AnimatedPaster> mNormalizedList = new CopyOnWriteArrayList();

    public void setAnimatedPasterList(List<TXVideoEditConstants.TXAnimatedPaster> pasterList, Size renderSize) {
        this.mRenderSize = renderSize;
        this.mAnimatedPasterList = pasterList;
        this.mNormalizedList.clear();
    }

    public List<AnimatedPaster> getAnimatedPasterList() {
        return this.mNormalizedList;
    }

    @Override
    public void normalized(int frameW, int frameH, int renderMode) {
        if (this.mAnimatedPasterList == null || this.mAnimatedPasterList.size() == 0) {
            return;
        }
        for (TXVideoEditConstants.TXAnimatedPaster tXAnimatedPaster : this.mAnimatedPasterList) {
            if (tXAnimatedPaster == null) continue;
            TXVideoEditConstants.TXRect tXRect = this.calculateRect(frameW, frameH, renderMode, tXAnimatedPaster.frame);
            TXVideoEditConstants.TXAnimatedPaster tXAnimatedPaster2 = this.construct(tXAnimatedPaster, tXRect);
            AnimatedPasterJsonConfig animatedPasterJsonConfig = this.parsePaster(tXAnimatedPaster2.animatedPasterPathFolder);
            if (animatedPasterJsonConfig == null || animatedPasterJsonConfig.mCount <= 0) continue;
            long l2 = tXAnimatedPaster2.startTime;
            long l3 = tXAnimatedPaster2.endTime - l2;
            int n2 = animatedPasterJsonConfig.mPeriod / animatedPasterJsonConfig.mCount;
            int n3 = (int)(l3 / (long)animatedPasterJsonConfig.mPeriod);
            if (l3 % (long)animatedPasterJsonConfig.mPeriod > 0L) {
                ++n3;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int i3 = 0; i3 < animatedPasterJsonConfig.mCount && l2 + (long)n2 <= tXAnimatedPaster2.endTime; ++i3) {
                    AnimatedPasterJsonConfig.PasterPicture pasterPicture = animatedPasterJsonConfig.mFrameArray.get(i3);
                    AnimatedPaster animatedPaster = new AnimatedPaster();
                    new AnimatedPaster().mPasterPath = tXAnimatedPaster2.animatedPasterPathFolder + pasterPicture.mPictureName + ".png";
                    animatedPaster.mFrame = tXAnimatedPaster2.frame;
                    animatedPaster.mStartTime = l2;
                    animatedPaster.mEndTime = l2 + (long)n2;
                    animatedPaster.mRotation = tXAnimatedPaster2.rotation;
                    this.mNormalizedList.add(animatedPaster);
                    l2 = animatedPaster.mEndTime;
                }
            }
        }
    }

    private AnimatedPasterJsonConfig parsePaster(String folder) {
        JSONObject jSONObject;
        String string = folder + "config.json";
        String string2 = this.parseJsonFromFile(string);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            LiteavLog.e(TAG, "parse invalid json string", jSONException);
            return null;
        }
        AnimatedPasterJsonConfig animatedPasterJsonConfig = new AnimatedPasterJsonConfig();
        try {
            animatedPasterJsonConfig.mName = jSONObject.getString("name");
            animatedPasterJsonConfig.mCount = jSONObject.getInt("count");
            animatedPasterJsonConfig.mPeriod = jSONObject.getInt("period");
            animatedPasterJsonConfig.mWidth = jSONObject.getInt("width");
            animatedPasterJsonConfig.mHeight = jSONObject.getInt("height");
            animatedPasterJsonConfig.mKeyframe = jSONObject.getInt("keyframe");
            JSONArray jSONArray = jSONObject.getJSONArray("frameArray");
            for (int i2 = 0; i2 < animatedPasterJsonConfig.mCount; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                AnimatedPasterJsonConfig.PasterPicture pasterPicture = new AnimatedPasterJsonConfig.PasterPicture();
                new AnimatedPasterJsonConfig.PasterPicture().mPictureName = jSONObject2.getString("picture");
                animatedPasterJsonConfig.mFrameArray.add(pasterPicture);
            }
        }
        catch (JSONException jSONException) {
            LiteavLog.e(TAG, "failed to get value from json.", jSONException);
        }
        return animatedPasterJsonConfig;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseJsonFromFile(String filePath) {
        String string;
        String string2 = "";
        BufferedReader bufferedReader = null;
        FileInputStream fileInputStream = new FileInputStream(filePath);
        bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string = bufferedReader.readLine()) != null) {
            string2 = string2 + string;
        }
        bufferedReader.close();
        try {
            bufferedReader.close();
            return string2;
        }
        catch (IOException iOException) {}
        return string2;
        catch (IOException iOException) {
            try {
                LiteavLog.e(TAG, "read file failed.", iOException);
                if (bufferedReader == null) return string2;
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                bufferedReader.close();
                return string2;
            }
            catch (IOException iOException3) {}
            return string2;
        }
    }

    private TXVideoEditConstants.TXAnimatedPaster construct(TXVideoEditConstants.TXAnimatedPaster animatedPaster, TXVideoEditConstants.TXRect rect) {
        TXVideoEditConstants.TXAnimatedPaster tXAnimatedPaster = new TXVideoEditConstants.TXAnimatedPaster();
        new TXVideoEditConstants.TXAnimatedPaster().frame = rect;
        tXAnimatedPaster.animatedPasterPathFolder = animatedPaster.animatedPasterPathFolder;
        tXAnimatedPaster.startTime = animatedPaster.startTime;
        tXAnimatedPaster.endTime = animatedPaster.endTime;
        tXAnimatedPaster.rotation = animatedPaster.rotation;
        return tXAnimatedPaster;
    }

    @Override
    public void clear() {
        super.clear();
        this.mNormalizedList.clear();
        if (this.mAnimatedPasterList != null) {
            this.mAnimatedPasterList.clear();
        }
        this.mAnimatedPasterList = null;
    }
}

