/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetUtils {
    public static final int NETWORK_NONE = 0;
    public static final int NETWORK_WIFI = 1;
    public static final int NETWORK_2G = 2;
    public static final int NETWORK_3G = 3;
    public static final int NETWORK_4G = 4;
    public static final int NETWORK_MOBILE = 5;

    public static int getNetworkState(Context context) {
        if (null == context) {
            return 0;
        }
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null == connManager) {
            return 0;
        }
        NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isAvailable() || !networkInfo.isConnected()) {
            return 0;
        }
        try {
            if (networkInfo.getType() == 1) {
                return 1;
            }
            if (networkInfo.getType() == 0) {
                String _strSubTypeName = networkInfo.getSubtypeName();
                int networkType = networkInfo.getSubtype();
                switch (networkType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 2;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 3;
                    }
                    case 13: {
                        return 4;
                    }
                }
                if (_strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000")) {
                    return 3;
                }
                return 5;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static String getNetworkStrState(Context context) {
        int netState = NetUtils.getNetworkState(context);
        switch (netState) {
            case 2: {
                return "2G";
            }
            case 3: {
                return "3G";
            }
            case 4: {
                return "4G";
            }
            case 1: {
                return "wlan";
            }
            case 5: {
                return "wwan";
            }
        }
        return "NotReachable";
    }

    public static boolean isNetConnected(Context context) {
        NetworkInfo info;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
    }

    public static synchronized boolean isWifiConnected(Context context) {
        int networkInfoType;
        NetworkInfo networkInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && ((networkInfoType = networkInfo.getType()) == 1 || networkInfoType == 9)) {
            return networkInfo.isConnected();
        }
        return false;
    }
}

