/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import androidx.annotation.NonNull;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.refresh.circlebar.CircleProgressBar;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;

@Component(lazyload=false)
public class WXLoadingIndicator
extends WXComponent<CircleProgressBar> {
    private static final String ANIMATING = "animating";

    public WXLoadingIndicator(WXSDKInstance instance, WXVContainer parent, boolean isLazy, BasicComponentData basicComponentData) {
        super(instance, parent, isLazy, basicComponentData);
    }

    @Override
    protected CircleProgressBar initComponentHostView(@NonNull Context context) {
        return new CircleProgressBar(context);
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "color": {
                String color2 = WXUtils.getString(param, null);
                if (color2 != null) {
                    this.setColor(color2);
                }
                return true;
            }
            case "animating": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setAnimating(result);
                }
                return true;
            }
            case "arrow": {
                boolean arrow = WXUtils.getBoolean(param, true);
                ((CircleProgressBar)((Object)this.getHostView())).setShowArrow(arrow);
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="color")
    public void setColor(String color2) {
        if (color2 != null && !color2.equals("")) {
            int parseColor = WXResourceUtils.getColor(color2, -65536);
            ((CircleProgressBar)((Object)this.getHostView())).setColorSchemeColors(parseColor);
        }
    }

    @WXComponentProp(name="animating")
    public void setAnimating(boolean animating) {
        if (animating) {
            ((CircleProgressBar)((Object)this.getHostView())).start();
        } else {
            ((CircleProgressBar)((Object)this.getHostView())).stop();
        }
    }

    private void setAnimatingSp(boolean animating) {
        if (animating) {
            ((CircleProgressBar)((Object)this.getHostView())).start();
        } else {
            ((CircleProgressBar)((Object)this.getHostView())).stop();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.getHostView() != null) {
            ((CircleProgressBar)((Object)this.getHostView())).destory();
        }
    }
}

