/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import java.util.HashMap;

public class WXDataStructureUtil {
    private static final int MAX_POWER_OF_TWO = 0x40000000;

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(WXDataStructureUtil.capacity(expectedSize));
    }

    private static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            WXDataStructureUtil.checkNonnegative(expectedSize, "expectedSize");
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    private static int checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }
}

