/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import cn.rongcloud.rtc.utils.FinLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AudioResample {
    private static final String TAG = "AudioResample";
    private static final int ENCODING_PCM_FLOAT = 4;
    private long nativeAudioResampleJni;
    private ByteBuffer inputDirectBuffer;
    private int mInputBufferSize = 0;
    private ByteBuffer outputDirectBuffer;
    private float factor;
    private boolean release = false;
    private final Object releaseLock = new Object();

    public AudioResample(int inSampleRate, int inChannelCount, int inBitWidth, int outSampleRate, int outChannelCount, int outBitWidth) {
        FinLog.i(TAG, "inSampleRate: " + inSampleRate + ", inChannelCount: " + inChannelCount + ", inBitWidth: " + inBitWidth + ", outSampleRate: " + outSampleRate + ", outChannelCount: " + outChannelCount + ", outBitWidth: " + outBitWidth);
        this.nativeAudioResampleJni = AudioResample.nativeCreateAudioResample(inSampleRate, inChannelCount, inBitWidth, outSampleRate, outChannelCount, outBitWidth);
        int error = this.nativeGetError(this.nativeAudioResampleJni);
        if (error != 0) {
            FinLog.e(TAG, "native error: " + error);
        }
        int inSampleBytes = this.bytesPerSample(inBitWidth);
        int outSampleBytes = this.bytesPerSample(outBitWidth);
        float sampleBytesFactor = (float)outSampleBytes / (float)inSampleBytes;
        float sampleRateFactor = (float)outSampleRate / (float)inSampleRate;
        float channelCountFactor = (float)outChannelCount / (float)inChannelCount;
        this.factor = sampleBytesFactor * sampleRateFactor * channelCountFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] resample(byte[] audioBuffer) {
        int outSampleSize;
        if (audioBuffer == null || audioBuffer.length == 0) {
            return null;
        }
        int audioLength = audioBuffer.length;
        if (audioLength > this.mInputBufferSize) {
            FinLog.i(TAG, "old buffer size: " + this.mInputBufferSize + ", new buffer size: " + audioLength);
            this.createAndCacheInputByteBuffer(audioLength);
            this.createAndCacheOutputByteBuffer((int)((double)((float)audioLength * this.factor) * 1.5));
            this.mInputBufferSize = audioLength;
        }
        this.inputDirectBuffer.clear();
        this.inputDirectBuffer.put(audioBuffer);
        Object object = this.releaseLock;
        synchronized (object) {
            if (this.release) {
                return null;
            }
            outSampleSize = this.nativeResample(this.nativeAudioResampleJni, audioLength);
        }
        byte[] outSamples = new byte[outSampleSize];
        this.outputDirectBuffer.clear();
        this.outputDirectBuffer.get(outSamples);
        return outSamples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        FinLog.i(TAG, "destroy");
        Object object = this.releaseLock;
        synchronized (object) {
            this.nativeDestroy(this.nativeAudioResampleJni);
            this.release = true;
        }
    }

    private int bytesPerSample(int bitWidth) {
        switch (bitWidth) {
            case 3: {
                return 1;
            }
            case 4: {
                return 4;
            }
        }
        return 2;
    }

    private void createAndCacheInputByteBuffer(int bufferSize) {
        this.inputDirectBuffer = this.newDirectByteBuffer(bufferSize);
        this.nativeCacheInDirectBufferAddress(this.nativeAudioResampleJni, this.inputDirectBuffer);
    }

    private void createAndCacheOutputByteBuffer(int bufferSize) {
        this.outputDirectBuffer = this.newDirectByteBuffer(bufferSize);
        this.nativeCacheOutDirectBufferAddress(this.nativeAudioResampleJni, this.outputDirectBuffer);
    }

    private ByteBuffer newDirectByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    private static native long nativeCreateAudioResample(int var0, int var1, int var2, int var3, int var4, int var5);

    private native int nativeGetError(long var1);

    private native void nativeCacheInDirectBufferAddress(long var1, ByteBuffer var3);

    private native void nativeCacheOutDirectBufferAddress(long var1, ByteBuffer var3);

    private native int nativeResample(long var1, int var3);

    private native void nativeDestroy(long var1);
}

