/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc.probe;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Pair;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.probe.IRCRTCProbeTestListener;
import cn.rongcloud.rtc.api.probe.RTCProbeConfig;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.core.IceCandidate;
import cn.rongcloud.rtc.core.MediaStream;
import cn.rongcloud.rtc.core.RtpReceiver;
import cn.rongcloud.rtc.core.SessionDescription;
import cn.rongcloud.rtc.module.AudioDeviceManager;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import cn.rongcloud.rtc.webrtc.PeerConnectionFactoryHolder;
import cn.rongcloud.rtc.webrtc.RTCConnectionEvents;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;
import cn.rongcloud.rtc.webrtc.probe.RTCProbeStatusReport;
import cn.rongcloud.rtc.webrtc.probe.RTCProbeVideoStream;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class RTCProbeManager {
    private static final String TAG = "RTCProbeManager";
    private static final long MAX_RUN_TIME = 30000L;
    protected PeerConnectionFactoryHolder rtcFactory;
    private RCRTCConfigImpl rtcConfig;
    private boolean started;
    private RTCConnectionHolder rtcConnection;
    private RTCProbeStatusReport statusReport;
    private RTCProbeVideoStream videoStream;
    private Handler handler;
    private final Object lock = new Object();
    private RTCProbeConfig probeConfig;
    private IRCRTCProbeTestListener probeListener;
    private IRCRTCResultCallback startCallback;
    private String token;
    private String clientSessionId;
    private CountDownLatch countDownLatch;
    private RTCConnectionEvents connectionEvents = new RTCConnectionEvents(){

        @Override
        public void onIceCandidate(IceCandidate candidate) {
        }

        @Override
        public void onIceCandidatesRemoved(IceCandidate[] candidates) {
        }

        @Override
        public void onIceConnected() {
        }

        @Override
        public void onIceDisconnected() {
            IRCRTCProbeTestListener probeListener = RTCProbeManager.this.probeListener;
            if (probeListener != null) {
                probeListener.onRTCProbeInterrupted(RTCErrorCode.RTC_ICE_DISCONNECT);
            }
            RTCProbeManager.this.execute(new Runnable(){

                @Override
                public void run() {
                    RTCProbeManager.this.onStop();
                }
            });
        }

        @Override
        public void onIceChecking() {
        }

        @Override
        public void onRTCConnectionError(String description) {
        }

        @Override
        public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
        }
    };

    public RTCProbeManager(PeerConnectionFactoryHolder rtcFactory, AudioDeviceManager audioDeviceManager, RCRTCConfigImpl rtcConfig) {
        this.rtcConfig = rtcConfig;
        this.rtcFactory = rtcFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(RTCProbeConfig config, IRCRTCResultCallback callback) {
        if (config == null) {
            ReportUtil.libError(ReportUtil.TAG.STARTPROBEFORIMPL, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "RTCProbeConfig is Null!");
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError);
            return;
        }
        ReportUtil.libTask(ReportUtil.TAG.STARTPROBEFORIMPL, "config|isStarted", config, this.started);
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                ReportUtil.libError(ReportUtil.TAG.STARTPROBEFORIMPL, "code|desc", RTCErrorCode.RTC_PROBE_TEST_STARTED.getValue(), "RTCProbeManager is started!");
                this.onFailedCallback(RTCErrorCode.RTC_PROBE_TEST_STARTED);
                return;
            }
            this.started = true;
            this.probeConfig = config;
            this.startCallback = callback;
            HandlerThread handlerThread = new HandlerThread("RTCProbeManager:" + this.hashCode());
            handlerThread.start();
            this.handler = new Handler(handlerThread.getLooper());
            this.execute(new Runnable(){

                @Override
                public void run() {
                    RTCProbeManager.this.onGetProbeToken();
                }
            });
        }
    }

    private void onFailedCallback(RTCErrorCode errorCode) {
        ReportUtil.libError(ReportUtil.TAG.STARTPROBEFORIMPL, "code|desc", errorCode.getValue(), errorCode.getReason());
        if (this.startCallback != null) {
            this.startCallback.onFailed(errorCode);
        }
        this.startCallback = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final boolean interiorForceStop, IRCRTCResultCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.STOPPROBEFORIMPL, "interiorForceStop", interiorForceStop);
        long startTime = 0L;
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                ReportUtil.libError(ReportUtil.TAG.STOPPROBEFORIMPL, "code|desc", RTCErrorCode.RTC_PROBE_TEST_NOT_START.getValue(), RTCErrorCode.RTC_PROBE_TEST_NOT_START.getReason());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.RTC_PROBE_TEST_NOT_START);
                }
                return;
            }
            this.countDownLatch = new CountDownLatch(1);
            startTime = System.nanoTime();
            boolean res = this.handler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    RTCProbeManager.this.onStop(interiorForceStop);
                }
            });
            try {
                if (res) {
                    this.countDownLatch.await(3000L, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ReportUtil.libRes(ReportUtil.TAG.STOPPROBEFORIMPL, "useTime", (double)(System.nanoTime() - startTime) * 1.0 / 1000000.0 + "ms");
        if (callback != null) {
            callback.onSuccess();
        }
    }

    private void onGetProbeToken() {
        FinLog.d(TAG, "[onGetProbeToken] ==> ");
        this.checkIsOnRTCProbeThread();
        SignalManager.getInstance().getProbeRTCToken(new IRCRTCResultDataCallback<Pair<String, String>>(){

            @Override
            public void onSuccess(final Pair<String, String> data) {
                RTCProbeManager.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        RTCProbeManager.this.createAndSetOffer((Pair<String, String>)data);
                    }
                });
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                RTCProbeManager.this.failed(errorCode);
            }
        });
    }

    private void createAndSetOffer(final Pair<String, String> pair) {
        FinLog.d(TAG, "[createAndSetOffer] ==> token:" + this.token);
        this.checkIsOnRTCProbeThread();
        this.rtcConnection = new RTCConnectionHolder(this.rtcFactory, this.rtcConfig, this.connectionEvents);
        this.videoStream = new RTCProbeVideoStream((String)pair.first, this.probeConfig);
        this.addStream(this.videoStream);
        this.rtcConnection.createAndSetOffer(TAG, false, this.probeConfig.getMaxBitRate(), new IRCRTCResultDataCallback<SessionDescription>(){

            @Override
            public void onSuccess(final SessionDescription data) {
                RTCProbeManager.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        RTCProbeManager.this.sendOffer(data, (String)pair.second);
                    }
                });
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                RTCProbeManager.this.failed(errorCode);
            }
        });
    }

    private void sendOffer(SessionDescription data, String token) {
        FinLog.d(TAG, "[sendOffer] ==> data:" + data + ",token:" + token);
        this.checkIsOnRTCProbeThread();
        this.token = token;
        this.clientSessionId = UUID.randomUUID().toString();
        SignalManager.getInstance().startRTCProbe(data, token, this.clientSessionId, new IRCRTCResultDataCallback<SessionDescription>(){

            @Override
            public void onSuccess(final SessionDescription data) {
                RTCProbeManager.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        RTCProbeManager.this.setAnswer(data);
                    }
                });
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                RTCProbeManager.this.failed(errorCode);
            }
        });
    }

    private void setAnswer(SessionDescription data) {
        FinLog.d(TAG, "[setAnswer] ==> data:" + data);
        this.checkIsOnRTCProbeThread();
        this.rtcConnection.onSetRemoteDescription(data, this.probeConfig.getMaxBitRate(), this.probeConfig.getMinBitRate(), -1, -1, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                RTCProbeManager.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        RTCProbeManager.this.startParseStatusReport();
                    }
                });
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                RTCProbeManager.this.failed(errorCode);
            }
        });
    }

    private void startParseStatusReport() {
        ReportUtil.libRes(ReportUtil.TAG.STARTPROBEFORIMPL, "code", 0);
        this.checkIsOnRTCProbeThread();
        this.statusReport = new RTCProbeStatusReport(this.rtcConnection, 2000L);
        this.statusReport.setRTCProbeTestListener(this.probeListener);
        this.videoStream.start();
        this.startTimer();
        if (this.startCallback != null) {
            this.startCallback.onSuccess();
        }
    }

    private void startTimer() {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                RTCProbeManager.this.onStop();
                if (RTCProbeManager.this.probeListener != null) {
                    RTCProbeManager.this.probeListener.onRTCProbeCompete();
                }
            }
        }, 30000L);
    }

    private void addStream(IStreamResource resource) {
        this.rtcFactory.bindingTrack(resource);
        MediaStream ms = this.rtcFactory.createLocalMediaStream(resource.getStreamId());
        ms.addTrack(resource.getTrack());
        this.rtcConnection.addStream(ms);
    }

    private void failed(RTCErrorCode errorCode) {
        FinLog.d(TAG, "[failed] ==> errorCode:" + (Object)((Object)errorCode));
        this.execute(new Runnable(){

            @Override
            public void run() {
                RTCProbeManager.this.onStop();
            }
        });
        this.onFailedCallback(errorCode);
    }

    private void onStop() {
        this.onStop(false);
    }

    private void onStop(boolean interiorForceStop) {
        FinLog.d(TAG, "[onStop] ==> ");
        this.checkIsOnRTCProbeThread();
        IRCRTCProbeTestListener probeListener = this.probeListener;
        if (interiorForceStop && this.started && probeListener != null) {
            probeListener.onRTCProbeInterrupted(RTCErrorCode.RTC_PROBE_INTERRUPT_BY_INTERNAL);
        }
        this.started = false;
        this.notifyMediaServerStop();
        if (this.videoStream != null) {
            this.videoStream.release();
        }
        this.videoStream = null;
        if (this.statusReport != null) {
            this.statusReport.stop();
        }
        this.statusReport = null;
        if (this.rtcConnection != null) {
            this.rtcConnection.release();
        }
        this.rtcConnection = null;
        this.probeConfig = null;
        if (this.handler != null) {
            this.handler.getLooper().quit();
        }
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
    }

    private void notifyMediaServerStop() {
        FinLog.d(TAG, "[notifyMediaServerStop] ==> ");
        if (TextUtils.isEmpty((CharSequence)this.token)) {
            return;
        }
        SignalManager.getInstance().stopRTCProbe(this.token, this.clientSessionId, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                FinLog.d(RTCProbeManager.TAG, "[notifyMediaServerStop] ==> onSuccess");
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.e(RTCProbeManager.TAG, "[notifyMediaServerStop] ==> onFailed:" + (Object)((Object)errorCode));
            }
        });
    }

    private boolean checkIsOnRTCProbeThread() {
        Thread thread = Thread.currentThread();
        if (thread != this.handler.getLooper().getThread()) {
            String msg = "Current Thread is " + thread.getName() + ", Not on RTCProbe thread!";
            FinLog.e(TAG, msg);
            return false;
        }
        return true;
    }

    private boolean execute(Runnable runnable) {
        if (!this.started) {
            return false;
        }
        return this.handler.post(runnable);
    }

    public void setRTCProbeTestListener(IRCRTCProbeTestListener listener) {
        this.probeListener = listener;
        RTCProbeStatusReport statusReport = this.statusReport;
        if (statusReport != null) {
            statusReport.setRTCProbeTestListener(this.probeListener);
        }
    }
}

