/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc.probe;

import android.util.Log;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.probe.IRCRTCProbeTestListener;
import cn.rongcloud.rtc.api.probe.RCRTCProbeQualityLevel;
import cn.rongcloud.rtc.api.probe.RCRTCProbeStatusResult;
import cn.rongcloud.rtc.api.probe.RCRTCStreamDirection;
import cn.rongcloud.rtc.api.report.StatusBean;
import cn.rongcloud.rtc.api.report.StatusReport;
import cn.rongcloud.rtc.webrtc.BaseStatusReportManager;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class RTCProbeStatusReport
extends BaseStatusReportManager {
    private static final String TAG = "RTCProbeStatusReport";
    private IRCRTCProbeTestListener listener;

    public RTCProbeStatusReport(RTCConnectionHolder connection, long interval) {
        super(connection, interval);
        this.setRTCStatusReportListener(new IRCRTCStatusReportListener(){

            @Override
            public void onConnectionStats(StatusReport statusReport) {
                RTCProbeStatusReport.this.onParseStats(statusReport);
            }
        });
    }

    public void setRTCProbeTestListener(IRCRTCProbeTestListener listener) {
        this.listener = listener;
    }

    private void onParseStats(StatusReport statusReport) {
        IRCRTCProbeTestListener callback = this.listener;
        if (callback == null) {
            return;
        }
        Log.d((String)TAG, (String)("onParseStats: bitRateSend:" + statusReport.bitRateSend + " , bitRateRcv: " + statusReport.bitRateRcv));
        StatusBean sendVideo = this.getFirstValue(statusReport.statusVideoSends);
        StatusBean recvVideo = this.getFirstValue(statusReport.statusVideoRcvs);
        ArrayList<RCRTCProbeStatusResult> statusResults = new ArrayList<RCRTCProbeStatusResult>(2);
        statusResults.add(new RCRTCProbeStatusResult(this.getLeave(sendVideo), sendVideo, RCRTCStreamDirection.UP_LINK));
        statusResults.add(new RCRTCProbeStatusResult(this.getLeave(recvVideo), recvVideo, RCRTCStreamDirection.DOWN_LINK));
        callback.onRTCProbeStatus(statusResults);
    }

    private RCRTCProbeQualityLevel getLeave(StatusBean bean) {
        long packetLostRate = bean.packetLostRate;
        if (packetLostRate == 0L && bean.bitRate == 0L) {
            return RCRTCProbeQualityLevel.QUALITY_DOWN;
        }
        if (packetLostRate < 5L) {
            return RCRTCProbeQualityLevel.QUALITY_EXCELLENT;
        }
        if (packetLostRate < 15L) {
            return RCRTCProbeQualityLevel.QUALITY_GOOD;
        }
        if (packetLostRate < 30L) {
            return RCRTCProbeQualityLevel.QUALITY_POOR;
        }
        if (packetLostRate < 50L) {
            return RCRTCProbeQualityLevel.QUALITY_BAD;
        }
        if (packetLostRate < 80L) {
            return RCRTCProbeQualityLevel.QUALITY_VERY_BAD;
        }
        return RCRTCProbeQualityLevel.QUALITY_DOWN;
    }

    private StatusBean getFirstValue(Map<String, StatusBean> map) {
        StatusBean bean = null;
        Iterator<StatusBean> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            StatusBean value;
            bean = value = iterator.next();
        }
        if (bean != null) {
            return bean;
        }
        throw new NullPointerException("StatusBean is null");
    }

    @Override
    public void stop() {
        super.stop();
        this.listener = null;
    }
}

