/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.filter;

import android.opengl.GLES20;
import com.daasuu.mp4compose.filter.GlFilter;

public class GlBrightnessFilter
extends GlFilter {
    private static final String BRIGHTNESS_FRAGMENT_SHADER = "precision mediump float; varying vec2 vTextureCoord;\n \n uniform lowp sampler2D sTexture;\n uniform lowp float brightness;\n \n void main()\n {\n     lowp vec4 textureColor = texture2D(sTexture, vTextureCoord);\n     \n     gl_FragColor = vec4((textureColor.rgb + vec3(brightness)), textureColor.w);\n }";
    private float brightness = 0.0f;

    public GlBrightnessFilter() {
        super("attribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\ngl_Position = aPosition;\nvTextureCoord = aTextureCoord.xy;\n}\n", BRIGHTNESS_FRAGMENT_SHADER);
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    @Override
    public void onDraw() {
        GLES20.glUniform1f((int)this.getHandle("brightness"), (float)this.brightness);
    }
}

