/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.media.AudioRecord;

public class AudioRecordUtil {
    private AudioRecord audioRecord;
    private int bufferSizeInBytes;
    private boolean isStarted = false;
    public static final int MAX_PACKAGE_SIZE = 4096;
    private OnRecordListener onRecordListener;
    private int mAudioSource;
    private int mSampleRate;
    private int mChannel;
    private int mAudioFormat;

    public void setOnRecordListener(OnRecordListener onRecordListener) {
        this.onRecordListener = onRecordListener;
    }

    public AudioRecordUtil(int audioSource, int sampleRate, int channel, int audioFormat) {
        this.mAudioSource = audioSource;
        this.mSampleRate = sampleRate;
        this.mChannel = channel;
        this.mAudioFormat = audioFormat;
        this.bufferSizeInBytes = AudioRecord.getMinBufferSize((int)this.mSampleRate, (int)this.mChannel, (int)this.mAudioFormat);
        this.audioRecord = new AudioRecord(this.mAudioSource, this.mSampleRate, this.mChannel, this.mAudioFormat, this.bufferSizeInBytes);
    }

    public void startRecord() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                AudioRecordUtil.this.isStarted = true;
                AudioRecordUtil.this.audioRecord.startRecording();
                byte[] audioData = new byte[AudioRecordUtil.this.bufferSizeInBytes];
                while (AudioRecordUtil.this.isStarted) {
                    int size = AudioRecordUtil.this.audioRecord.read(audioData, 0, AudioRecordUtil.this.bufferSizeInBytes);
                    int pkgCnt = size / 4096;
                    int leftBytesCnt = size % 4096;
                    for (int i = 0; i < pkgCnt; ++i) {
                        byte[] item = new byte[4096];
                        System.arraycopy(audioData, i * 4096, item, 0, 4096);
                        if (AudioRecordUtil.this.onRecordListener == null) continue;
                        AudioRecordUtil.this.onRecordListener.recordBytes(item, 4096);
                    }
                    if (leftBytesCnt <= 0) continue;
                    byte[] leftBytes = new byte[leftBytesCnt];
                    int offset = pkgCnt * 4096;
                    System.arraycopy(audioData, offset, leftBytes, 0, leftBytesCnt);
                    if (AudioRecordUtil.this.onRecordListener == null) continue;
                    AudioRecordUtil.this.onRecordListener.recordBytes(leftBytes, leftBytesCnt);
                }
            }
        });
        thread.start();
    }

    public void stopRecord() {
        this.isStarted = false;
        if (this.audioRecord != null) {
            this.audioRecord.stop();
            this.audioRecord.release();
            this.audioRecord = null;
        }
    }

    public static interface OnRecordListener {
        public void recordBytes(byte[] var1, int var2);
    }
}

