/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc;

import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.core.DataChannel;
import cn.rongcloud.rtc.core.IceCandidate;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.MediaConstraints;
import cn.rongcloud.rtc.core.MediaStream;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.PeerConnection;
import cn.rongcloud.rtc.core.RtpReceiver;
import cn.rongcloud.rtc.core.RtpSender;
import cn.rongcloud.rtc.core.RtpTransceiver;
import cn.rongcloud.rtc.core.SdpObserver;
import cn.rongcloud.rtc.core.SessionDescription;
import cn.rongcloud.rtc.core.StatsObserver;
import cn.rongcloud.rtc.crypto.CustomAudioFrameDecryptor;
import cn.rongcloud.rtc.crypto.CustomFrameDecryptorFactory;
import cn.rongcloud.rtc.crypto.CustomFrameEncryptorFactory;
import cn.rongcloud.rtc.crypto.CustomVideoFrameDecryptor;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.RTCSDPTools;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.webrtc.PeerConnectionFactoryHolder;
import cn.rongcloud.rtc.webrtc.RTCConnectionEvents;
import cn.rongcloud.rtc.webrtc.RTCLocalSdpObserver;
import cn.rongcloud.rtc.webrtc.RTCRemoteSdpObserver;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;

public class RTCConnectionHolder {
    private static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private static final String TAG = "RTCConnectionHolder";
    private final PCObserver pcObserver = new PCObserver();
    private PeerConnection mConnection;
    private PeerConnectionFactoryHolder factory;
    private RCRTCConfigImpl mRTCConfig;
    private RTCConnectionEvents events;
    private Object mConnectionLock = new Object();
    private boolean everOfferIsCreated;
    private Map<String, RtpSender> cachedRtpSenders = new HashMap<String, RtpSender>();

    public RTCConnectionHolder(PeerConnectionFactoryHolder factoryHandler, RCRTCConfigImpl rtcConfig, RTCConnectionEvents events) {
        this.factory = factoryHandler;
        this.mRTCConfig = rtcConfig;
        this.events = events;
        this.createRongRTCConnectionInternal();
    }

    private void createRongRTCConnectionInternal() {
        FinLog.d(TAG, "Create RongRTC connection.");
        MediaConstraints pcConstraints = new MediaConstraints();
        ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
        rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.ENABLED;
        rtcConfig.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
        rtcConfig.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        rtcConfig.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_CONTINUALLY;
        rtcConfig.keyType = PeerConnection.KeyType.ECDSA;
        if (this.mRTCConfig.isSRTPEnable()) {
            rtcConfig.enableDtlsSrtp = Boolean.TRUE;
            pcConstraints.optional.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, String.valueOf(true)));
            FinLog.d(TAG, "DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT= " + String.valueOf(true));
        } else {
            rtcConfig.enableDtlsSrtp = Boolean.FALSE;
            pcConstraints.optional.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, String.valueOf(false)));
            FinLog.d(TAG, "DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT= " + String.valueOf(false));
        }
        this.mConnection = this.factory.createPeerConnection(rtcConfig, pcConstraints, this.pcObserver);
        FinLog.d(TAG, "RongRTC connection created." + this.mConnection);
        Logging.enableTracing("logcat:", EnumSet.of(Logging.TraceLevel.TRACE_DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPublishedStreamSize() {
        Object object = this.mConnectionLock;
        synchronized (object) {
            if (this.isAvailable()) {
                return this.mConnection.getStreamSize();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addStream(MediaStream stream) {
        Object object = this.mConnectionLock;
        synchronized (object) {
            if (this.isAvailable()) {
                if (this.mConnection.containStream(stream)) {
                    return true;
                }
                return this.mConnection.addStream(stream);
            }
            return false;
        }
    }

    public void bindStreamEncryption(MediaStreamTrack mediaStreamTrack, String mediaStreamId) {
        if (this.mRTCConfig.isAudioEncryptionEnable() && "audio".equals(mediaStreamTrack.kind())) {
            this.setRtpSenderAudioEncryptor(mediaStreamTrack.id(), mediaStreamId);
            return;
        }
        if (this.mRTCConfig.isVideoEncryptionEnable() && "video".equals(mediaStreamTrack.kind())) {
            this.setRtpSenderVideoEncryptor(mediaStreamTrack.id(), mediaStreamId);
        }
    }

    private void setRtpSenderAudioEncryptor(String trackId, String mediaStreamId) {
        if (this.mRTCConfig.isAudioEncryptionEnable()) {
            RtpSender rtpSender;
            CustomFrameEncryptorFactory customFrameEncryptorFactory = CustomFrameEncryptorFactory.getInstance();
            if (CustomFrameEncryptorFactory.getInstance() != null && (rtpSender = this.getSendersByTrackId(trackId)) != null) {
                FinLog.i(TAG, "custom_crypto audio setCustomFrameEncryptor");
                rtpSender.setCustomFrameEncryptor(customFrameEncryptorFactory.createCustomAudioFrameEncryptor(rtpSender.track().kind(), rtpSender.track().id(), mediaStreamId));
            }
        }
    }

    private void setRtpSenderVideoEncryptor(String trackId, String mediaStreamId) {
        if (this.mRTCConfig.isVideoEncryptionEnable()) {
            RtpSender rtpSender;
            CustomFrameEncryptorFactory customFrameEncryptorFactory = CustomFrameEncryptorFactory.getInstance();
            if (CustomFrameEncryptorFactory.getInstance() != null && (rtpSender = this.getSendersByTrackId(trackId)) != null) {
                FinLog.i(TAG, "custom_crypto video setCustomFrameEncryptor");
                rtpSender.setCustomFrameEncryptor(customFrameEncryptorFactory.createCustomVideoFrameEncryptor(rtpSender.track().kind(), rtpSender.track().id(), mediaStreamId));
            }
        }
    }

    private RtpSender getSendersByTrackId(String trackId) {
        List<RtpSender> senders = this.getCurrentSenders();
        if (senders != null) {
            for (RtpSender rtpSender : senders) {
                if (rtpSender.track().id().equals(trackId)) {
                    this.cachedRtpSenders.put(trackId, rtpSender);
                    continue;
                }
                rtpSender.dispose();
            }
            return this.cachedRtpSenders.get(trackId);
        }
        return null;
    }

    private List<RtpSender> getCurrentSenders() {
        if (this.isAvailable()) {
            return this.mConnection.getCurrentSenders();
        }
        return null;
    }

    private void releaseCachedRtpSenders() {
        for (String trackId : this.cachedRtpSenders.keySet()) {
            RtpSender sender = this.cachedRtpSenders.get(trackId);
            sender.dispose();
        }
        this.cachedRtpSenders.clear();
        this.cachedRtpSenders = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStream getMediaStream(String streamId) {
        Object object = this.mConnectionLock;
        synchronized (object) {
            if (this.isAvailable()) {
                return this.mConnection.getStream(streamId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStream(MediaStream mediaStream) {
        Object object = this.mConnectionLock;
        synchronized (object) {
            if (this.isAvailable()) {
                this.mConnection.removeStream(mediaStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        FinLog.d(TAG, "release start");
        this.events = null;
        Object object = this.mConnectionLock;
        synchronized (object) {
            if (!this.isAvailable()) {
                FinLog.d(TAG, "PeerConnection Not Available");
                return;
            }
            FinLog.d(TAG, "real release PeerConnection");
            if (this.mConnection != null) {
                this.mConnection.dispose();
            }
            this.releaseCachedRtpSenders();
            CustomFrameDecryptorFactory.getInstance().release();
            CustomFrameEncryptorFactory.getInstance().release();
            this.everOfferIsCreated = false;
        }
        FinLog.d(TAG, "release end");
    }

    public boolean everOfferIsCreated() {
        return this.everOfferIsCreated;
    }

    public boolean isAvailable() {
        return this.mConnection != null && !this.mConnection.isClose();
    }

    public AsyncResult<SessionDescription> syncCreateAndSetOffer(final String roomId, final boolean restartIce, int totalMaxBitRate) {
        final AsyncResult.TemporaryResult res = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        if (restartIce) {
            ReportUtil.libTask(ReportUtil.TAG.RESETICE, "roomId", roomId);
        }
        this.createAndSetOffer(roomId, restartIce, totalMaxBitRate, new IRCRTCResultDataCallback<SessionDescription>(){

            @Override
            public void onSuccess(SessionDescription data) {
                if (restartIce) {
                    ReportUtil.libRes(ReportUtil.TAG.RESETICE, "code|roomId", 0, roomId);
                }
                res.setAndNotify(data);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                if (restartIce) {
                    ReportUtil.libError(ReportUtil.TAG.RESETICE, true, "roomId|code|desc", roomId, errorCode.getValue(), errorCode.getReason());
                }
                res.setAndNotify(errorCode);
            }
        });
        return res.waitForGetResult();
    }

    public void createAndSetOffer(String roomId, boolean restartIce, int totalMaxBitRate, final IRCRTCResultDataCallback<SessionDescription> callback) {
        ReportUtil.libTask(ReportUtil.TAG.CREATEOFFER, "restartIce", restartIce);
        PeerConnection connection = this.mConnection;
        if (!this.isAvailable()) {
            ReportUtil.libError(ReportUtil.TAG.CREATEOFFER, "code|errorMsg", RTCErrorCode.RongRTCCodeRTCConnectionIsNull.getValue(), "PeerConnection Is Null");
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeRTCConnectionIsNull);
            }
            return;
        }
        FinLog.d(TAG, " Create OFFER");
        RTCLocalSdpObserver rongRTCLocalSdpObserver = new RTCLocalSdpObserver(roomId, this.mRTCConfig, connection, totalMaxBitRate, new RTCLocalSdpObserver.RTCSdpLocalSetListener(){

            @Override
            public void onLocalSdpSetSuccess(SessionDescription sessionDescription) {
                RTCSDPTools.resetLocalUserIdTrackIdMap(sessionDescription.description);
                if (callback != null) {
                    callback.onSuccess(sessionDescription);
                }
            }

            @Override
            public void onLocalSetError(String error) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.RongRTCCodeSessionNegotiateOfferError);
                }
            }
        });
        if (this.isAvailable()) {
            connection.createOffer(rongRTCLocalSdpObserver, this.getSdpMediaConstraints(restartIce));
        } else {
            ReportUtil.libError(ReportUtil.TAG.CREATEOFFER, "code|errorMsg", RTCErrorCode.RongRTCCodeRTCConnectionIsNull.getValue(), "PeerConnection Is Released");
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeRTCConnectionIsNull);
            }
        }
    }

    private MediaConstraints getSdpMediaConstraints(boolean iceRestart) {
        MediaConstraints sdpMediaConstraints = new MediaConstraints();
        sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
        sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        if (iceRestart) {
            sdpMediaConstraints.optional.add(new MediaConstraints.KeyValuePair("IceRestart", "true"));
        } else {
            sdpMediaConstraints.optional.add(new MediaConstraints.KeyValuePair("IceRestart", "false"));
        }
        return sdpMediaConstraints;
    }

    public AsyncResult syncSetRemoteDescription(SessionDescription sdp, int totalMaxBitRate, int totalMinBitRate, int tinyMinBitrate, int tinyMaxBitrate) {
        final AsyncResult.TemporaryResult res = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        this.onSetRemoteDescription(sdp, totalMaxBitRate, totalMinBitRate, tinyMinBitrate, tinyMaxBitrate, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                FinLog.d(RTCConnectionHolder.TAG, "syncSetRemoteDescription onSuccess");
                res.setAndNotify(null);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.e(RTCConnectionHolder.TAG, "syncSetRemoteDescription onFailed");
                res.setAndNotify(errorCode);
            }
        });
        return res.waitForGetResult();
    }

    public synchronized void onSetRemoteDescription(SessionDescription sdp, int totalMaxBitRate, int totalMinBitRate, int tinyMinBitrate, int tinyMaxBitrate, final IRCRTCResultCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.SETREMOTESDP, "desc", "setRemoteSDP");
        PeerConnection connection = this.mConnection;
        if (!this.isAvailable() && connection != null) {
            FinLog.e(TAG, "blinkConnection == null\uff0cgive up the setRemoteDescription");
            ReportUtil.libError(ReportUtil.TAG.SETREMOTESDP, "code|errorMsg", RTCErrorCode.RongRTCCodeRTCConnectionIsNull.getValue(), "PeerConnection Is Null or Closing");
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeRTCConnectionIsNull);
            }
            return;
        }
        String sdpDescription = sdp.description;
        sdpDescription = RTCSDPTools.preferRemoteCodec(sdpDescription, "H264", false, totalMaxBitRate, totalMinBitRate, tinyMinBitrate, tinyMaxBitrate);
        FinLog.d(TAG, "audioConfig: audio option for remote sdp audio bitrate : " + this.mRTCConfig.getAudioBitrate() + " , codecType :" + this.mRTCConfig.getAudioCodecType().name());
        sdpDescription = RTCSDPTools.preferRemoteCodec(sdpDescription, this.mRTCConfig.getAudioCodecType().name(), true, this.mRTCConfig.getAudioBitrate(), totalMinBitRate, tinyMinBitrate, tinyMaxBitrate);
        if (this.mRTCConfig.getAudioBitrate() > 0 || this.mRTCConfig.isStereo()) {
            sdpDescription = RTCSDPTools.setStartBitrate("opus", false, sdpDescription, this.mRTCConfig.getAudioBitrate(), this.mRTCConfig.isStereo());
        }
        final SessionDescription sdpRemote = new SessionDescription(sdp.type, sdpDescription);
        FinLog.i(TAG, "setRemoteDescription: \r\n" + sdpRemote.description);
        RTCRemoteSdpObserver rongRTCRemoteSdpObserver = new RTCRemoteSdpObserver(sdpRemote, new RTCRemoteSdpObserver.SdpSetRemoteListener(){

            @Override
            public void onRemoteSdpSetSuccess() {
                RTCConnectionHolder.this.everOfferIsCreated = true;
                RTCSDPTools.resetRemoteUserIdTrackIdMap(sdpRemote.description);
                callback.onSuccess();
            }

            @Override
            public void onRemoteSetError(String error) {
                callback.onFailed(RTCErrorCode.RongRTCCodeSessionNegotiateSetRemoteError);
            }
        });
        if (this.isAvailable()) {
            connection.setRemoteDescription(rongRTCRemoteSdpObserver, sdpRemote);
        } else {
            ReportUtil.libError(ReportUtil.TAG.SETREMOTESDP, "code|errorMsg", RTCErrorCode.RongRTCCodeRTCConnectionIsNull.getValue(), "PeerConnection Is Null or Released");
            callback.onFailed(RTCErrorCode.RongRTCCodeRTCConnectionIsNull);
        }
    }

    public AsyncResult syncCreateAnswer(String roomId) {
        final AsyncResult.TemporaryResult res = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        ReportUtil.libTask(ReportUtil.TAG.CREATEANSWER, "roomId", roomId);
        if (this.isAvailable()) {
            this.mConnection.createAnswer(new AnswerSdpObserver(roomId, new IRCRTCResultCallback(){

                @Override
                public void onSuccess() {
                    res.setAndNotify(null);
                }

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    res.setAndNotify(errorCode);
                }
            }), this.getSdpMediaConstraints(false));
            LockSupport.park();
        } else {
            res.setAndNotify(RTCErrorCode.RongRTCCodeRTCTokenIsNull);
            ReportUtil.libError(ReportUtil.TAG.CREATEANSWER, "code|errorMsg", RTCErrorCode.RongRTCCodeRTCConnectionIsNull.getValue(), "PeerConnection Is Released");
        }
        return res.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getStatus(StatsObserver observer) {
        Object object = this.mConnectionLock;
        synchronized (object) {
            if (this.isAvailable()) {
                return this.mConnection.getStats(observer, null);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMcuVolume(StatsObserver observer, long ssrc) {
        Object object = this.mConnectionLock;
        synchronized (object) {
            if (this.isAvailable()) {
                this.mConnection.getMcuVolume(observer, ssrc);
            }
        }
    }

    public class PCObserver
    implements PeerConnection.Observer {
        @Override
        public void onIceCandidate(IceCandidate candidate) {
            RTCConnectionEvents events = RTCConnectionHolder.this.events;
            if (events != null) {
                events.onIceCandidate(candidate);
            }
        }

        @Override
        public void onIceCandidatesRemoved(IceCandidate[] candidates) {
            RTCConnectionEvents events = RTCConnectionHolder.this.events;
            if (events != null) {
                events.onIceCandidatesRemoved(candidates);
            }
        }

        @Override
        public void onSignalingChange(PeerConnection.SignalingState newState) {
            FinLog.d(RTCConnectionHolder.TAG, "SignalingState: " + (Object)((Object)newState));
        }

        @Override
        public void onIceConnectionChange(PeerConnection.IceConnectionState newState) {
            ReportUtil.libStatus(ReportUtil.TAG.ONICECONNECTIONCHANGE, "state", new Object[]{newState});
            RTCConnectionEvents events = RTCConnectionHolder.this.events;
            if (events != null) {
                if (newState == PeerConnection.IceConnectionState.CONNECTED) {
                    events.onIceConnected();
                } else if (newState == PeerConnection.IceConnectionState.FAILED || newState == PeerConnection.IceConnectionState.DISCONNECTED) {
                    events.onIceDisconnected();
                } else if (newState == PeerConnection.IceConnectionState.CHECKING) {
                    events.onIceChecking();
                }
            }
        }

        @Override
        public void onConnectionChange(PeerConnection.PeerConnectionState newState) {
        }

        @Override
        public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
            FinLog.d(RTCConnectionHolder.TAG, "IceGatheringState: " + (Object)((Object)newState));
        }

        @Override
        public void onIceConnectionReceivingChange(boolean receiving) {
            FinLog.d(RTCConnectionHolder.TAG, "IceConnectionReceiving changed to " + receiving);
        }

        @Override
        public void onAddStream(MediaStream stream) {
        }

        @Override
        public void onRemoveStream(MediaStream stream) {
            ReportUtil.libStatus(ReportUtil.TAG.ONREMOVEREMOTESTREAM, "streamId", stream.getId());
            RTCConnectionEvents events = RTCConnectionHolder.this.events;
            if (stream.audioTracks.size() != 0) {
                CustomFrameDecryptorFactory.getInstance().releaseAudioDecryptor(stream.audioTracks.get(0).id());
            }
            if (stream.videoTracks.size() != 0) {
                CustomFrameDecryptorFactory.getInstance().releaseVideoDecryptor(stream.videoTracks.get(0).id());
            }
        }

        @Override
        public void onDataChannel(DataChannel dc) {
            RTCConnectionEvents events = RTCConnectionHolder.this.events;
            if (events != null) {
                events.onRTCConnectionError("AppRTC doesn't use data channels, but got: " + dc.label() + " anyway!");
            }
        }

        @Override
        public void onRenegotiationNeeded() {
        }

        @Override
        public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
            CustomFrameDecryptorFactory customFrameDecryptorFactory;
            MediaStreamTrack track;
            RTCConnectionEvents events = RTCConnectionHolder.this.events;
            if (events != null) {
                events.onAddTrack(receiver, mediaStreams);
            }
            if ("audio".equals((track = receiver.track()).kind()) && mediaStreams != null && mediaStreams.length != 0) {
                FinLog.i(RTCConnectionHolder.TAG, "custom_crypto rtpReceiver audio recv track id:" + receiver.track().id() + " stream:" + mediaStreams[0].getId());
                if (RTCConnectionHolder.this.mRTCConfig.isAudioEncryptionEnable()) {
                    customFrameDecryptorFactory = CustomFrameDecryptorFactory.getInstance();
                    CustomAudioFrameDecryptor customAudioFrameCrypto = customFrameDecryptorFactory.createCustomAudioFrameDecryptor(receiver.track().kind(), receiver.track().id(), mediaStreams[0].getId());
                    receiver.setCustomFrameDecryptor(customAudioFrameCrypto);
                    receiver.setDisposeObserver(customFrameDecryptorFactory);
                    FinLog.i(RTCConnectionHolder.TAG, "custom_crypto rtpReceiver setCustomFrameDecryptor audio");
                }
            }
            if ("video".equals(track.kind()) && mediaStreams != null && mediaStreams.length != 0) {
                FinLog.i(RTCConnectionHolder.TAG, "custom_crypto rtpReceiver video recv track id:" + receiver.track().id() + " stream:" + mediaStreams[0].getId());
                if (RTCConnectionHolder.this.mRTCConfig.isVideoEncryptionEnable()) {
                    customFrameDecryptorFactory = CustomFrameDecryptorFactory.getInstance();
                    CustomVideoFrameDecryptor customVideoFrameDecryptor = customFrameDecryptorFactory.createCustomVideoFrameDecryptor(receiver.track().kind(), receiver.track().id(), mediaStreams[0].getId());
                    receiver.setCustomFrameDecryptor(customVideoFrameDecryptor);
                    receiver.setDisposeObserver(customFrameDecryptorFactory);
                    FinLog.i(RTCConnectionHolder.TAG, "custom_crypto setCustomFrameDecryptor video");
                }
            }
        }

        @Override
        public void onTrack(RtpTransceiver transceiver) {
        }
    }

    private class AnswerSdpObserver
    implements SdpObserver {
        private SessionDescription mAnswerSDP;
        private String mRoomId;
        private IRCRTCResultCallback mCallback;

        public AnswerSdpObserver(String roomId, IRCRTCResultCallback callback) {
            this.mRoomId = roomId;
            this.mCallback = callback;
        }

        @Override
        public void onCreateSuccess(SessionDescription sdp) {
            ReportUtil.libRes(ReportUtil.TAG.CREATEANSWER, "code", 0);
            ReportUtil.libTask(ReportUtil.TAG.SETLOCALSDP, "roomId", this.mRoomId);
            AnswerSdpObserver observer = new AnswerSdpObserver(this.mRoomId, this.mCallback);
            observer.mAnswerSDP = sdp;
            if (RTCConnectionHolder.this.isAvailable()) {
                String sdpDescription = sdp.description;
                if (RTCConnectionHolder.this.mRTCConfig.getAudioBitrate() > 0 || RTCConnectionHolder.this.mRTCConfig.isStereo()) {
                    sdpDescription = RTCSDPTools.setStartBitrate("opus", false, sdpDescription, RTCConnectionHolder.this.mRTCConfig.getAudioBitrate(), RTCConnectionHolder.this.mRTCConfig.isStereo());
                }
                SessionDescription sessionDescription = new SessionDescription(sdp.type, sdpDescription);
                FinLog.i(RTCConnectionHolder.TAG, "setLocalDescription: " + (Object)((Object)sdp.type) + "\r\n" + sdpDescription);
                RTCSDPTools.resetLocalUserIdTrackIdMap(sessionDescription.description);
                RTCConnectionHolder.this.mConnection.setLocalDescription(observer, sessionDescription);
            } else {
                ReportUtil.libError(ReportUtil.TAG.SETLOCALSDP, "code|desc|sdp", RTCErrorCode.RongRTCCodeRTCConnectionIsNull.getValue(), RTCErrorCode.RongRTCCodeRTCConnectionIsNull.getReason(), this.mAnswerSDP);
                this.mCallback.onFailed(RTCErrorCode.RongRTCCodeRTCConnectionIsNull);
            }
        }

        @Override
        public void onSetSuccess() {
            ReportUtil.libRes(ReportUtil.TAG.SETLOCALSDP, "code", 0);
            this.mCallback.onSuccess();
        }

        @Override
        public void onCreateFailure(String error) {
            ReportUtil.libError(ReportUtil.TAG.CREATEANSWER, "code|desc", RTCErrorCode.CREATE_ANSWER_FAILURE.getValue(), error);
            this.mCallback.onFailed(RTCErrorCode.CREATE_ANSWER_FAILURE);
        }

        @Override
        public void onSetFailure(String error) {
            ReportUtil.libError(ReportUtil.TAG.SETLOCALSDP, "code|desc|sdp", RTCErrorCode.RongRTCCodeSessionNegotiateOfferError.getValue(), error, this.mAnswerSDP);
            this.mCallback.onFailed(RTCErrorCode.RongRTCCodeSessionNegotiateOfferError);
        }
    }
}

