/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.config;

import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.center.config.RCConfigDefaultValues;
import cn.rongcloud.rtc.center.config.RCConfigField;
import cn.rongcloud.rtc.center.config.RCServerConfig;

public class RCVideoConfigImpl
implements RCRTCVideoStreamConfig {
    private RCConfigField<Integer> maxRate = RCConfigField.create(RCConfigDefaultValues.VIDEO_RESOLUTION.getMaxBitRate());
    private RCConfigField<Integer> minRate = RCConfigField.create(RCConfigDefaultValues.VIDEO_RESOLUTION.getMinBitRate());
    private RCConfigField<RCRTCParamsType.RCRTCVideoFps> videoFps = RCConfigField.create(RCConfigDefaultValues.VIDEO_FPS);
    private RCConfigField<RCRTCParamsType.RCRTCVideoResolution> videoResolution = RCConfigField.create(RCConfigDefaultValues.VIDEO_RESOLUTION);

    @Override
    public int getMaxRate() {
        if (this.maxRate.getValue() <= 0) {
            return this.videoResolution.getValue().getMaxBitRate();
        }
        return this.maxRate.getValue();
    }

    @Override
    public int getMinRate() {
        if (this.minRate.getValue() <= 0) {
            return this.videoResolution.getValue().getMinBitRate();
        }
        return this.minRate.getValue();
    }

    @Override
    public RCRTCParamsType.RCRTCVideoFps getVideoFps() {
        if (this.videoFps.getValue().getFps() <= 0) {
            return RCConfigDefaultValues.VIDEO_FPS;
        }
        return this.videoFps.getValue();
    }

    private void updateServerConfig() {
        this.maxRate.setServerValue(RCServerConfig.getMaxRate());
        this.minRate.setServerValue(RCServerConfig.getMinRate());
        this.videoFps.setServerValue(RCRTCParamsType.RCRTCVideoFps.parseVideoFps(RCServerConfig.getVideoFPS()));
        RCRTCParamsType.RCRTCVideoResolution resolution = RCRTCParamsType.RCRTCVideoResolution.getVideoResolution(RCServerConfig.getVideoWidth(), RCServerConfig.getVideoHeight());
        this.videoResolution.setServerValue(resolution == RCRTCParamsType.RCRTCVideoResolution.RESOLUTION_INVALID ? RCConfigDefaultValues.VIDEO_RESOLUTION : resolution);
    }

    @Override
    public RCRTCParamsType.RCRTCVideoResolution getVideoResolution() {
        return this.videoResolution.getValue();
    }

    @Override
    public boolean equalsEx(RCRTCVideoStreamConfig videoStreamConfig) {
        return videoStreamConfig == null ? false : this.getMinRate() == videoStreamConfig.getMinRate() && this.getMaxRate() == videoStreamConfig.getMaxRate() && this.getVideoFps() == videoStreamConfig.getVideoFps() && this.getVideoResolution() == videoStreamConfig.getVideoResolution();
    }

    public String formatLogString() {
        return "{maxRate=" + this.maxRate.getValue() + ", minRate=" + this.minRate.getValue() + ", videoFps=" + (Object)((Object)this.videoFps.getValue()) + ", videoResolution=" + (Object)((Object)this.videoResolution.getValue()) + '}';
    }

    public static class Builder
    extends RCRTCVideoStreamConfig.Builder {
        RCVideoConfigImpl config = new RCVideoConfigImpl();

        @Override
        public RCRTCVideoStreamConfig build() {
            this.config.updateServerConfig();
            return this.config;
        }

        @Override
        public RCRTCVideoStreamConfig.Builder setMaxRate(int maxRate) {
            this.config.maxRate.setLocalValue(maxRate);
            return this;
        }

        @Override
        public RCRTCVideoStreamConfig.Builder setMinRate(int minRate) {
            this.config.minRate.setLocalValue(minRate);
            return this;
        }

        @Override
        public RCRTCVideoStreamConfig.Builder setVideoFps(RCRTCParamsType.RCRTCVideoFps videoFps) {
            this.config.videoFps.setLocalValue(videoFps);
            return this;
        }

        @Override
        public RCRTCVideoStreamConfig.Builder setVideoResolution(RCRTCParamsType.RCRTCVideoResolution videoResolution) {
            this.config.videoResolution.setLocalValue(videoResolution);
            return this;
        }
    }
}

