/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.handler;

import com.ksyun.ks3.exception.Ks3Error;
import com.ksyun.ks3.model.Bucket;
import com.ksyun.ks3.model.Owner;
import com.ksyun.ks3.services.handler.Ks3HttpResponceHandler;
import com.ksyun.ks3.util.DateUtil;
import com.ksyun.ks3.util.StringUtils;
import cz.msebera.android.httpclient.Header;
import cz.msebera.android.httpclient.impl.cookie.DateParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class ListBucketsResponceHandler
extends Ks3HttpResponceHandler {
    private ArrayList<Bucket> result;
    private Owner owner;
    private Bucket bucket;

    public abstract void onFailure(int var1, Ks3Error var2, Header[] var3, String var4, Throwable var5);

    public abstract void onSuccess(int var1, Header[] var2, ArrayList<Bucket> var3);

    @Override
    public final void onFailure(int statesCode, Header[] responceHeaders, byte[] response, Throwable throwable) {
        Ks3Error error = new Ks3Error(statesCode, response, throwable);
        this.onFailure(statesCode, error, responceHeaders, response == null ? "" : new String(response), throwable);
    }

    @Override
    public final void onSuccess(int statesCode, Header[] responceHeaders, byte[] response) {
        ArrayList<Bucket> buckets = this.parseXml(responceHeaders, response);
        this.onSuccess(statesCode, responceHeaders, buckets);
    }

    @Override
    public final void onProgress(long bytesWritten, long totalSize) {
    }

    @Override
    public final void onStart() {
    }

    @Override
    public final void onFinish() {
    }

    @Override
    public final void onCancel() {
    }

    private ArrayList<Bucket> parseXml(Header[] responceHeaders, byte[] response) {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlPullParser parse = factory.newPullParser();
            parse.setInput((InputStream)new ByteArrayInputStream(response), "UTF-8");
            int eventType = parse.getEventType();
            while (1 != eventType) {
                String nodeName = parse.getName();
                switch (eventType) {
                    case 0: {
                        this.result = new ArrayList();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        String dateStr;
                        if (nodeName.equalsIgnoreCase("Owner")) {
                            this.owner = new Owner();
                        }
                        if (nodeName.equalsIgnoreCase("ID")) {
                            this.owner.setId(parse.nextText());
                        }
                        if (nodeName.equalsIgnoreCase("DisplayName")) {
                            this.owner.setDisplayName(parse.nextText());
                        }
                        if (nodeName.equalsIgnoreCase("Bucket")) {
                            this.bucket = new Bucket();
                        }
                        if (nodeName.equalsIgnoreCase("Name")) {
                            this.bucket.setName(parse.nextText());
                        }
                        if (!nodeName.equalsIgnoreCase("CreationDate") || StringUtils.isBlank(dateStr = parse.nextText())) break;
                        this.bucket.setCreationDate(DateUtil.ConverToDate(dateStr));
                        break;
                    }
                    case 3: {
                        if (!nodeName.equalsIgnoreCase("Bucket")) break;
                        this.bucket.setOwner(this.owner);
                        this.result.add(this.bucket);
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                eventType = parse.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DateParseException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.result;
    }
}

