/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.jni.audio;

import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.RLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RCAudioChannelHandler {
    private String TAG = "RCAudioChannelHandler";
    private long nativeAudioTrackJni = 0L;
    private int mKtvBufferSize = 0;
    private int mPlayBufferSize = 0;
    private ByteBuffer mKtvAudioDirectBuffer;
    private ByteBuffer mPlayAudioDirectBuffer;
    private final Object lock = new Object();

    public boolean isNativeAudioTrackInit() {
        return this.nativeAudioTrackJni != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAudioTrackHandler() {
        RLog.d((String)this.TAG, (String)"- createAudioTrackHandler()");
        Object object = this.lock;
        synchronized (object) {
            this.nativeAudioTrackJni = this.nativeCreateAudioTrackHandler();
        }
        ReportUtil.libStatus(ReportUtil.TAG.INITSWICTHAUDIOCHANNEL, "status", "- createAudioTrackHandler init");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] handleKtvTrackMode(byte[] pcmBuff, int mode) {
        Object object = this.lock;
        synchronized (object) {
            byte[] output = null;
            if (this.nativeAudioTrackJni != 0L && pcmBuff != null && pcmBuff.length > 0) {
                int length = pcmBuff.length;
                if (length != this.mKtvBufferSize) {
                    this.mKtvBufferSize = length;
                    this.mKtvAudioDirectBuffer = ByteBuffer.allocateDirect(this.mKtvBufferSize).order(ByteOrder.nativeOrder());
                    this.nativeCacheDirectBufferAddress(this.nativeAudioTrackJni, this.mKtvAudioDirectBuffer, 0);
                }
                this.mKtvAudioDirectBuffer.clear();
                this.mKtvAudioDirectBuffer.put(pcmBuff);
                int retSize = this.nativeHandleKtvTrackMode(this.nativeAudioTrackJni, mode, this.mKtvAudioDirectBuffer.capacity());
                if (retSize > 0) {
                    output = new byte[retSize];
                    this.mKtvAudioDirectBuffer.clear();
                    this.mKtvAudioDirectBuffer.get(output);
                }
            } else {
                return pcmBuff;
            }
            return output;
        }
    }

    public byte[] handlePlayTrackMode(byte[] pcmBuff, int mode) {
        byte[] output = null;
        if (this.nativeAudioTrackJni != 0L && pcmBuff != null && pcmBuff.length > 0) {
            int length = pcmBuff.length;
            if (length != this.mPlayBufferSize) {
                this.mPlayBufferSize = length;
                this.mPlayAudioDirectBuffer = ByteBuffer.allocateDirect(this.mPlayBufferSize).order(ByteOrder.nativeOrder());
                this.nativeCacheDirectBufferAddress(this.nativeAudioTrackJni, this.mPlayAudioDirectBuffer, 1);
            }
            this.mPlayAudioDirectBuffer.clear();
            this.mPlayAudioDirectBuffer.put(pcmBuff);
            int retSize = this.nativeHandlePlayTrackMode(this.nativeAudioTrackJni, mode, this.mPlayAudioDirectBuffer.capacity());
            if (retSize > 0) {
                output = new byte[retSize];
                this.mPlayAudioDirectBuffer.clear();
                this.mPlayAudioDirectBuffer.get(output);
            }
        } else {
            return pcmBuff;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAudioTrackHandler() {
        RLog.d((String)this.TAG, (String)("- destroyAudioTrackHandler() nativeAudioTrackJni:" + this.nativeAudioTrackJni));
        Object object = this.lock;
        synchronized (object) {
            if (this.nativeAudioTrackJni != 0L) {
                this.nativeDestroyAudioTrackHandler(this.nativeAudioTrackJni);
            }
            this.nativeAudioTrackJni = 0L;
            this.mKtvBufferSize = 0;
            this.mPlayBufferSize = 0;
            if (this.mKtvAudioDirectBuffer != null) {
                this.mKtvAudioDirectBuffer.clear();
                this.mKtvAudioDirectBuffer = null;
            }
            if (this.mPlayAudioDirectBuffer != null) {
                this.mPlayAudioDirectBuffer.clear();
                this.mPlayAudioDirectBuffer = null;
            }
        }
        ReportUtil.libStatus(ReportUtil.TAG.DESTROYSWICTHAUDIOCHANNEL, "status", "- destroyAudioTrackHandler unInit");
    }

    private native long nativeCreateAudioTrackHandler();

    private native void nativeCacheDirectBufferAddress(long var1, ByteBuffer var3, int var4);

    private native int nativeHandleKtvTrackMode(long var1, int var3, int var4);

    private native int nativeHandlePlayTrackMode(long var1, int var3, int var4);

    private native void nativeDestroyAudioTrackHandler(long var1);
}

