/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.filter;

import android.content.res.Resources;
import android.opengl.GLES20;
import com.daasuu.mp4compose.gl.GlFramebufferObject;
import com.daasuu.mp4compose.utils.EglUtil;
import java.util.HashMap;

public class GlFilter {
    public static final String DEFAULT_UNIFORM_SAMPLER = "sTexture";
    protected static final String DEFAULT_VERTEX_SHADER = "attribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\ngl_Position = aPosition;\nvTextureCoord = aTextureCoord.xy;\n}\n";
    protected static final String DEFAULT_FRAGMENT_SHADER = "precision mediump float;\nvarying highp vec2 vTextureCoord;\nuniform lowp sampler2D sTexture;\nvoid main() {\ngl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final float[] VERTICES_DATA = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f};
    private static final int FLOAT_SIZE_BYTES = 4;
    protected static final int VERTICES_DATA_POS_SIZE = 3;
    protected static final int VERTICES_DATA_UV_SIZE = 2;
    protected static final int VERTICES_DATA_STRIDE_BYTES = 20;
    protected static final int VERTICES_DATA_POS_OFFSET = 0;
    protected static final int VERTICES_DATA_UV_OFFSET = 12;
    private final String vertexShaderSource;
    private String fragmentShaderSource;
    private int program;
    private int vertexShader;
    private int fragmentShader;
    private int vertexBufferName;
    private final HashMap<String, Integer> handleMap = new HashMap();
    private float[] clearColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};

    public GlFilter() {
        this(DEFAULT_VERTEX_SHADER, DEFAULT_FRAGMENT_SHADER);
    }

    public GlFilter(Resources res, int vertexShaderSourceResId, int fragmentShaderSourceResId) {
        this(res.getString(vertexShaderSourceResId), res.getString(fragmentShaderSourceResId));
    }

    public GlFilter(String vertexShaderSource, String fragmentShaderSource) {
        this.vertexShaderSource = vertexShaderSource;
        this.fragmentShaderSource = fragmentShaderSource;
    }

    public void setup() {
        this.release();
        this.vertexShader = EglUtil.loadShader(this.vertexShaderSource, 35633);
        this.fragmentShader = EglUtil.loadShader(this.fragmentShaderSource, 35632);
        this.program = EglUtil.createProgram(this.vertexShader, this.fragmentShader);
        this.vertexBufferName = EglUtil.createBuffer(VERTICES_DATA);
        this.getHandle("aPosition");
        this.getHandle("aTextureCoord");
        this.getHandle(DEFAULT_UNIFORM_SAMPLER);
    }

    public void setFragmentShaderSource(String fragmentShaderSource) {
        this.fragmentShaderSource = fragmentShaderSource;
    }

    public void setFrameSize(int width, int height) {
    }

    public void release() {
        GLES20.glDeleteProgram((int)this.program);
        this.program = 0;
        GLES20.glDeleteShader((int)this.vertexShader);
        this.vertexShader = 0;
        GLES20.glDeleteShader((int)this.fragmentShader);
        this.fragmentShader = 0;
        GLES20.glDeleteBuffers((int)1, (int[])new int[]{this.vertexBufferName}, (int)0);
        this.vertexBufferName = 0;
        this.handleMap.clear();
    }

    public void draw(int texName, GlFramebufferObject fbo) {
        this.useProgram();
        GLES20.glBindBuffer((int)34962, (int)this.vertexBufferName);
        GLES20.glEnableVertexAttribArray((int)this.getHandle("aPosition"));
        GLES20.glVertexAttribPointer((int)this.getHandle("aPosition"), (int)3, (int)5126, (boolean)false, (int)20, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.getHandle("aTextureCoord"));
        GLES20.glVertexAttribPointer((int)this.getHandle("aTextureCoord"), (int)2, (int)5126, (boolean)false, (int)20, (int)12);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)texName);
        GLES20.glUniform1i((int)this.getHandle(DEFAULT_UNIFORM_SAMPLER), (int)0);
        this.onDraw();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.getHandle("aPosition"));
        GLES20.glDisableVertexAttribArray((int)this.getHandle("aTextureCoord"));
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindBuffer((int)34962, (int)0);
    }

    protected void onDraw() {
    }

    protected final void useProgram() {
        GLES20.glUseProgram((int)this.program);
    }

    protected final int getVertexBufferName() {
        return this.vertexBufferName;
    }

    protected final int getHandle(String name) {
        Integer value = this.handleMap.get(name);
        if (value != null) {
            return value;
        }
        int location = GLES20.glGetAttribLocation((int)this.program, (String)name);
        if (location == -1) {
            location = GLES20.glGetUniformLocation((int)this.program, (String)name);
        }
        if (location == -1) {
            throw new IllegalStateException("Could not get attrib or uniform location for " + name);
        }
        this.handleMap.put(name, location);
        return location;
    }

    public float[] getClearColor() {
        return this.clearColor;
    }

    public void setClearColor(float red, float green, float blue, float alpha) {
        this.clearColor = new float[]{red, green, blue, alpha};
    }
}

