/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.text.TextUtils;
import android.util.SparseArray;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.DownloadTaskHunter;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.ITaskHunter;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadStatus;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.util.ArrayList;

public class DownloadTask
implements BaseDownloadTask,
BaseDownloadTask.IRunningTask,
DownloadTaskHunter.ICaptureTask {
    private final ITaskHunter mHunter;
    private final ITaskHunter.IMessageHandler mMessageHandler;
    private int mId;
    private ArrayList<BaseDownloadTask.FinishListener> mFinishListenerList;
    private final String mUrl;
    private String mPath;
    private String mFilename;
    private boolean mPathAsDirectory;
    private FileDownloadHeader mHeader;
    private FileDownloadListener mListener;
    private SparseArray<Object> mKeyedTags;
    private Object mTag;
    private int mAutoRetryTimes = 0;
    private boolean mSyncCallback = false;
    private boolean mIsWifiRequired = false;
    public static final int DEFAULT_CALLBACK_PROGRESS_MIN_INTERVAL_MILLIS = 10;
    private int mCallbackProgressTimes = 100;
    private int mCallbackProgressMinIntervalMillis = 10;
    private boolean mIsForceReDownload = false;
    volatile int mAttachKey = 0;
    private boolean mIsInQueueTask = false;
    private final Object mPauseLock;
    private final Object headerCreateLock = new Object();
    private volatile boolean mIsMarkedAdded2List = false;

    DownloadTask(String url) {
        this.mUrl = url;
        this.mPauseLock = new Object();
        DownloadTaskHunter hunter = new DownloadTaskHunter(this, this.mPauseLock);
        this.mHunter = hunter;
        this.mMessageHandler = hunter;
    }

    @Override
    public BaseDownloadTask setMinIntervalUpdateSpeed(int minIntervalUpdateSpeedMs) {
        this.mHunter.setMinIntervalUpdateSpeed(minIntervalUpdateSpeedMs);
        return this;
    }

    @Override
    public BaseDownloadTask setPath(String path) {
        return this.setPath(path, false);
    }

    @Override
    public BaseDownloadTask setPath(String path, boolean pathAsDirectory) {
        this.mPath = path;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "setPath %s", path);
        }
        this.mPathAsDirectory = pathAsDirectory;
        this.mFilename = pathAsDirectory ? null : new File(path).getName();
        return this;
    }

    @Override
    public BaseDownloadTask setListener(FileDownloadListener listener) {
        this.mListener = listener;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "setListener %s", listener);
        }
        return this;
    }

    @Override
    public BaseDownloadTask setCallbackProgressTimes(int callbackProgressCount) {
        this.mCallbackProgressTimes = callbackProgressCount;
        return this;
    }

    @Override
    public BaseDownloadTask setCallbackProgressMinInterval(int minIntervalMillis) {
        this.mCallbackProgressMinIntervalMillis = minIntervalMillis;
        return this;
    }

    @Override
    public BaseDownloadTask setCallbackProgressIgnored() {
        return this.setCallbackProgressTimes(-1);
    }

    @Override
    public BaseDownloadTask setTag(Object tag) {
        this.mTag = tag;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "setTag %s", tag);
        }
        return this;
    }

    @Override
    public BaseDownloadTask setTag(int key, Object tag) {
        if (this.mKeyedTags == null) {
            this.mKeyedTags = new SparseArray(2);
        }
        this.mKeyedTags.put(key, tag);
        return this;
    }

    @Override
    public BaseDownloadTask setForceReDownload(boolean isForceReDownload) {
        this.mIsForceReDownload = isForceReDownload;
        return this;
    }

    @Override
    public BaseDownloadTask setFinishListener(BaseDownloadTask.FinishListener finishListener) {
        this.addFinishListener(finishListener);
        return this;
    }

    @Override
    public BaseDownloadTask addFinishListener(BaseDownloadTask.FinishListener finishListener) {
        if (this.mFinishListenerList == null) {
            this.mFinishListenerList = new ArrayList();
        }
        if (!this.mFinishListenerList.contains(finishListener)) {
            this.mFinishListenerList.add(finishListener);
        }
        return this;
    }

    @Override
    public boolean removeFinishListener(BaseDownloadTask.FinishListener finishListener) {
        return this.mFinishListenerList != null && this.mFinishListenerList.remove(finishListener);
    }

    @Override
    public BaseDownloadTask setAutoRetryTimes(int autoRetryTimes) {
        this.mAutoRetryTimes = autoRetryTimes;
        return this;
    }

    @Override
    public BaseDownloadTask addHeader(String name, String value) {
        this.checkAndCreateHeader();
        this.mHeader.add(name, value);
        return this;
    }

    @Override
    public BaseDownloadTask addHeader(String line) {
        this.checkAndCreateHeader();
        this.mHeader.add(line);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseDownloadTask removeAllHeaders(String name) {
        if (this.mHeader == null) {
            Object object = this.headerCreateLock;
            synchronized (object) {
                if (this.mHeader == null) {
                    return this;
                }
            }
        }
        this.mHeader.removeAll(name);
        return this;
    }

    @Override
    public BaseDownloadTask setSyncCallback(boolean syncCallback) {
        this.mSyncCallback = syncCallback;
        return this;
    }

    @Override
    public BaseDownloadTask setWifiRequired(boolean isWifiRequired) {
        this.mIsWifiRequired = isWifiRequired;
        return this;
    }

    @Override
    public int ready() {
        return this.asInQueueTask().enqueue();
    }

    @Override
    public BaseDownloadTask.InQueueTask asInQueueTask() {
        return new InQueueTaskImpl(this);
    }

    @Override
    public boolean reuse() {
        if (this.isRunning()) {
            FileDownloadLog.w(this, "This task[%d] is running, if you want start the same task, please create a new one by FileDownloader#create", this.getId());
            return false;
        }
        this.mAttachKey = 0;
        this.mIsInQueueTask = false;
        this.mIsMarkedAdded2List = false;
        this.mHunter.reset();
        return true;
    }

    @Override
    public boolean isUsing() {
        return this.mHunter.getStatus() != 0;
    }

    @Override
    public boolean isRunning() {
        if (FileDownloader.getImpl().getLostConnectedHandler().isInWaitingList(this)) {
            return true;
        }
        return FileDownloadStatus.isIng(this.getStatus());
    }

    @Override
    public boolean isAttached() {
        return this.mAttachKey != 0;
    }

    @Override
    public int start() {
        if (this.mIsInQueueTask) {
            throw new IllegalStateException("If you start the task manually, it means this task doesn't belong to a queue, so you must not invoke BaseDownloadTask#ready() or InQueueTask#enqueue() before you start() this method. For detail: If this task doesn't belong to a queue, what is just an isolated task, you just need to invoke BaseDownloadTask#start() to start this task, that's all. In other words, If this task doesn't belong to a queue, you must not invoke BaseDownloadTask#ready() method or InQueueTask#enqueue() method before invoke BaseDownloadTask#start(), If you do that and if there is the same listener object to start a queue in another thread, this task may be assembled by the queue, in that case, when you invoke BaseDownloadTask#start() manually to start this task or this task is started by the queue, there is an exception buried in there, because this task object is started two times without declare BaseDownloadTask#reuse() : 1. you invoke BaseDownloadTask#start() manually;  2. the queue start this task automatically.");
        }
        return this.startTaskUnchecked();
    }

    private int startTaskUnchecked() {
        if (this.isUsing()) {
            if (this.isRunning()) {
                throw new IllegalStateException(FileDownloadUtils.formatString("This task is running %d, if you want to start the same task, please create a new one by FileDownloader.create", this.getId()));
            }
            throw new IllegalStateException("This task is dirty to restart, If you want to reuse this task, please invoke #reuse method manually and retry to restart again." + this.mHunter.toString());
        }
        if (!this.isAttached()) {
            this.setAttachKeyDefault();
        }
        this.mHunter.intoLaunchPool();
        return this.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pause() {
        Object object = this.mPauseLock;
        synchronized (object) {
            return this.mHunter.pause();
        }
    }

    @Override
    public boolean cancel() {
        return this.pause();
    }

    @Override
    public int getId() {
        if (this.mId != 0) {
            return this.mId;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mPath) && !TextUtils.isEmpty((CharSequence)this.mUrl)) {
            this.mId = FileDownloadUtils.generateId(this.mUrl, this.mPath, this.mPathAsDirectory);
            return this.mId;
        }
        return 0;
    }

    @Override
    public int getDownloadId() {
        return this.getId();
    }

    @Override
    public String getUrl() {
        return this.mUrl;
    }

    @Override
    public int getCallbackProgressTimes() {
        return this.mCallbackProgressTimes;
    }

    @Override
    public int getCallbackProgressMinInterval() {
        return this.mCallbackProgressMinIntervalMillis;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    @Override
    public boolean isPathAsDirectory() {
        return this.mPathAsDirectory;
    }

    @Override
    public String getFilename() {
        return this.mFilename;
    }

    @Override
    public String getTargetFilePath() {
        return FileDownloadUtils.getTargetFilePath(this.getPath(), this.isPathAsDirectory(), this.getFilename());
    }

    @Override
    public FileDownloadListener getListener() {
        return this.mListener;
    }

    @Override
    public int getSoFarBytes() {
        return this.getSmallFileSoFarBytes();
    }

    @Override
    public int getSmallFileSoFarBytes() {
        if (this.mHunter.getSofarBytes() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.mHunter.getSofarBytes();
    }

    @Override
    public long getLargeFileSoFarBytes() {
        return this.mHunter.getSofarBytes();
    }

    @Override
    public int getTotalBytes() {
        return this.getSmallFileTotalBytes();
    }

    @Override
    public int getSmallFileTotalBytes() {
        if (this.mHunter.getTotalBytes() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.mHunter.getTotalBytes();
    }

    @Override
    public long getLargeFileTotalBytes() {
        return this.mHunter.getTotalBytes();
    }

    @Override
    public int getSpeed() {
        return this.mHunter.getSpeed();
    }

    @Override
    public byte getStatus() {
        return this.mHunter.getStatus();
    }

    @Override
    public boolean isForceReDownload() {
        return this.mIsForceReDownload;
    }

    @Override
    public Throwable getEx() {
        return this.getErrorCause();
    }

    @Override
    public Throwable getErrorCause() {
        return this.mHunter.getErrorCause();
    }

    @Override
    public boolean isReusedOldFile() {
        return this.mHunter.isReusedOldFile();
    }

    @Override
    public Object getTag() {
        return this.mTag;
    }

    @Override
    public Object getTag(int key) {
        return this.mKeyedTags == null ? null : this.mKeyedTags.get(key);
    }

    @Override
    public boolean isContinue() {
        return this.isResuming();
    }

    @Override
    public boolean isResuming() {
        return this.mHunter.isResuming();
    }

    @Override
    public String getEtag() {
        return this.mHunter.getEtag();
    }

    @Override
    public int getAutoRetryTimes() {
        return this.mAutoRetryTimes;
    }

    @Override
    public int getRetryingTimes() {
        return this.mHunter.getRetryingTimes();
    }

    @Override
    public boolean isSyncCallback() {
        return this.mSyncCallback;
    }

    @Override
    public boolean isLargeFile() {
        return this.mHunter.isLargeFile();
    }

    @Override
    public boolean isWifiRequired() {
        return this.mIsWifiRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCreateHeader() {
        if (this.mHeader == null) {
            Object object = this.headerCreateLock;
            synchronized (object) {
                if (this.mHeader == null) {
                    this.mHeader = new FileDownloadHeader();
                }
            }
        }
    }

    @Override
    public FileDownloadHeader getHeader() {
        return this.mHeader;
    }

    @Override
    public void markAdded2List() {
        this.mIsMarkedAdded2List = true;
    }

    @Override
    public void free() {
        this.mHunter.free();
        if (FileDownloadList.getImpl().isNotContains(this)) {
            this.mIsMarkedAdded2List = false;
        }
    }

    @Override
    public void startTaskByQueue() {
        this.startTaskUnchecked();
    }

    @Override
    public void startTaskByRescue() {
        this.startTaskUnchecked();
    }

    @Override
    public Object getPauseLock() {
        return this.mPauseLock;
    }

    @Override
    public boolean isContainFinishListener() {
        return this.mFinishListenerList != null && this.mFinishListenerList.size() > 0;
    }

    @Override
    public boolean isMarkedAdded2List() {
        return this.mIsMarkedAdded2List;
    }

    @Override
    public BaseDownloadTask.IRunningTask getRunningTask() {
        return this;
    }

    @Override
    public void setFileName(String fileName) {
        this.mFilename = fileName;
    }

    @Override
    public ArrayList<BaseDownloadTask.FinishListener> getFinishListenerList() {
        return this.mFinishListenerList;
    }

    @Override
    public BaseDownloadTask getOrigin() {
        return this;
    }

    @Override
    public ITaskHunter.IMessageHandler getMessageHandler() {
        return this.mMessageHandler;
    }

    @Override
    public boolean is(int id) {
        return this.getId() == id;
    }

    @Override
    public boolean is(FileDownloadListener listener) {
        return this.getListener() == listener;
    }

    @Override
    public boolean isOver() {
        return FileDownloadStatus.isOver(this.getStatus());
    }

    @Override
    public int getAttachKey() {
        return this.mAttachKey;
    }

    @Override
    public void setAttachKeyByQueue(int key) {
        this.mAttachKey = key;
    }

    @Override
    public void setAttachKeyDefault() {
        int attachKey = this.getListener() != null ? this.getListener().hashCode() : this.hashCode();
        this.mAttachKey = attachKey;
    }

    public String toString() {
        return FileDownloadUtils.formatString("%d@%s", this.getId(), super.toString());
    }

    private static final class InQueueTaskImpl
    implements BaseDownloadTask.InQueueTask {
        private final DownloadTask mTask;

        private InQueueTaskImpl(DownloadTask task) {
            this.mTask = task;
            this.mTask.mIsInQueueTask = true;
        }

        @Override
        public int enqueue() {
            int id = this.mTask.getId();
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "add the task[%d] to the queue", id);
            }
            FileDownloadList.getImpl().addUnchecked(this.mTask);
            return id;
        }
    }
}

