/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.liulishuo.filedownloader.IFileDownloadMessenger;
import com.liulishuo.filedownloader.util.FileDownloadExecutors;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;

public class FileDownloadMessageStation {
    private static final Executor BLOCK_COMPLETED_POOL = FileDownloadExecutors.newDefaultThreadPool(5, "BlockCompleted");
    private final Handler handler;
    private final LinkedBlockingQueue<IFileDownloadMessenger> waitingQueue;
    private final Object queueLock = new Object();
    static final int HANDOVER_A_MESSENGER = 1;
    static final int DISPOSE_MESSENGER_LIST = 2;
    private final ArrayList<IFileDownloadMessenger> disposingList = new ArrayList();
    public static final int DEFAULT_INTERVAL = 10;
    public static final int DEFAULT_SUB_PACKAGE_SIZE = 5;
    static int INTERVAL = 10;
    static int SUB_PACKAGE_SIZE = 5;

    public static FileDownloadMessageStation getImpl() {
        return HolderClass.INSTANCE;
    }

    private FileDownloadMessageStation() {
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)new UIHandlerCallback());
        this.waitingQueue = new LinkedBlockingQueue();
    }

    void requestEnqueue(IFileDownloadMessenger messenger) {
        this.requestEnqueue(messenger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestEnqueue(IFileDownloadMessenger messenger, boolean immediately) {
        if (messenger.handoverDirectly()) {
            messenger.handoverMessage();
            return;
        }
        if (FileDownloadMessageStation.interceptBlockCompleteMessage(messenger)) {
            return;
        }
        if (!FileDownloadMessageStation.isIntervalValid() && !this.waitingQueue.isEmpty()) {
            Object object = this.queueLock;
            synchronized (object) {
                if (!this.waitingQueue.isEmpty()) {
                    for (IFileDownloadMessenger iFileDownloadMessenger : this.waitingQueue) {
                        this.handoverInUIThread(iFileDownloadMessenger);
                    }
                }
                this.waitingQueue.clear();
            }
        }
        if (!FileDownloadMessageStation.isIntervalValid() || immediately) {
            this.handoverInUIThread(messenger);
            return;
        }
        this.enqueue(messenger);
    }

    private void handoverInUIThread(IFileDownloadMessenger messenger) {
        this.handler.sendMessage(this.handler.obtainMessage(1, (Object)messenger));
    }

    private static boolean interceptBlockCompleteMessage(final IFileDownloadMessenger messenger) {
        if (messenger.isBlockingCompleted()) {
            BLOCK_COMPLETED_POOL.execute(new Runnable(){

                @Override
                public void run() {
                    messenger.handoverMessage();
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(IFileDownloadMessenger messenger) {
        Object object = this.queueLock;
        synchronized (object) {
            this.waitingQueue.offer(messenger);
        }
        this.push();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push() {
        int delayMillis;
        Object object = this.queueLock;
        synchronized (object) {
            if (!this.disposingList.isEmpty()) {
                return;
            }
            if (this.waitingQueue.isEmpty()) {
                return;
            }
            if (!FileDownloadMessageStation.isIntervalValid()) {
                this.waitingQueue.drainTo(this.disposingList);
                delayMillis = 0;
            } else {
                delayMillis = INTERVAL;
                int size = Math.min(this.waitingQueue.size(), SUB_PACKAGE_SIZE);
                for (int i = 0; i < size; ++i) {
                    this.disposingList.add((IFileDownloadMessenger)this.waitingQueue.remove());
                }
            }
        }
        this.handler.sendMessageDelayed(this.handler.obtainMessage(2, this.disposingList), (long)delayMillis);
    }

    public static boolean isIntervalValid() {
        return INTERVAL > 0;
    }

    private static class UIHandlerCallback
    implements Handler.Callback {
        private UIHandlerCallback() {
        }

        public boolean handleMessage(Message msg) {
            if (msg.what == 1) {
                ((IFileDownloadMessenger)msg.obj).handoverMessage();
            } else if (msg.what == 2) {
                this.dispose((ArrayList)msg.obj);
                FileDownloadMessageStation.getImpl().push();
            }
            return true;
        }

        private void dispose(ArrayList<IFileDownloadMessenger> disposingList) {
            for (IFileDownloadMessenger iFileDownloadMessenger : disposingList) {
                if (FileDownloadMessageStation.interceptBlockCompleteMessage(iFileDownloadMessenger)) continue;
                iFileDownloadMessenger.handoverMessage();
            }
            disposingList.clear();
        }
    }

    private static final class HolderClass {
        private static final FileDownloadMessageStation INSTANCE = new FileDownloadMessageStation();

        private HolderClass() {
        }
    }
}

